/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.server;

import com.digiwin.athena.ania.agent.context.AgentContext;
import com.digiwin.athena.ania.agent.server.AgentDialogueStrategy;
import com.digiwin.athena.ania.dto.AniaEventLogBuilder;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.LmcClientUtils;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AgentStrategy {
    private static final Logger log = LoggerFactory.getLogger(AgentStrategy.class);
    private static final Map<String, AgentDialogueStrategy> AGENT_DIALOGUE_MODE = new HashMap();
    @Autowired
    protected SseEventDataService sseEventDataService;

    @Autowired
    public void setAgentDialogueMode(List<AgentDialogueStrategy> agentDialogueStrategyList) {
        agentDialogueStrategyList.forEach(agentDialogueStrategy -> AGENT_DIALOGUE_MODE.put(agentDialogueStrategy.getAgentDialogueMode(), agentDialogueStrategy));
    }

    public abstract Integer getAgentType();

    public void execute(SseEventParams sseEventParam) {
        this.beforeExecute(sseEventParam);
        if (AgentContext.getSseEmitter((String)sseEventParam.getId()) != null) {
            this.beforeExecuteExtend(sseEventParam);
            this.dispatchIntentRequest(sseEventParam);
            this.afterExecuteExtend(sseEventParam);
        }
    }

    protected void beforeExecute(SseEventParams sseEventParam) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("assistantCode", sseEventParam.getAgentChatInfo().getAssistantCode());
        content.put("question", (String)sseEventParam.getAgentChatInfo());
        SaveEventLog eventLog = AniaEventLogBuilder.anAniaEventLog().withEventId(sseEventParam.getId()).withEventName("Assistant Question Start").withEventSource(sseEventParam.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(null).withStatus(Integer.valueOf(0)).withTenantId(sseEventParam.getUser().getTenantId()).withTenantName(sseEventParam.getUser().getTenantName()).withUserId(sseEventParam.getUser().getUserId()).withUserName(sseEventParam.getUser().getUserName()).withRequestParam(sseEventParam.getAgentChatInfo().getMessage().getContent()).withContent(content).build();
        LmcClientUtils.saveEventLog((SaveEventLog)eventLog, (String)sseEventParam.getUser().getToken());
    }

    public abstract void beforeExecuteExtend(SseEventParams var1);

    protected void dispatchIntentRequest(SseEventParams sseEventParam) {
        AgentDialogueStrategy agentDialogueStrategy = null;
        if (Objects.nonNull(sseEventParam.getFusionAssistant().getDialogueMode())) {
            agentDialogueStrategy = (AgentDialogueStrategy)AGENT_DIALOGUE_MODE.get(sseEventParam.getFusionAssistant().getDialogueMode().getString("mode"));
        }
        if (Objects.isNull(agentDialogueStrategy)) {
            this.sseEventDataService.sendAgentAnswerDone(sseEventParam, false);
        } else {
            agentDialogueStrategy.intentRequestAction(sseEventParam);
        }
    }

    public abstract void afterExecuteExtend(SseEventParams var1);
}

