/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.server.chat;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.digiwin.athena.ania.agent.client.sse.TopicEventSourceListener;
import com.digiwin.athena.ania.agent.server.AgentDialogueStrategy;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.LanguageUtils;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TopicConversationService
extends AgentDialogueStrategy {
    private static final Logger log = LoggerFactory.getLogger(TopicConversationService.class);

    public String getAgentDialogueMode() {
        return DialogueModeEnum.topicBasedDialogueMode.getModel();
    }

    protected void intentRequestAction(SseEventParams sseEventParam) {
        try {
            EventData eventData = new EventData(SseEventlEnum.CHAT_IN_PROGRESS.getEvent(), null);
            this.sendEventData(sseEventParam, eventData);
            FusionAssistantVo fusionAssistant = sseEventParam.getFusionAssistant();
            String url = fusionAssistant.getBaseURL() + "/assistant/chat";
            String token = sseEventParam.getUser().getToken();
            String language = LanguageUtils.processLanguage();
            JSONObject requestBody = new JSONObject();
            requestBody.put("assistantId", (Object)sseEventParam.getQuestionMessage().getAgentId());
            requestBody.put("conversationId", (Object)sseEventParam.getQuestionMessage().getConversationId());
            String contentText = "";
            String contentStr = sseEventParam.getAgentChatInfo().getMessage().getContent();
            if (StringUtils.isNotBlank((CharSequence)contentStr)) {
                contentText = JSON.isValidObject((String)contentStr) ? JSON.parseObject((String)contentStr).getString("text") : contentStr;
            }
            JSONObject message = new JSONObject().fluentPut("content", (Object)contentText).fluentPut("attachments", (Object)sseEventParam.getAgentChatInfo().getMessage().getAttachment()).fluentPut("extData", (Object)sseEventParam.getQuestionMessage().getExt()).fluentPut("messageId", (Object)sseEventParam.getQuestionMessage().getMessageId()).fluentPut("sectionId", (Object)sseEventParam.getQuestionMessage().getSectionId());
            requestBody.put("message", (Object)message);
            log.info("TopicConversationService.intentRequestAction.param:{}", (Object)JSON.toJSONString((Object)requestBody));
            TopicEventSourceListener sseListener = new TopicEventSourceListener(sseEventParam, this.sseEventDataService);
            EventStreamClient.executeSSE((String)url, null, (String)token, (EventSourceListener)sseListener, (JSONObject)requestBody, (String)language);
        }
        catch (Exception e) {
            log.info("DesignerSceneService.intentRequestAction error SseEventParams:{}", (Object)JSONUtil.toJsonStr((Object)sseEventParam), (Object)e);
            String errorMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u667a\u80fd\u52a9\u7406\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u667a\u80fd\u52a9\u7406\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            this.errorStop(sseEventParam, errorMsg);
        }
    }
}

