/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.aspect;

import com.digiwin.athena.ania.aspect.Lock;
import com.digiwin.athena.ania.common.BizException;
import com.digiwin.athena.ania.configuration.RedisLock;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    @Resource
    private RedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(lock)")
    public Object around(ProceedingJoinPoint point, Lock lock) throws Throwable {
        String tryLock = null;
        String key = StringUtils.isBlank((CharSequence)lock.key()) ? "ANIA_" + this.getClassAndMethodName(point) : lock.key();
        try {
            tryLock = this.redisLock.tryLock(key, lock.expire());
            if (Objects.isNull(tryLock)) {
                log.error("tryLock fail", (Object)lock.failDsc());
                throw new BizException(Integer.valueOf(500), "tryLock fail", "en-US");
            }
            Object object = point.proceed();
            return object;
        }
        finally {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(key, tryLock);
            }
        }
    }

    private String getClassAndMethodName(ProceedingJoinPoint point) {
        Object target = point.getTarget();
        String name = target.getClass().getName();
        MethodSignature signature = (MethodSignature)point.getSignature();
        String methodName = signature.getName();
        return name + "-" + methodName;
    }
}

