/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.common.enums;

import com.digiwin.athena.ania.common.enums.TaskTypeEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum CardTypeEnum {
    COLLECT("collect", "\u6536\u96c6", "\u6536\u96c6", Integer.valueOf(3)),
    COLLECTFILE("collectFile", "\u6536\u96c6\u6587\u4ef6", "\u6536\u96c6\u6587\u4ef6", Integer.valueOf(3)),
    COLLECT_CONFIRM("collectConfirm", "\u6536\u96c6", "\u6536\u96c6", Integer.valueOf(3)),
    COLLECT_FILE_AND_DESC("collectFileAndDesc", "\u6536\u96c6\u6587\u4ef6", "\u6536\u96c6\u6587\u4ef6", Integer.valueOf(3)),
    COLLECT_DATETIME_RANGE_PRIOR("datetimeRangePrior", "\u65f6\u95f4\u533a\u95f4\u8fc7\u957f\u786e\u8ba4", "\u6642\u9593\u5340\u9593\u904e\u9577\u78ba\u8a8d", Integer.valueOf(3)),
    COLLECT_OPTION("collectOption", "\u6536\u96c6\u9009\u9879", "\u6536\u96c6\u9078\u9805", Integer.valueOf(3)),
    COLLECTNEEDUSER("collectNeedUser", "\u6536\u96c6\u662f\u5426\u9700\u4eba\u5458", "\u6536\u96c6\u662f\u5426\u9700\u4eba\u54e1", Integer.valueOf(3)),
    COLLECTNOUSER("collectNoUser", "\u6536\u96c6\u4eba\u5458\uff08\u65e0\u4eba\uff09", "\u6536\u96c6\u4eba\u54e1\uff08\u7121\u4eba\uff09", Integer.valueOf(3)),
    COLLECTHASUSER("collectHasUser", "\u6536\u96c6\u4eba\u5458\uff08\u6709\u4eba\uff09", "\u6536\u96c6\u4eba\u54e1\uff08\u6709\u4eba\uff09", Integer.valueOf(3)),
    COLLECTCHOOSEUSER("collectChooseUser", "\u6536\u96c6\u4eba\u5458\uff08\u9009\u62e9\uff09", "\u6536\u96c6\u4eba\u54e1\uff08\u9078\u64c7\uff09", Integer.valueOf(3)),
    COLLECTHASGROUPUSER("collectHasGroupUser", "\u6536\u96c6\u7fa4\u7ec4\u4eba\u5458\uff08\u6709\u4eba\uff09", "\u6536\u96c6\u7fa4\u7d44\u4eba\u54e1\uff08\u6709\u4eba\uff09", Integer.valueOf(3)),
    COLLECTCHOOSEGROUPUSER("collectChooseGroupUser", "\u6536\u96c6\u7fa4\u7ec4\u4eba\u5458\uff08\u9009\u62e9\uff09", "\u6536\u96c6\u7fa4\u7d44\u4eba\u54e1\uff08\u9078\u64c7\uff09", Integer.valueOf(3)),
    COLLECTCONCERTUSER("collectConcertUser", "\u6536\u96c6\u591a\u534f\u4f5c\u4eba\u5458\uff08\u6709\u4eba\uff09", "\u6536\u96c6\u591a\u5354\u4f5c\u4eba\u54e1\uff08\u6709\u4eba\uff09", Integer.valueOf(3)),
    COLLECTCHOOSEMANYGROUP("collectChooseManyGroup", "\u6536\u96c6\u786e\u5b9a\u7fa4\u7ec4\uff08\u591a\u4e2a\u6a21\u7cca\u5339\u914d\uff09", "\u6536\u96c6\u78ba\u5b9a\u7fa4\u7d44\uff08\u591a\u500b\u6a21\u7cca\u5339\u914d\uff09", Integer.valueOf(3)),
    COLLECTUSERGROUP("collectUserGroup", "\u6536\u96c6\u4eba\u5458\u7fa4\u7ec4", "\u6536\u96c6\u4eba\u54e1\u7fa4\u7d44", Integer.valueOf(3)),
    NOTIFICATION("notification", "\u901a\u77e5", "\u901a\u77e5", Integer.valueOf(1)),
    CONSULT("consult", "\u534f\u5546", "\u5354\u5546", Integer.valueOf(2)),
    FAILAGAINCONSULT("failAgainConsult", "\u534f\u5546\u5931\u8d25\u518d\u6b21\u534f\u5546", "\u5354\u5546\u5931\u6557\u518d\u6b21\u5354\u5546", Integer.valueOf(2)),
    SOMECONSULT("someConsult", "\u90e8\u5206\u534f\u5546", "\u90e8\u5206\u5354\u5546", Integer.valueOf(2)),
    FAILCONSULT("failConsult", "\u4e8c\u6b21\u534f\u5546\u5931\u8d25\u540e\u5904\u7406", "\u4e8c\u6b21\u5354\u5546\u5931\u6557\u5f8c\u8655\u7406", Integer.valueOf(2)),
    RESTARTCONSULT("restartConsult", "\u4e8c\u6b21\u534f\u5546\u5931\u8d25\u540e\u66f4\u65b0\u8981\u7d20\u518d\u534f\u5546", "\u4e8c\u6b21\u5354\u5546\u5931\u6557\u5f8c\u66f4\u65b0\u8981\u7d20\u518d\u5354\u5546", Integer.valueOf(2)),
    SPECIFYCONSULT("specifyConsult", "\u76f4\u63a5\u6307\u5b9a\u8981\u7d20", "\u76f4\u63a5\u6307\u5b9a\u8981\u7d20", Integer.valueOf(2)),
    MINUTES_START_MEETING("minutesStartMeeting", "\u4f1a\u8bae\u8bb0\u5f55", "\u6703\u8b70\u8a18\u9304", Integer.valueOf(TaskTypeEnum.MEETING.getType())),
    MINUTES_MEETING_MINUTES("minutesMeetingMinutes", "\u4f1a\u8bae\u7eaa\u8981", "\u6703\u8b70\u7d00\u8981", Integer.valueOf(TaskTypeEnum.MEETING.getType())),
    MEETING_MINUTES_CFM("meetingMinutesCfm", "\u786e\u8ba4\u4f1a\u8bae\u7eaa\u8981", "\u78ba\u8a8d\u6703\u8b70\u7d00\u8981", Integer.valueOf(TaskTypeEnum.MEETING.getType())),
    MINUTES_BACK_LOG("minutesBackLog", "\u6536\u96c6\u4f1a\u8bae\u7eaa\u8981\u5f85\u529e", "\u6536\u96c6\u6703\u8b70\u7d00\u8981\u5f85\u8fa6", Integer.valueOf(TaskTypeEnum.MEETING.getType())),
    MEETING_PENDING_MINUTES_CFM("meetingPendingMinutesCfm", "\u786e\u8ba4\u4f1a\u8bae\u5f85\u529e", "\u78ba\u8a8d\u6703\u8b70\u5f85\u8fa6", Integer.valueOf(TaskTypeEnum.MEETINGPENDING.getType())),
    MEETING_PENDING_MINUTES_BACK_LOG("meetingPendingMinutesBackLog", "\u6536\u96c6\u4f1a\u8bae\u7eaa\u8981\u5f85\u529e", "\u6536\u96c6\u6703\u8b70\u7d00\u8981\u5f85\u8fa6", Integer.valueOf(TaskTypeEnum.MEETINGPENDING.getType())),
    COLLECT_TASK("collectTask", "\u6536\u96c6", "\u6536\u96c6", Integer.valueOf(TaskTypeEnum.COLLECT_TASK.getType())),
    COLLECT_VISITING_METHODS("COLLECT_VISITING_METHODS", "\u6536\u96c6\u62dc\u8bbf\u65b9\u5f0f", "\u6536\u96c6\u62dc\u8a2a\u65b9\u5f0f", Integer.valueOf(TaskTypeEnum.COLLECT_VISIT_METHODS.getType())),
    COLLECT_MEETING_FROM("COLLECT_MEETING_FROM", "\u4f1a\u8bae\u8868\u5355", "\u6703\u8b70\u8868\u55ae", Integer.valueOf(TaskTypeEnum.GP_INPUT.getType())),
    COLLECT_QIAGONG_FROM("COLLECT_QIAGONG_FROM", "\u6d3d\u516c\u8868\u5355", "\u6d3d\u516c\u8868\u55ae", Integer.valueOf(TaskTypeEnum.GP_INPUT.getType())),
    COLLECT_REIMBURSE_FROM("COLLECT_REIMBURSE_FROM", "\u62a5\u9500\u8868\u5355", "\u5831\u92b7\u8868\u55ae", Integer.valueOf(TaskTypeEnum.GP_INPUT.getType())),
    CONFERENCE_LIST("conferenceList", "\u4f1a\u52a1\u540d\u5355\u6536\u96c6", "\u6703\u52d9\u540d\u55ae\u6536\u96c6", Integer.valueOf(TaskTypeEnum.COLLECT_CONFERENCELIST_TASK.getType())),
    CONFERENCE_INFO_CONFIRM("conference_info_confirm", "\u4f1a\u52a1\u4fe1\u606f\u786e\u8ba4", "\u6703\u52d9\u4fe1\u606f\u78ba\u8a8d", Integer.valueOf(TaskTypeEnum.CONFERENCE_INFO_CONFIRM_TASK.getType())),
    CONFERENCE_SIGNIN("conference_signIn", "\u4f1a\u52a1\u7b7e\u5230", "\u6703\u52d9\u7c3d\u5230", Integer.valueOf(TaskTypeEnum.CONFERENCE_SIGNIN_TASK.getType())),
    MEAL_VOUCHER_SUBSIDIARY("meal_voucher_subsidiary", "\u9644\u5e26\u9910\u5238\u6d3e\u53d1", "\u9644\u5e36\u9910\u5238\u6d3e\u767c", Integer.valueOf(TaskTypeEnum.MEAL_VOUCHER_ISSUANCE.getType())),
    MEAL_VOUCHER("meal_voucher", "\u9910\u5238", "\u9910\u5238", Integer.valueOf(TaskTypeEnum.MEAL_VOUCHER_ISSUANCE.getType()));

    private final String code;
    private final String name;
    private final String traditionalname;
    private final Integer taskType;

    public static CardTypeEnum getCardTypeEnum(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (CardTypeEnum elementEnum : CardTypeEnum.values()) {
            if (!elementEnum.code.equals(code)) continue;
            return elementEnum;
        }
        return null;
    }

    public static boolean isMeetingCard(String code) {
        CardTypeEnum cardTypeEnum = CardTypeEnum.getCardTypeEnum((String)code);
        return Objects.nonNull(cardTypeEnum) && cardTypeEnum.getTaskType().intValue() == TaskTypeEnum.MEETING.getType();
    }

    public static boolean isMeetingPendingCard(String code) {
        CardTypeEnum cardTypeEnum = CardTypeEnum.getCardTypeEnum((String)code);
        return Objects.nonNull(cardTypeEnum) && cardTypeEnum.getTaskType().intValue() == TaskTypeEnum.MEETINGPENDING.getType();
    }

    public static boolean isFormCard(String code) {
        CardTypeEnum cardTypeEnum = CardTypeEnum.getCardTypeEnum((String)code);
        return Objects.nonNull(cardTypeEnum) && cardTypeEnum.getTaskType().intValue() == TaskTypeEnum.GP_INPUT.getType();
    }

    public static boolean isCollectConcertUserCard(String code) {
        return COLLECTCONCERTUSER.getCode().equals(code);
    }

    public static boolean isConferenceSignInCard(String code) {
        return CONFERENCE_SIGNIN.getCode().equals(code);
    }

    public static Integer getCardTaskType(String code) {
        CardTypeEnum cardTypeEnum = CardTypeEnum.getCardTypeEnum((String)code);
        return Objects.nonNull(cardTypeEnum) ? cardTypeEnum.getTaskType() : null;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getTraditionalname() {
        return this.traditionalname;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    private CardTypeEnum(String code, String name, String traditionalname, Integer taskType) {
        this.code = code;
        this.name = name;
        this.traditionalname = traditionalname;
        this.taskType = taskType;
    }
}

