/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    private static final String DATASOURCE_NAME = "dbDataSource";
    @Value(value="${spring.datasource.druid.max-active:8}")
    private int maxActive;
    @Value(value="${spring.datasource.druid.initial-size:0}")
    private int initialSize;
    @Value(value="${spring.datasource.druid.min-idle:0}")
    private int minIdle;
    private static final String BUSINESS_DATASOURCE_PREFIX = "spring.datasource.druid.business";

    @Primary
    @Bean(name={"dbDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.druid.business")
    public DruidDataSource druidDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setMaxActive(this.maxActive);
        dataSource.setInitialSize(this.initialSize);
        dataSource.setMinIdle(this.minIdle);
        return dataSource;
    }

    @Bean(name={"dataSourceTransactionManager"})
    @DependsOn(value={"dbDataSource"})
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }
}

