/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.configuration.MongoInterceptor;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.event.CommandListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoTemplateConfig {
    @Value(value="${spring.data.mongodb.uri}")
    private String uriLog;
    @Value(value="${spring.data.mongodb.database}")
    private String databaseMessage;
    @Value(value="${spring.data.mongodb1.uri}")
    private String asaUri;
    @Value(value="${spring.data.mongodb1.database}")
    private String asaDatabase;

    @Primary
    @Bean(value={"semcMessageMongoTemplate"})
    public MongoTemplate semcMessageMongoTemplate() {
        MongoInterceptor listener = new MongoInterceptor();
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).addCommandListener((CommandListener)listener).build(), null);
        return new MongoTemplate((MongoClient)client, this.databaseMessage);
    }

    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoInterceptor listener = new MongoInterceptor();
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.asaUri)).addCommandListener((CommandListener)listener).build(), null);
        return new MongoTemplate((MongoClient)client, this.asaDatabase);
    }

    @Bean(value={"asaMongoTemplate"})
    public MongoTemplate asaMongoTemplate() {
        MongoInterceptor listener = new MongoInterceptor();
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.asaUri)).addCommandListener((CommandListener)listener).build(), null);
        return new MongoTemplate((MongoClient)client, this.asaDatabase);
    }
}

