/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.exception.FusionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice(annotations={RestController.class, Controller.class})
public class RestControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(RestControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    ResponseEntity<ResultBean> handleControllerException(HttpServletRequest request, Throwable ex) {
        HttpStatus status = this.getStatus(request);
        if (ex instanceof ServiceException) {
            ServiceException le = (ServiceException)ex;
            return new ResponseEntity((Object)new ResultBean(le), HttpStatus.ACCEPTED);
        }
        logger.error(ex.getMessage(), ex);
        return new ResponseEntity((Object)new ResultBean(Integer.valueOf(status.value()), Integer.valueOf(status.value()), ex.getMessage()), status);
    }

    @ResponseBody
    @ExceptionHandler(value={FusionException.class})
    ResponseEntity<ResultBean> handleControllerException(HttpServletRequest request, FusionException ex) {
        return new ResponseEntity((Object)new ResultBean(null, ex.getCode(), ex.getMessage()), this.getStatus(request));
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }
}

