/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration.mqtt;

import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MqttPublisher {
    @Autowired(required=false)
    private MqttClient mqttClient;

    public void publish(String topic, String message) {
        try {
            MqttMessage mqttMessage = new MqttMessage(message.getBytes(StandardCharsets.UTF_8));
            mqttMessage.setQos(1);
            this.mqttClient.publish(topic, mqttMessage);
        }
        catch (MqttException e) {
            throw new RuntimeException("Failed to publish MQTT message", e);
        }
    }
}

