/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.consumer;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.consumer.constant.MessageTypeEnum;
import com.digiwin.athena.ania.service.notice.NoticeService;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.kafka.open"}, havingValue="true")
public class KafkaConsumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    @Autowired
    private NoticeService noticeService;

    @KafkaListener(topics={"nna-app-message"})
    public void listen(ConsumerRecord<String, String> record) {
        String messageStr = (String)record.value();
        log.info("Received Kafka message from partition {}: {}", (Object)record.partition(), (Object)messageStr);
        if (StrUtil.isBlank((CharSequence)messageStr)) {
            log.debug("Skipping empty message from partition {}", (Object)record.partition());
            return;
        }
        try {
            JSONObject message = JSONObject.parseObject((String)messageStr);
            JSONObject payload = message.getJSONObject("payload");
            if (payload == null || payload.isEmpty()) {
                log.warn("Invalid message format: missing or empty 'payload' field");
                return;
            }
            String messageType = payload.getString("messageType");
            if (MessageTypeEnum.NEWCHAT.name().equals(messageType)) {
                this.noticeService.conversationEvent(MessageAction.UPDATE, (Map)message);
            } else {
                log.debug("Ignored message type: {}", (Object)messageType);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse JSON message: {}", (Object)messageStr, (Object)e);
        }
    }
}

