/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.ttl.TtlRunnable;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.dto.AnswerMessageVo;
import com.digiwin.athena.ania.knowledge.KnowledgeAssistantService;
import com.digiwin.athena.ania.knowledge.server.AssistantSSeComponent;
import com.digiwin.athena.ania.knowledge.server.KnowledgeAssistantComponent;
import com.digiwin.athena.ania.knowledge.server.dto.AssistantQuestionDto;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.KnowledgeAssistantRequestDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.service.scene.SseEmitterCallbackComponent;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/ania/assistant"})
@Deprecated
public class KnowledgeAssistantController {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeAssistantController.class);
    @Resource
    private Executor taskExecutorKnow;
    @Resource
    private KnowledgeAssistantService knowledgeAssistantService;
    @Resource
    private KnowledgeAssistantComponent knowledgeAssistantComponent;
    @Resource
    private SseEmitterCallbackComponent sseEmitterCallbackComponent;
    @Resource
    private AssistantSSeComponent assistantSSeComponent;

    @PostMapping(value={"/processquestion"}, produces={"text/event-stream"})
    public SseEmitter processQuestion(@RequestBody KnowledgeAssistantRequestDto knowledgeAssistantRequestDto, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("KnowledgeAssistantController.processQuestion: {}", (Object)JSON.toJSONString((Object)knowledgeAssistantRequestDto));
        knowledgeAssistantRequestDto.setUserId(authoredUser.getUserId());
        knowledgeAssistantRequestDto.setTenantId(authoredUser.getTenantId());
        SseEmitter sseEmitter = this.knowledgeAssistantComponent.processQuestion(knowledgeAssistantRequestDto);
        return sseEmitter;
    }

    @PostMapping(value={"/getMessagesByIds"})
    public ResultBean<List<AnswerMessageVo>> getMessagesByIds(@RequestBody Map<String, List<String>> msgIds, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResultBean.success((Object)this.knowledgeAssistantService.getMessagesByIds(msgIds));
    }

    @GetMapping(value={"/sse/disconnect"})
    public ResultBean sseDisconnect(String id) {
        return ResultBean.success();
    }

    @PostMapping(value={"/v2/processquestion"}, produces={"text/event-stream"})
    public SseEmitter processQuestionV2(@RequestBody AssistantQuestionDto question, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("KnowledgeAssistantController.processQuestionV2: {}", (Object)JSON.toJSONString((Object)question));
        SseEventParams sseEventParams = new SseEventParams();
        String language = LanguageUtils.processSseLanguage();
        sseEventParams.setLanguage(language);
        HisAssistantChatDto hisAssistantChat = question.getHisAssistantChat();
        sseEventParams.setQuestion(hisAssistantChat);
        sseEventParams.setUser(authoredUser);
        sseEventParams.setAssistantType(AssistantType.HISTORY_ASSISTANT.getType());
        String traceId = MdcUtil.get((String)"PtxId");
        if (StrUtil.isBlank((CharSequence)traceId)) {
            traceId = MdcUtil.getTraceId();
        }
        sseEventParams.setTraceId(traceId);
        SseEmitter sseEmitter = this.sseEmitterCallbackComponent.generateSseEmitter(sseEventParams);
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        CompletableFuture.runAsync((Runnable)TtlRunnable.get(() -> {
            try {
                MdcUtil.setTraceId((String)sseEventParams.getTraceId());
                MdcUtil.put((String)"routerKey", (String)authoredUser.getTenantId());
                LocaleContextHolder.setLocale((Locale)Locale.forLanguageTag(langName));
                this.assistantSSeComponent.nlp(sseEventParams);
            }
            catch (Exception e) {
                log.error("processQuestionV2.nlp.error params: {}", (Object)sseEventParams, (Object)e);
            }
            finally {
                MdcUtil.clear();
                LocaleContextHolder.resetLocaleContext();
            }
        }), this.taskExecutorKnow);
        return sseEmitter;
    }
}

