/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.dialogue;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.dto.conversation.ConversationVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionAddDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionDeleteDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionQueryDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.service.assistant.FusionAssistantQuestionService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.assistant.FusionEventService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="assistant")
@RequestMapping(value={"/ania/fusion/assistant"})
public class FusionAssistantController {
    private static final Logger log = LoggerFactory.getLogger(FusionAssistantController.class);
    @Autowired
    private FusionEventService fusionEventService;
    @Autowired
    private FusionAssistantService fusionAssistantService;
    @Autowired
    private FusionAssistantQuestionService fusionAssistantQuestionService;
    @Resource
    private ConversationService conversationService;

    @PostMapping(value={"/publishEvent"})
    @ApiOperation(value="\u53d1\u5e03\u4e8b\u4ef6")
    private ResultBean publishEvent(@Validated @RequestBody FusionAssistantPublishDto dto) {
        this.fusionEventService.event(dto);
        return ResultBean.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u878d\u5408\u52a9\u7406\u5217\u8868")
    private ResultBean assistantList(HttpServletRequest request) {
        String clientType = request.getParameter("clientType");
        Boolean simple = Boolean.parseBoolean(request.getParameter("simple"));
        log.info("FusionAssistantController.assistantList.start: clientType : {}, simple: {}", (Object)clientType, (Object)simple);
        List fusionAssistantVos = this.fusionAssistantService.assistantList(clientType, simple);
        log.info("FusionAssistantController.assistantList.end: {}" + fusionAssistantVos.size());
        return ResultBean.success((Object)fusionAssistantVos);
    }

    @GetMapping(value={"/info"})
    @ApiOperation(value="\u878d\u5408\u52a9\u7406\u8be6\u60c5")
    private ResultBean assistantInfo(FusionAssistantInfoDto dto) {
        ConversationVo conversationVo;
        FusionAssistantVo fusionAssistant = this.fusionAssistantService.assistantInfo(dto);
        if (Objects.isNull(fusionAssistant)) {
            return ResultBean.fail((String)"FusionAssistant Is No Permission OR No Exist");
        }
        if (DialogueModeEnum.longDialogueMode.equals((Object)fusionAssistant.getDialogueModeEnum()) && Objects.nonNull(conversationVo = this.conversationService.getAgentLatestConversationInfo(fusionAssistant.getAssistantId()))) {
            fusionAssistant.setHasConversation(Boolean.valueOf(true));
            fusionAssistant.setConversationId(conversationVo.getConversationId());
        }
        return ResultBean.success((Object)fusionAssistant);
    }

    @PostMapping(value={"/question/add"})
    @ApiOperation(value="\u5e38\u7528\u95ee\u9898\u6dfb\u52a0")
    private ResultBean add(@Validated @RequestBody FusionAssistantQuestionAddDto dto) {
        this.fusionAssistantQuestionService.add(dto);
        return ResultBean.success();
    }

    @PostMapping(value={"/question/list"})
    @ApiOperation(value="\u5e38\u7528\u95ee\u9898\u67e5\u8be2")
    private ResultBean questionList(@Validated @RequestBody FusionAssistantQuestionQueryDto dto) {
        log.info("FusionAssistantController.questionList.start: {}", (Object)JSON.toJSONString((Object)dto));
        List questionVoList = this.fusionAssistantQuestionService.findByAssistantId(dto);
        log.info("FusionAssistantController.questionList.end: {}", (Object)questionVoList.size());
        return ResultBean.success((Object)questionVoList);
    }

    @PostMapping(value={"/question/delete"})
    @ApiOperation(value="\u5e38\u7528\u95ee\u9898\u5220\u9664")
    private ResultBean questionDelete(@Validated @RequestBody FusionAssistantQuestionDeleteDto dto) {
        this.fusionAssistantQuestionService.deleteQuestionItemById(dto);
        return ResultBean.success();
    }
}

