/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.dialogue;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.dto.notice.NoticeDto;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="assistant")
@RequestMapping(value={"/ania/assistant/notice"})
public class NoticeController {
    private static final Logger log = LoggerFactory.getLogger(NoticeController.class);
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private FusionAssistantService fusionAssistantService;

    @PostMapping(value={"/send"})
    @ApiOperation(value="\u901a\u77e5")
    private ResultBean<String> send(@Validated @RequestBody NoticeDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (StrUtil.isBlank((CharSequence)dto.getAssistantName()) || StrUtil.isBlank((CharSequence)dto.getIconUrl())) {
            FusionAssistantInfoDto param = FusionAssistantInfoDto.builder().assistantId(dto.getAssistantId()).auth(Boolean.valueOf(false)).build();
            FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(param, authoredUser);
            Assert.notNull((Object)fusionAssistantVo, () -> new ServiceException("\u53d1\u9001\u901a\u77e5\u6d88\u606f\u5931\u8d25\uff0c\u672a\u627e\u5230\u52a9\u7406\u4fe1\u606f"));
            dto.setIconUrl(fusionAssistantVo.getIconUrl());
            dto.setAssistantName(fusionAssistantVo.getAssistantName());
        }
        dto.setTenantId(authoredUser.getTenantId());
        this.noticeService.noticeMessage(MessageAction.CREATED, dto);
        return ResultBean.success();
    }
}

