/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.router;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpUtil;
import com.digiwin.athena.ania.env.EnvProperties;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="router")
@RequestMapping(value={"/ania/dingrouter"})
public class DingdingRouterController {
    private static final Logger log = LoggerFactory.getLogger(DingdingRouterController.class);
    @Autowired
    private EnvProperties envProperties;
    private static final String REDIRECT_LOGIN_URL_TEMPLATE = "%s/login/dingtalk-login?";
    private static final String HOME_PAGE_REDIRECT_TEMPLATE = "%s";

    @Operation(method="routingDistribution", description="\u8def\u7531\u5206\u53d1")
    @GetMapping(value={"/routingDistribution"})
    public ResponseEntity<?> routingJudgment(HttpServletRequest request, String assistantCode, String appId, String tenantId, HttpServletResponse response) throws IOException {
        String queryString = request.getQueryString();
        log.info("queryString:{}", (Object)queryString);
        log.info("DingdingRouterController.routingJudgment.param tenantId:{},appId:{},assistantCode:{}", new Object[]{tenantId, appId, assistantCode});
        String userAgent = request.getHeader("User-Agent");
        request.getParameter("userId");
        if (userAgent != null && (userAgent.contains("Windows") || userAgent.contains("Macintosh"))) {
            this.handlePcLogin(request, assistantCode, appId, tenantId, response);
        } else if (userAgent != null && userAgent.contains("Mobile")) {
            String url = this.handleMobileTask(request, assistantCode, appId, tenantId, response);
            response.sendRedirect(url);
        }
        return null;
    }

    private ResponseEntity<?> handlePcLogin(HttpServletRequest request, String assistantCode, String appId, String tenantId, HttpServletResponse response) throws IOException {
        String redirectUrl = HttpUtil.urlWithForm((String)String.format(REDIRECT_LOGIN_URL_TEMPLATE, this.envProperties.getAniaWebUri()), (String)request.getQueryString(), (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false);
        log.info("redirectUrl:{}", (Object)redirectUrl);
        response.sendRedirect(redirectUrl);
        log.info("Authorization successful, redirecting to details.");
        return null;
    }

    private void redirectToHomePage(HttpServletResponse response, String uri) throws IOException {
        String homePageUrl = String.format(HOME_PAGE_REDIRECT_TEMPLATE, uri);
        response.sendRedirect(homePageUrl);
        log.info("Authorization failed, redirecting to home page.");
    }

    private String handleMobileTask(HttpServletRequest request, String assistantCode, String appId, String tenantId, HttpServletResponse response) throws IOException {
        String redirectUrl = HttpUtil.urlWithForm((String)String.format(REDIRECT_LOGIN_URL_TEMPLATE, this.envProperties.getMobileUri()), (String)request.getQueryString(), (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false);
        response.sendRedirect(redirectUrl);
        log.info("Authorization successful, redirecting to details.");
        return null;
    }
}

