/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.dto.AssistantMongoDto;
import java.util.List;

public class AssistantMongoDto {
    private String version;
    private List<Integer> assistantTypes;
    private List<String> clientTypes;
    private String tenantId;
    private Integer status;
    private Boolean orSourceCustom;
    private String assistantCode;

    public AssistantMongoDto constructClientTypes(String clientType) {
        this.clientTypes = StrUtil.isNotEmpty((CharSequence)clientType) ? ListUtil.toList((Object[])new String[]{clientType}) : ListUtil.toList((Object[])new String[]{"APP"});
        return this;
    }

    public AssistantMongoDto constructAssistantTypesToB() {
        this.assistantTypes = ListUtil.toList((Object[])new Integer[]{1});
        return this;
    }

    public AssistantMongoDto constructTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AssistantMongoDto constructOrSourceCustom() {
        this.orSourceCustom = true;
        return this;
    }

    public static AssistantMongoDto constructAssistantList(String tenantVersion, String clientType, String assistantCode) {
        AssistantMongoDto assistantMongoDto = new AssistantMongoDto();
        assistantMongoDto.setStatus(Integer.valueOf(1));
        assistantMongoDto.setVersion(tenantVersion);
        assistantMongoDto.constructAssistantTypesToB();
        if (StrUtil.isNotBlank((CharSequence)clientType)) {
            assistantMongoDto.constructClientTypes(clientType);
        }
        if (StrUtil.isNotEmpty((CharSequence)assistantCode)) {
            assistantMongoDto.setAssistantCode(assistantCode);
        }
        return assistantMongoDto;
    }

    public static AssistantMongoDtoBuilder builder() {
        return new AssistantMongoDtoBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public List<Integer> getAssistantTypes() {
        return this.assistantTypes;
    }

    public List<String> getClientTypes() {
        return this.clientTypes;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Boolean getOrSourceCustom() {
        return this.orSourceCustom;
    }

    public String getAssistantCode() {
        return this.assistantCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAssistantTypes(List<Integer> assistantTypes) {
        this.assistantTypes = assistantTypes;
    }

    public void setClientTypes(List<String> clientTypes) {
        this.clientTypes = clientTypes;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setOrSourceCustom(Boolean orSourceCustom) {
        this.orSourceCustom = orSourceCustom;
    }

    public void setAssistantCode(String assistantCode) {
        this.assistantCode = assistantCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistantMongoDto)) {
            return false;
        }
        AssistantMongoDto other = (AssistantMongoDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List this$assistantTypes = this.getAssistantTypes();
        List other$assistantTypes = other.getAssistantTypes();
        if (this$assistantTypes == null ? other$assistantTypes != null : !((Object)this$assistantTypes).equals(other$assistantTypes)) {
            return false;
        }
        List this$clientTypes = this.getClientTypes();
        List other$clientTypes = other.getClientTypes();
        if (this$clientTypes == null ? other$clientTypes != null : !((Object)this$clientTypes).equals(other$clientTypes)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$orSourceCustom = this.getOrSourceCustom();
        Boolean other$orSourceCustom = other.getOrSourceCustom();
        if (this$orSourceCustom == null ? other$orSourceCustom != null : !((Object)this$orSourceCustom).equals(other$orSourceCustom)) {
            return false;
        }
        String this$assistantCode = this.getAssistantCode();
        String other$assistantCode = other.getAssistantCode();
        return !(this$assistantCode == null ? other$assistantCode != null : !this$assistantCode.equals(other$assistantCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssistantMongoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List $assistantTypes = this.getAssistantTypes();
        result = result * 59 + ($assistantTypes == null ? 43 : ((Object)$assistantTypes).hashCode());
        List $clientTypes = this.getClientTypes();
        result = result * 59 + ($clientTypes == null ? 43 : ((Object)$clientTypes).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $orSourceCustom = this.getOrSourceCustom();
        result = result * 59 + ($orSourceCustom == null ? 43 : ((Object)$orSourceCustom).hashCode());
        String $assistantCode = this.getAssistantCode();
        result = result * 59 + ($assistantCode == null ? 43 : $assistantCode.hashCode());
        return result;
    }

    public String toString() {
        return "AssistantMongoDto(version=" + this.getVersion() + ", assistantTypes=" + this.getAssistantTypes() + ", clientTypes=" + this.getClientTypes() + ", tenantId=" + this.getTenantId() + ", status=" + this.getStatus() + ", orSourceCustom=" + this.getOrSourceCustom() + ", assistantCode=" + this.getAssistantCode() + ")";
    }

    public AssistantMongoDto(String version, List<Integer> assistantTypes, List<String> clientTypes, String tenantId, Integer status, Boolean orSourceCustom, String assistantCode) {
        this.version = version;
        this.assistantTypes = assistantTypes;
        this.clientTypes = clientTypes;
        this.tenantId = tenantId;
        this.status = status;
        this.orSourceCustom = orSourceCustom;
        this.assistantCode = assistantCode;
    }

    public AssistantMongoDto() {
    }
}

