/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HisConversationMessageDto
extends ImMessageLog {
    private String sectionId;
    private List<Map> headerInfos;
    private List<Map> content;
    private List<Map> followUp;
    private String role;

    public HisConversationMessageDto(ConversationMessage conversationMsg) {
        this.headerInfos = conversationMsg.getHeaderInfos();
        this.content = conversationMsg.getContent();
        this.followUp = conversationMsg.getFollowUp();
        this.role = Objects.equals(1, conversationMsg.getUserType()) ? "user" : "assistant";
        this.sectionId = conversationMsg.getSectionId();
        super.setMsgTimestamp(conversationMsg.getCreateTime());
        super.setMsgType(conversationMsg.getMsgType());
        super.setMsgidServer(conversationMsg.getMessageId());
        super.setMsgidClient(conversationMsg.getMessageId());
        super.setMsgBody(conversationMsg.getMsgBody());
        super.setMsgExt(new JSONObject(conversationMsg.getExt()));
        super.setFromUserId(conversationMsg.getUserId());
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public List<Map> getHeaderInfos() {
        return this.headerInfos;
    }

    public List<Map> getContent() {
        return this.content;
    }

    public List<Map> getFollowUp() {
        return this.followUp;
    }

    public String getRole() {
        return this.role;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setHeaderInfos(List<Map> headerInfos) {
        this.headerInfos = headerInfos;
    }

    public void setContent(List<Map> content) {
        this.content = content;
    }

    public void setFollowUp(List<Map> followUp) {
        this.followUp = followUp;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HisConversationMessageDto)) {
            return false;
        }
        HisConversationMessageDto other = (HisConversationMessageDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sectionId = this.getSectionId();
        String other$sectionId = other.getSectionId();
        if (this$sectionId == null ? other$sectionId != null : !this$sectionId.equals(other$sectionId)) {
            return false;
        }
        List this$headerInfos = this.getHeaderInfos();
        List other$headerInfos = other.getHeaderInfos();
        if (this$headerInfos == null ? other$headerInfos != null : !((Object)this$headerInfos).equals(other$headerInfos)) {
            return false;
        }
        List this$content = this.getContent();
        List other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        List this$followUp = this.getFollowUp();
        List other$followUp = other.getFollowUp();
        if (this$followUp == null ? other$followUp != null : !((Object)this$followUp).equals(other$followUp)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HisConversationMessageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sectionId = this.getSectionId();
        result = result * 59 + ($sectionId == null ? 43 : $sectionId.hashCode());
        List $headerInfos = this.getHeaderInfos();
        result = result * 59 + ($headerInfos == null ? 43 : ((Object)$headerInfos).hashCode());
        List $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        List $followUp = this.getFollowUp();
        result = result * 59 + ($followUp == null ? 43 : ((Object)$followUp).hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    public String toString() {
        return "HisConversationMessageDto(sectionId=" + this.getSectionId() + ", headerInfos=" + this.getHeaderInfos() + ", content=" + this.getContent() + ", followUp=" + this.getFollowUp() + ", role=" + this.getRole() + ")";
    }

    public HisConversationMessageDto(String sectionId, List<Map> headerInfos, List<Map> content, List<Map> followUp, String role) {
        this.sectionId = sectionId;
        this.headerInfos = headerInfos;
        this.content = content;
        this.followUp = followUp;
        this.role = role;
    }

    public HisConversationMessageDto() {
    }
}

