/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto.dialogue;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.util.LangExtractor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FusionAssistantVo {
    private String id;
    private String assistantId;
    private String assistantName;
    private String iconUrl;
    private String iconType;
    private String baseURL;
    private Integer assistantType;
    private String accessChannel;
    private Integer assistantSubType = -1;
    private JSONObject dialogueMode;
    private JSONObject inputConfig;
    private JSONObject onboardingInfo;
    private JSONObject inspirationPhrases;
    private JSONObject inspirePrompts;
    private Boolean hasConversation = false;
    private String conversationId;
    private String version;
    private String description;
    private List<Map> tags;
    private String skillType;
    private List<String> inputCustomComponents;
    private List<String> shortcutsCustomComponents;
    private String ceilingCard;
    private JSONObject customConfig;
    private List<Map> pluginCustoms;
    private List<String> clientType;
    private String createTime;

    public static FusionAssistantVo covertFusionAssistantVo(FusionAssistant assistant, FusionAssistantSub fusionAssistantSub, String language) {
        JSONObject name;
        FusionAssistantVo fusionAssistantVo = new FusionAssistantVo();
        fusionAssistantVo.setId(assistant.getId());
        fusionAssistantVo.setAssistantId(assistant.getAssistantId());
        fusionAssistantVo.setBaseURL(assistant.getBaseURL());
        fusionAssistantVo.setAccessChannel(assistant.getAccessChannel());
        JSONObject lang = fusionAssistantSub.getLang();
        JSONObject inspirationPhrases = fusionAssistantSub.getInspirationPhrases();
        if (MapUtils.isNotEmpty((Map)inspirationPhrases)) {
            JSONArray intents = inspirationPhrases.getJSONArray("intents");
            for (int i = 0; i < intents.size(); ++i) {
                JSONObject intent = intents.getJSONObject(i);
                Object groupName = intent.get((Object)"groupName");
                intent.fluentPut("intentName", groupName);
                intent.fluentPut("intent", groupName);
            }
            fusionAssistantVo.setInspirePrompts(inspirationPhrases);
            fusionAssistantVo.setInspirationPhrases(inspirationPhrases);
        }
        fusionAssistantVo.setAssistantName(fusionAssistantSub.getAssistantName());
        if (null != lang && !lang.isEmpty() && null != (name = lang.getJSONObject("name")) && !name.isEmpty()) {
            fusionAssistantVo.setAssistantName(name.getString(language));
        }
        fusionAssistantVo.setIconUrl(fusionAssistantSub.getIconUrl());
        fusionAssistantVo.setVersion(fusionAssistantSub.getVersion());
        fusionAssistantVo.setInputConfig(fusionAssistantSub.getInputConfig());
        fusionAssistantVo.setAssistantType(AssistantType.PUBLISH_ASSISTANT.getType());
        fusionAssistantVo.setDialogueMode(fusionAssistantSub.getDialogueMode());
        fusionAssistantVo.setCreateTime(DateUtil.format((Date)fusionAssistantSub.getCreateTime(), (DatePrinter)DatePattern.NORM_DATETIME_FORMAT));
        fusionAssistantVo.setDescription(fusionAssistantSub.getDescription());
        fusionAssistantVo.setPluginCustoms(fusionAssistantSub.getPluginCustoms());
        fusionAssistantVo.setClientType(assistant.getClientType());
        fusionAssistantVo.setOnboardingInfo(fusionAssistantSub.getOnboardingInfo());
        return (FusionAssistantVo)LangExtractor.replaceLang((Object)fusionAssistantVo, (String)language);
    }

    public static List<FusionAssistantVo> sort(List<FusionAssistantVo> fusionAssistantVos, List<Conversation> conversations) {
        Map<String, Long> agentUpdateMap = conversations.stream().collect(Collectors.toMap(Conversation::getAgentId, Conversation::getUpdateTime));
        fusionAssistantVos.sort((a1, a2) -> {
            Long updateTime1 = (Long)agentUpdateMap.get(a1.getAssistantId());
            Long updateTime2 = (Long)agentUpdateMap.get(a2.getAssistantId());
            if (updateTime1 != null && updateTime2 != null) {
                return Long.compare(updateTime2, updateTime1);
            }
            if (updateTime1 != null) {
                return -1;
            }
            if (updateTime2 != null) {
                return 1;
            }
            Long createTime1 = FusionAssistantVo.safeParseTime((String)a1.getCreateTime());
            Long createTime2 = FusionAssistantVo.safeParseTime((String)a2.getCreateTime());
            if (createTime1 != null && createTime2 != null) {
                return Long.compare(createTime2, createTime1);
            }
            if (createTime1 != null) {
                return -1;
            }
            if (createTime2 != null) {
                return 1;
            }
            return 0;
        });
        return fusionAssistantVos;
    }

    private static Long safeParseTime(String timeStr) {
        if (StrUtil.isBlank((CharSequence)timeStr)) {
            return null;
        }
        try {
            return DateUtil.parse((CharSequence)timeStr).getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String cache(List<FusionAssistantVo> fusionAssistantVos) {
        List assistantCache = fusionAssistantVos.stream().map(assistant -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("assistantId", assistant.getAssistantId());
            map.put("version", assistant.getVersion());
            map.put("dialogueMode", (String)assistant.getDialogueMode());
            map.put("iconUrl", assistant.getIconUrl());
            map.put("assistantName", assistant.getAssistantName());
            return map;
        }).collect(Collectors.toList());
        return JSONUtil.toJsonStr(assistantCache);
    }

    public DialogueModeEnum getDialogueModeEnum() {
        String model = MapUtils.getString((Map)this.dialogueMode, (Object)"mode");
        return DialogueModeEnum.longDialogueMode.getModel().equals(model) ? DialogueModeEnum.longDialogueMode : DialogueModeEnum.topicBasedDialogueMode;
    }

    public String getId() {
        return this.id;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getAssistantName() {
        return this.assistantName;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getIconType() {
        return this.iconType;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Integer getAssistantType() {
        return this.assistantType;
    }

    public String getAccessChannel() {
        return this.accessChannel;
    }

    public Integer getAssistantSubType() {
        return this.assistantSubType;
    }

    public JSONObject getDialogueMode() {
        return this.dialogueMode;
    }

    public JSONObject getInputConfig() {
        return this.inputConfig;
    }

    public JSONObject getOnboardingInfo() {
        return this.onboardingInfo;
    }

    public JSONObject getInspirationPhrases() {
        return this.inspirationPhrases;
    }

    public JSONObject getInspirePrompts() {
        return this.inspirePrompts;
    }

    public Boolean getHasConversation() {
        return this.hasConversation;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Map> getTags() {
        return this.tags;
    }

    public String getSkillType() {
        return this.skillType;
    }

    public List<String> getInputCustomComponents() {
        return this.inputCustomComponents;
    }

    public List<String> getShortcutsCustomComponents() {
        return this.shortcutsCustomComponents;
    }

    public String getCeilingCard() {
        return this.ceilingCard;
    }

    public JSONObject getCustomConfig() {
        return this.customConfig;
    }

    public List<Map> getPluginCustoms() {
        return this.pluginCustoms;
    }

    public List<String> getClientType() {
        return this.clientType;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setAssistantName(String assistantName) {
        this.assistantName = assistantName;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public void setAssistantType(Integer assistantType) {
        this.assistantType = assistantType;
    }

    public void setAccessChannel(String accessChannel) {
        this.accessChannel = accessChannel;
    }

    public void setAssistantSubType(Integer assistantSubType) {
        this.assistantSubType = assistantSubType;
    }

    public void setDialogueMode(JSONObject dialogueMode) {
        this.dialogueMode = dialogueMode;
    }

    public void setInputConfig(JSONObject inputConfig) {
        this.inputConfig = inputConfig;
    }

    public void setOnboardingInfo(JSONObject onboardingInfo) {
        this.onboardingInfo = onboardingInfo;
    }

    public void setInspirationPhrases(JSONObject inspirationPhrases) {
        this.inspirationPhrases = inspirationPhrases;
    }

    public void setInspirePrompts(JSONObject inspirePrompts) {
        this.inspirePrompts = inspirePrompts;
    }

    public void setHasConversation(Boolean hasConversation) {
        this.hasConversation = hasConversation;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTags(List<Map> tags) {
        this.tags = tags;
    }

    public void setSkillType(String skillType) {
        this.skillType = skillType;
    }

    public void setInputCustomComponents(List<String> inputCustomComponents) {
        this.inputCustomComponents = inputCustomComponents;
    }

    public void setShortcutsCustomComponents(List<String> shortcutsCustomComponents) {
        this.shortcutsCustomComponents = shortcutsCustomComponents;
    }

    public void setCeilingCard(String ceilingCard) {
        this.ceilingCard = ceilingCard;
    }

    public void setCustomConfig(JSONObject customConfig) {
        this.customConfig = customConfig;
    }

    public void setPluginCustoms(List<Map> pluginCustoms) {
        this.pluginCustoms = pluginCustoms;
    }

    public void setClientType(List<String> clientType) {
        this.clientType = clientType;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistantVo)) {
            return false;
        }
        FusionAssistantVo other = (FusionAssistantVo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$assistantName = this.getAssistantName();
        String other$assistantName = other.getAssistantName();
        if (this$assistantName == null ? other$assistantName != null : !this$assistantName.equals(other$assistantName)) {
            return false;
        }
        String this$iconUrl = this.getIconUrl();
        String other$iconUrl = other.getIconUrl();
        if (this$iconUrl == null ? other$iconUrl != null : !this$iconUrl.equals(other$iconUrl)) {
            return false;
        }
        String this$iconType = this.getIconType();
        String other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) {
            return false;
        }
        String this$baseURL = this.getBaseURL();
        String other$baseURL = other.getBaseURL();
        if (this$baseURL == null ? other$baseURL != null : !this$baseURL.equals(other$baseURL)) {
            return false;
        }
        Integer this$assistantType = this.getAssistantType();
        Integer other$assistantType = other.getAssistantType();
        if (this$assistantType == null ? other$assistantType != null : !((Object)this$assistantType).equals(other$assistantType)) {
            return false;
        }
        String this$accessChannel = this.getAccessChannel();
        String other$accessChannel = other.getAccessChannel();
        if (this$accessChannel == null ? other$accessChannel != null : !this$accessChannel.equals(other$accessChannel)) {
            return false;
        }
        Integer this$assistantSubType = this.getAssistantSubType();
        Integer other$assistantSubType = other.getAssistantSubType();
        if (this$assistantSubType == null ? other$assistantSubType != null : !((Object)this$assistantSubType).equals(other$assistantSubType)) {
            return false;
        }
        JSONObject this$dialogueMode = this.getDialogueMode();
        JSONObject other$dialogueMode = other.getDialogueMode();
        if (this$dialogueMode == null ? other$dialogueMode != null : !this$dialogueMode.equals(other$dialogueMode)) {
            return false;
        }
        JSONObject this$inputConfig = this.getInputConfig();
        JSONObject other$inputConfig = other.getInputConfig();
        if (this$inputConfig == null ? other$inputConfig != null : !this$inputConfig.equals(other$inputConfig)) {
            return false;
        }
        JSONObject this$onboardingInfo = this.getOnboardingInfo();
        JSONObject other$onboardingInfo = other.getOnboardingInfo();
        if (this$onboardingInfo == null ? other$onboardingInfo != null : !this$onboardingInfo.equals(other$onboardingInfo)) {
            return false;
        }
        JSONObject this$inspirationPhrases = this.getInspirationPhrases();
        JSONObject other$inspirationPhrases = other.getInspirationPhrases();
        if (this$inspirationPhrases == null ? other$inspirationPhrases != null : !this$inspirationPhrases.equals(other$inspirationPhrases)) {
            return false;
        }
        JSONObject this$inspirePrompts = this.getInspirePrompts();
        JSONObject other$inspirePrompts = other.getInspirePrompts();
        if (this$inspirePrompts == null ? other$inspirePrompts != null : !this$inspirePrompts.equals(other$inspirePrompts)) {
            return false;
        }
        Boolean this$hasConversation = this.getHasConversation();
        Boolean other$hasConversation = other.getHasConversation();
        if (this$hasConversation == null ? other$hasConversation != null : !((Object)this$hasConversation).equals(other$hasConversation)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$skillType = this.getSkillType();
        String other$skillType = other.getSkillType();
        if (this$skillType == null ? other$skillType != null : !this$skillType.equals(other$skillType)) {
            return false;
        }
        List this$inputCustomComponents = this.getInputCustomComponents();
        List other$inputCustomComponents = other.getInputCustomComponents();
        if (this$inputCustomComponents == null ? other$inputCustomComponents != null : !((Object)this$inputCustomComponents).equals(other$inputCustomComponents)) {
            return false;
        }
        List this$shortcutsCustomComponents = this.getShortcutsCustomComponents();
        List other$shortcutsCustomComponents = other.getShortcutsCustomComponents();
        if (this$shortcutsCustomComponents == null ? other$shortcutsCustomComponents != null : !((Object)this$shortcutsCustomComponents).equals(other$shortcutsCustomComponents)) {
            return false;
        }
        String this$ceilingCard = this.getCeilingCard();
        String other$ceilingCard = other.getCeilingCard();
        if (this$ceilingCard == null ? other$ceilingCard != null : !this$ceilingCard.equals(other$ceilingCard)) {
            return false;
        }
        JSONObject this$customConfig = this.getCustomConfig();
        JSONObject other$customConfig = other.getCustomConfig();
        if (this$customConfig == null ? other$customConfig != null : !this$customConfig.equals(other$customConfig)) {
            return false;
        }
        List this$pluginCustoms = this.getPluginCustoms();
        List other$pluginCustoms = other.getPluginCustoms();
        if (this$pluginCustoms == null ? other$pluginCustoms != null : !((Object)this$pluginCustoms).equals(other$pluginCustoms)) {
            return false;
        }
        List this$clientType = this.getClientType();
        List other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !((Object)this$clientType).equals(other$clientType)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistantVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $assistantName = this.getAssistantName();
        result = result * 59 + ($assistantName == null ? 43 : $assistantName.hashCode());
        String $iconUrl = this.getIconUrl();
        result = result * 59 + ($iconUrl == null ? 43 : $iconUrl.hashCode());
        String $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        String $baseURL = this.getBaseURL();
        result = result * 59 + ($baseURL == null ? 43 : $baseURL.hashCode());
        Integer $assistantType = this.getAssistantType();
        result = result * 59 + ($assistantType == null ? 43 : ((Object)$assistantType).hashCode());
        String $accessChannel = this.getAccessChannel();
        result = result * 59 + ($accessChannel == null ? 43 : $accessChannel.hashCode());
        Integer $assistantSubType = this.getAssistantSubType();
        result = result * 59 + ($assistantSubType == null ? 43 : ((Object)$assistantSubType).hashCode());
        JSONObject $dialogueMode = this.getDialogueMode();
        result = result * 59 + ($dialogueMode == null ? 43 : $dialogueMode.hashCode());
        JSONObject $inputConfig = this.getInputConfig();
        result = result * 59 + ($inputConfig == null ? 43 : $inputConfig.hashCode());
        JSONObject $onboardingInfo = this.getOnboardingInfo();
        result = result * 59 + ($onboardingInfo == null ? 43 : $onboardingInfo.hashCode());
        JSONObject $inspirationPhrases = this.getInspirationPhrases();
        result = result * 59 + ($inspirationPhrases == null ? 43 : $inspirationPhrases.hashCode());
        JSONObject $inspirePrompts = this.getInspirePrompts();
        result = result * 59 + ($inspirePrompts == null ? 43 : $inspirePrompts.hashCode());
        Boolean $hasConversation = this.getHasConversation();
        result = result * 59 + ($hasConversation == null ? 43 : ((Object)$hasConversation).hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $skillType = this.getSkillType();
        result = result * 59 + ($skillType == null ? 43 : $skillType.hashCode());
        List $inputCustomComponents = this.getInputCustomComponents();
        result = result * 59 + ($inputCustomComponents == null ? 43 : ((Object)$inputCustomComponents).hashCode());
        List $shortcutsCustomComponents = this.getShortcutsCustomComponents();
        result = result * 59 + ($shortcutsCustomComponents == null ? 43 : ((Object)$shortcutsCustomComponents).hashCode());
        String $ceilingCard = this.getCeilingCard();
        result = result * 59 + ($ceilingCard == null ? 43 : $ceilingCard.hashCode());
        JSONObject $customConfig = this.getCustomConfig();
        result = result * 59 + ($customConfig == null ? 43 : $customConfig.hashCode());
        List $pluginCustoms = this.getPluginCustoms();
        result = result * 59 + ($pluginCustoms == null ? 43 : ((Object)$pluginCustoms).hashCode());
        List $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)$clientType).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistantVo(id=" + this.getId() + ", assistantId=" + this.getAssistantId() + ", assistantName=" + this.getAssistantName() + ", iconUrl=" + this.getIconUrl() + ", iconType=" + this.getIconType() + ", baseURL=" + this.getBaseURL() + ", assistantType=" + this.getAssistantType() + ", accessChannel=" + this.getAccessChannel() + ", assistantSubType=" + this.getAssistantSubType() + ", dialogueMode=" + this.getDialogueMode() + ", inputConfig=" + this.getInputConfig() + ", onboardingInfo=" + this.getOnboardingInfo() + ", inspirationPhrases=" + this.getInspirationPhrases() + ", inspirePrompts=" + this.getInspirePrompts() + ", hasConversation=" + this.getHasConversation() + ", conversationId=" + this.getConversationId() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", skillType=" + this.getSkillType() + ", inputCustomComponents=" + this.getInputCustomComponents() + ", shortcutsCustomComponents=" + this.getShortcutsCustomComponents() + ", ceilingCard=" + this.getCeilingCard() + ", customConfig=" + this.getCustomConfig() + ", pluginCustoms=" + this.getPluginCustoms() + ", clientType=" + this.getClientType() + ", createTime=" + this.getCreateTime() + ")";
    }
}

