/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.eventbus.gpt;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.MqTopicEnum;
import com.digiwin.athena.ania.eventbus.gpt.event.ChatGptEvent;
import com.digiwin.athena.ania.eventbus.gpt.event.SendaiConsumeMessage;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.google.common.eventbus.Subscribe;
import javax.annotation.Resource;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class ChatGptEventSubscriber {
    @Resource
    private RabbitTemplate rabbitTemplate;

    @Subscribe
    public void subscriber(ChatGptEvent event) {
        JSONObject request = event.getRequest();
        JSONObject requestParamData = request.getJSONObject("data");
        ChatGptRequestLog chatGptRequestLog = event.getChatGptRequestLog();
        JSONObject usage = chatGptRequestLog.getResult().getJSONObject("usage");
        SendaiConsumeMessage sendaiConsumeMessage = new SendaiConsumeMessage();
        sendaiConsumeMessage.setUsage(usage);
        sendaiConsumeMessage.setCreateTime(event.getCreateTime());
        sendaiConsumeMessage.setId(chatGptRequestLog.getId());
        sendaiConsumeMessage.setTopic(requestParamData.getString("topic"));
        sendaiConsumeMessage.setToken(String.valueOf(event.getSource()));
        sendaiConsumeMessage.setMethod(requestParamData.getString("method"));
        this.rabbitTemplate.convertAndSend(MqTopicEnum.PAAS_ASA_AI_CONSUME_MESSAGE.getTopic(), (Object)sendaiConsumeMessage);
    }
}

