/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.eventbus.message;

import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.eventbus.message.ConversationMessageEvent;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.brush.HisMgsMigrateConversationComponent;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.message.ConversationMessageSearchService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ConversationMessageEventSubscriber {
    @Resource
    private NoticeService noticeService;
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private ConversationMessageSearchService conversationMessageSearchService;
    @Resource
    private HisMgsMigrateConversationComponent hisMgsMigrateConversationComponent;

    @Subscribe
    public void subscriber(ConversationMessageEvent event) {
        MessageAction eventType = null;
        int type = event.getType();
        ConversationMessage message = (ConversationMessage)event.getSource();
        if (type == 0) {
            eventType = MessageAction.CREATED;
            if (message.getUserType() == 2 && Objects.equals(1, message.getSource())) {
                this.hisMgsMigrateConversationComponent.migrateFeedBack(message);
            } else {
                this.conversationMessageSearchService.addMessageSearch(message);
            }
            this.conversationIndexService.updateConversationMaxIndex(message.getUserId(), message.getConversationId(), message.getIndex().intValue());
            if (message.getUserType() == 1) {
                return;
            }
        } else if (type == 1) {
            eventType = MessageAction.DELETED;
        } else if (type == 3) {
            eventType = MessageAction.UPDATE;
        }
        if (null == message.getSource() || message.getSource() != 1) {
            this.noticeService.conversationEvent(eventType, message);
        }
    }
}

