/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.AssistantDeployerDto;
import com.digiwin.athena.ania.dto.BusinessCreateProjectDto;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.MessageDto;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AsaHelper {
    private static final Logger log = LoggerFactory.getLogger(AsaHelper.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private static final String SUBMIT_TO_ASA_URL = "/asa/newRecordOverview/athena/submit";
    private static final String CREATE_PROJECT_ASA_URL = "/asa/project/create";
    private static final String ASSISTANTAGENT_GET_ASA_URL = "/asa/assistantAgent/get";
    private static final String TEXT_COLLECT_TO_ASA_URL = "/asa/card/task/text/collect";

    public boolean submit(JSONObject submit, String userToken) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        httpHeaders.set("token", userToken);
        String traceId = MdcUtil.getTraceId();
        httpHeaders.set("traceId", traceId);
        HttpEntity httpEntity = new HttpEntity((Object)submit, (MultiValueMap)httpHeaders);
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(SUBMIT_TO_ASA_URL);
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u63d0\u4ea4\uff0curl:{}", (Object)sbUrl);
        log.info("params\uff1a{}", (Object)JSON.toJSONString((Object)submit));
        try {
            responseEntity = this.restTemplate.exchange(sbUrl.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)submit);
            if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
                log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u63d0\u4ea4\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
                return false;
            }
        }
        catch (Exception e) {
            log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u63d0\u4ea4\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u63d0\u4ea4\u6210\u529f,\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        return true;
    }

    public JSONObject createProject(BusinessCreateProjectDto businessCreateProjectDto, String userToken, String tenantId) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("routerKey", tenantId);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        httpHeaders.set("token", userToken);
        String traceId = MdcUtil.getTraceId();
        httpHeaders.set("traceId", traceId);
        MessageDto message = businessCreateProjectDto.getQuestion().getMessage();
        message.setAssistantCode(businessCreateProjectDto.getQuestion().getAssistantCode());
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("templateCommand", businessCreateProjectDto.getTemplateCommand());
        param.put("question", message);
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(CREATE_PROJECT_ASA_URL);
        try {
            responseEntity = this.restTemplate.postForEntity(sbUrl.toString(), (Object)new HttpEntity(param, (MultiValueMap)httpHeaders), JSONObject.class, new Object[0]);
            if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
                log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u521b\u5efa\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
                return null;
            }
        }
        catch (Exception e) {
            log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u521b\u5efa\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u521b\u5efa\u6210\u529f,\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        return (JSONObject)responseEntity.getBody();
    }

    public JSONObject assistantAgent(HisAssistantChatDto question, String userToken, String tenantId) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("routerKey", tenantId);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        httpHeaders.set("token", userToken);
        String traceId = MdcUtil.getTraceId();
        httpHeaders.set("traceId", traceId);
        MessageDto message = question.getMessage();
        message.setAssistantCode(question.getAssistantCode());
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(ASSISTANTAGENT_GET_ASA_URL);
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u83b7\u53d6\u610f\u56fe\u521b\u5efa\uff0curl:{},params\uff1a{}", (Object)sbUrl, (Object)BaseUseUtils.toJsonString((Object)message));
        try {
            responseEntity = this.restTemplate.postForEntity(sbUrl.toString(), (Object)new HttpEntity((Object)message, (MultiValueMap)httpHeaders), JSONObject.class, new Object[0]);
            if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
                log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u83b7\u53d6\u610f\u56fe\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
                return null;
            }
        }
        catch (Exception e) {
            log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u83b7\u53d6\u610f\u56fe\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u83b7\u53d6\u610f\u56fe\u6210\u529f,\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        return (JSONObject)responseEntity.getBody();
    }

    public String textCollect(List<String> sessionTask, String content, String userToken) {
        JSONObject msg = new JSONObject();
        msg.put("sessionTask", sessionTask);
        msg.put("content", (Object)content);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        httpHeaders.set("token", userToken);
        String traceId = MdcUtil.getTraceId();
        httpHeaders.set("traceId", traceId);
        HttpEntity httpEntity = new HttpEntity((Object)msg, (MultiValueMap)httpHeaders);
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(TEXT_COLLECT_TO_ASA_URL);
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u67e5\u8be2\u662f\u5426\u6ee1\u8db3\u81ea\u7136\u8bed\u8a00\u56de\u590d\uff0curl:{}", (Object)sbUrl.toString());
        log.info("params\uff1a{}", (Object)JSON.toJSONString((Object)msg));
        ResponseEntity responseEntity = this.restTemplate.exchange(sbUrl.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)msg);
        if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
            log.info("\u8c03\u7528C\u5a1c\u63a5\u53e3\u67e5\u8be2\u662f\u5426\u6ee1\u8db3\u81ea\u7136\u8bed\u8a00\u56de\u590d\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
            return null;
        }
        log.info("\u8c03\u7528C\u5a1c\u63a5\u53e3\u67e5\u8be2\u662f\u5426\u6ee1\u8db3\u81ea\u7136\u8bed\u8a00\u56de\u590d\u6210\u529f,\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        JSONObject responseBody = (JSONObject)responseEntity.getBody();
        JSONObject jsonObject = responseBody.getJSONObject("data");
        return jsonObject.getString("workItemId");
    }

    public void deployerNotice(AssistantDeployerDto assistantDeployer) {
        try {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("digi-middleware-auth-user", authoredUser.getToken());
            httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            httpHeaders.set("token", authoredUser.getToken());
            HttpEntity httpEntity = new HttpEntity((Object)assistantDeployer, (MultiValueMap)httpHeaders);
            ResponseEntity responseEntity = this.restTemplate.exchange(this.envProperties.getAsaUri() + "/asa/assistant/deployerCache", HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{assistantDeployer});
            JSONObject responseBody = (JSONObject)responseEntity.getBody();
            log.info("deployerNotice assistantDeployer :{},status:{}", (Object)BaseUseUtils.toJsonString((Object)assistantDeployer), (Object)MapUtils.getInteger((Map)responseBody, (Object)"code"));
        }
        catch (Exception e) {
            log.info("deployerNotice error assistantDeployer:{}", (Object)BaseUseUtils.toJsonString((Object)assistantDeployer), (Object)e);
        }
    }
}

