/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.dto.gmc.GmcBulletinResultDTO;
import com.digiwin.athena.ania.dto.gmc.GmcResponse;
import com.digiwin.athena.ania.env.EnvProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class GmcHelper {
    private static final Logger log = LoggerFactory.getLogger(GmcHelper.class);
    @Autowired
    private EnvProperties envProperties;
    private static final String QUERY_APP_RELEASE_INFO = "/api/gmc/v2/release/query";
    @Autowired
    private RestTemplate restTemplate;

    public List<GmcBulletinResultDTO> queryBulletinList(String token, String tenantId, List<String> codes, Integer pageNum, Integer pageSize) {
        String url = this.envProperties.getGmcUri() + QUERY_APP_RELEASE_INFO;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("codes", codes);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("elaborate", true);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("GmcHelper.queryBulletinList start tenantId:{}; header:{}; param:{}", new Object[]{tenantId, JSON.toJSONString((Object)headers), JSON.toJSONString(param)});
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("GmcHelper.queryBulletinList return response:{}", (Object)response);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((GmcResponse)response.getBody()).getData();
            }
        }
        catch (Exception e) {
            log.error("GmcHelper.queryBulletinList is error desc", (Object)e.getMessage());
            throw new ServiceException(Integer.valueOf(500), e.getMessage());
        }
        return Collections.emptyList();
    }
}

