/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.dto.AthenaUserDto;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.RedisUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class IamHelper {
    private static final Logger log = LoggerFactory.getLogger(IamHelper.class);
    @Autowired
    private EnvProperties envProperties;
    private static final String WE_COM = "weCom";
    private static final String tokenAnalyzeUrl = "/api/iam/v2/identity/token/analyze";
    private static final String getLagauage = "/api/iam/v2/usermetadata/user/get";
    private static final String getInternalTokenUrl = "/api/iam/v2/identity/login/internal";
    private static final String PC_SSO_PATH = "/api/iam/v2/identity/oauth/token/access";
    @Autowired
    private RestTemplate restTemplate;

    public AthenaUserDto getUserInfo(String userToken) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", userToken);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + tokenAnalyzeUrl;
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
            JSONObject body = (JSONObject)responseEntity.getBody();
            log.info("getUserInfo#\u8c03\u7528\u7b2c\u4e09\u65b9iam\u63a5\u53e3:{},appToken:{},userToken:{},result:{}", new Object[]{url, this.envProperties.getAppToken(), userToken, body});
            AthenaUserDto authoredUser = new AthenaUserDto();
            authoredUser.setUserId(MapUtils.getString((Map)body, (Object)"id"));
            authoredUser.setTenantSid(MapUtils.getLong((Map)body, (Object)"tenantSid"));
            authoredUser.setTenantId(MapUtils.getString((Map)body, (Object)"tenantId"));
            authoredUser.setSid(MapUtils.getLong((Map)body, (Object)"sid"));
            authoredUser.setUserName(MapUtils.getString((Map)body, (Object)"name"));
            authoredUser.setTelephone(MapUtils.getString((Map)body, (Object)"telephone", (String)""));
            authoredUser.setTenantName(MapUtils.getString((Map)body, (Object)"tenantName"));
            authoredUser.setEmail(MapUtils.getString((Map)body, (Object)"email", (String)""));
            if (Objects.nonNull(authoredUser) && authoredUser.getUserId() != null) {
                authoredUser.setToken(userToken);
                return authoredUser;
            }
            return null;
        }
        catch (Exception ex) {
            log.error("getUserInfo is error userToken:{}", (Object)userToken, (Object)ex);
            return null;
        }
    }

    public String getTenantIdFromToken(String userToken) {
        AthenaUserDto userDto = this.getUserInfo(userToken);
        if (userDto != null) {
            return userDto.getTenantId();
        }
        return null;
    }

    public String getAthenaUserLanguage(String token, String userId) {
        JSONObject resultInfo = null;
        try {
            JSONObject param = new JSONObject();
            param.put("tenantSid", (Object)0);
            param.put("catalogId", (Object)"basic");
            param.put("userId", (Object)userId);
            param.put("key", (Object)"dapAcceptLanguage");
            String url = this.envProperties.getIamUri() + getLagauage;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", token);
            headers.add("digi-middleware-auth-user", token);
            headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            headers.add("Content-Type", "application/json");
            ResponseEntity result = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)param, (MultiValueMap)headers), JSONObject.class, new Object[0]);
            resultInfo = (JSONObject)result.getBody();
            log.info("url={},\u5165\u53c2={}, \u8fd4\u56de\u7ed3\u679c={}", new Object[]{url, param, resultInfo});
            Integer code = resultInfo.getInteger("code");
            if (Objects.equals(200, code)) {
                JSONObject data = resultInfo.getJSONObject("data");
                String lagauage = MapUtils.getString((Map)data, (Object)"value");
                if (StringUtils.isBlank((CharSequence)lagauage)) {
                    if (this.envProperties.getIamUri().contains(".cn")) {
                        return LocalsEnum.CN.getCode();
                    }
                    return LocalsEnum.TW.getCode();
                }
                return lagauage;
            }
            return LocalsEnum.CN.getCode();
        }
        catch (Exception ex) {
            log.error("getAthenaUserLanguage is error userId:{},resultInfo:{}", new Object[]{userId, JSONObject.toJSONString(resultInfo), ex});
            if (this.envProperties.getIamUri().contains(".cn")) {
                return LocalsEnum.CN.getCode();
            }
            return LocalsEnum.TW.getCode();
        }
    }

    public String getTenantToken(String realTenantId) {
        String key = "ASA_TENANT_TOKEN_" + realTenantId;
        String cacheToken = RedisUtils.getCacheStrData((String)key);
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            return cacheToken;
        }
        JSONObject resultInfo = this.getRealTimeTenantToken(realTenantId);
        cacheToken = resultInfo.getString("token");
        if (StringUtils.isEmpty((CharSequence)cacheToken)) {
            log.error("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token\u5f02\u5e38");
            throw new ServiceException(Integer.valueOf(500), "\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7\u79df\u6237token:getTenantToken\u63a5\u53e3\u5f02\u5e38");
        }
        RedisUtils.cacheStrData((String)key, (String)cacheToken, (long)30L, (TimeUnit)TimeUnit.DAYS);
        return cacheToken;
    }

    public JSONObject getRealTimeTenantToken(String tenantId) {
        JSONObject param = new JSONObject();
        param.put("tenantId", (Object)tenantId);
        param.put("userId", (Object)"integration");
        param.put("passwordHash", (Object)"6826CC688C4AF1BD0A8DDA2DBDF8897B");
        String url = this.envProperties.getIamUri() + getInternalTokenUrl;
        String body = JSON.toJSONString((Object)param);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        httpHeaders.add("Client-Agent", "mobileplatform-2.0.1.1");
        httpHeaders.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token#pre,url:{},httpEntity:{}", (Object)url, (Object)JSONObject.toJSONString((Object)httpEntity));
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token#post,url:{},response:{}", (Object)url, (Object)JSONObject.toJSONString((Object)response));
        String result = (String)response.getBody();
        return JSON.parseObject((String)result);
    }

    public ResponseEntity<JSONObject> getJsonObjectResponseEntity(String code, String tenantId, String appId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("code", code);
        requestMap.put("oauthType", WE_COM);
        requestMap.put("appId", appId);
        String url = this.envProperties.getIamUri() + PC_SSO_PATH;
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            log.info("IamHelper.getJsonObjectResponseEntity.param:{}", (Object)JsonUtil.toJSONString(requestMap));
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("IamHelper.getJsonObjectResponseEntity.result:{}", (Object)JsonUtil.toJSONString((Object)respEntity));
        }
        catch (RestClientException e) {
            log.error("Failed to call IAM API: {}", (Object)e.getMessage(), (Object)e);
            return respEntity;
        }
        return respEntity;
    }
}

