/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ImHelper {
    private static final Logger log = LoggerFactory.getLogger(ImHelper.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private TokenVerifyService tokenVerifyService;
    private static final String IM_GET_YUNXIN_USER = "/user/open/getAccidByUserId";

    private String getAccidByUserId(String userToken, String userId) {
        String uri = this.envProperties.getImUri() + IM_GET_YUNXIN_USER;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", userToken);
        headers.set("digi-middleware-auth-user", userToken);
        headers.set("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, param);
        if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
            log.info("\u8c03\u7528im\u6216\u8005\u4e91\u4fe1\u8d26\u6237\u5931\u8d25");
            return null;
        }
        Map userPoMap = (Map)responseEntity.getBody();
        Map response = (Map)userPoMap.get("response");
        if (null != response.get("accid")) {
            return (String)response.get("accid");
        }
        log.info("\u7528\u6237\u672a\u7ed1\u5b9a\u4e91\u4fe1\u8d26\u53f7");
        return null;
    }

    public Map getAccidFromIm(String targetTenantId, String userId, AuthoredUser authoredUser) {
        HashMap map = Maps.newHashMap();
        String accid = null;
        if (StringUtils.isNotBlank((CharSequence)targetTenantId) && StringUtils.isNotBlank((CharSequence)userId)) {
            String virtualToken = this.tokenVerifyService.queryApiVirtualToken(targetTenantId);
            AppAuthContextHolder.getContext().setSecurityToken(null);
            accid = this.getAccidByUserId(virtualToken, userId);
        } else {
            String token = authoredUser.getToken();
            log.info("token\uff1a{}", (Object)token);
            if (StringUtils.isBlank((CharSequence)targetTenantId) && StringUtils.isNotBlank((CharSequence)userId)) {
                accid = this.getAccidByUserId(token, userId);
            }
            if (StringUtils.isBlank((CharSequence)userId) && StringUtils.isBlank((CharSequence)targetTenantId)) {
                userId = authoredUser.getUserId();
                accid = this.getAccidByUserId(token, userId);
            }
        }
        map.put("accid", accid);
        map.put("userId", userId);
        return map;
    }
}

