/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.dto.AbstractMsg;
import com.digiwin.athena.ania.dto.CustomMsg;
import com.digiwin.athena.ania.dto.TextMsg;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.AgoraImHelper;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.YunXinImHelper;
import com.digiwin.athena.ania.helper.im.ImTypeHandler;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerFactory;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private AssistantService assistantService;
    @Autowired
    private ImTypeHandlerFactory imTypeHandlerFactory;
    @Resource
    private IamHelper iamHelper;

    public ResultBean pushCustomMessage(CustomMsg customMessage) {
        String assistantAccount = this.assistantService.getAssistantAccount(customMessage.getAssistantCode());
        if (customMessage.legalMessage(assistantAccount)) {
            String skillType;
            ImTypeHandler typeHandler = this.imTypeHandlerFactory.getTypeHandler(this.envProperties.getSupplierType());
            String string = skillType = "asada".equals(customMessage.getAssistantCode()) ? "1" : customMessage.getAssistantCode();
            if (typeHandler instanceof YunXinImHelper) {
                return ((YunXinImHelper)typeHandler).pushCustomMessageNew(customMessage.getFrom(), customMessage.getTo(), customMessage.buildMessage(), skillType, this.buildExt(customMessage));
            }
            if (typeHandler instanceof AgoraImHelper) {
                return ((AgoraImHelper)typeHandler).handlerNew(customMessage.getFrom(), customMessage.getTo(), (Object)customMessage.buildMessage(), skillType, this.buildExt(customMessage));
            }
            return new ResultBean(new ServiceException(Integer.valueOf(500), " Im Type error"));
        }
        return new ResultBean(new ServiceException(Integer.valueOf(500), " account error"));
    }

    public ResultBean pushTextMessage(TextMsg textMsg) {
        String assistantAccount = this.assistantService.getAssistantAccount(textMsg.getAssistantCode());
        if (textMsg.legalMessage(assistantAccount)) {
            String skillType;
            ImTypeHandler typeHandler = this.imTypeHandlerFactory.getTypeHandler(this.envProperties.getSupplierType());
            String string = skillType = "asada".equals(textMsg.getAssistantCode()) ? "1" : textMsg.getAssistantCode();
            if (typeHandler instanceof YunXinImHelper) {
                return ((YunXinImHelper)typeHandler).pushMessageNew(textMsg.getFrom(), textMsg.getTo(), textMsg.getMessage(), skillType, this.buildExt(textMsg));
            }
            if (typeHandler instanceof AgoraImHelper) {
                return ((AgoraImHelper)typeHandler).handlerNew(textMsg.getFrom(), textMsg.getTo(), (Object)textMsg.getMessage(), skillType, this.buildExt(textMsg));
            }
            return new ResultBean(new ServiceException(Integer.valueOf(500), " Im Type error"));
        }
        return new ResultBean(new ServiceException(Integer.valueOf(500), " account error"));
    }

    private JSONObject buildExt(TextMsg textMsg) {
        return this.buildCommonExt((AbstractMsg)textMsg);
    }

    private JSONObject buildExt(CustomMsg customMessage) {
        return this.buildCommonExt((AbstractMsg)customMessage);
    }

    private JSONObject buildCommonExt(AbstractMsg message) {
        JSONObject ext = message.getExt();
        try {
            if (!ext.containsKey((Object)"routerKey") && StringUtils.isNotBlank((CharSequence)message.getTenantId())) {
                ext.put("routerKey", (Object)message.getTenantId());
            }
            if (!ext.containsKey((Object)"token")) {
                if (StringUtils.isNotBlank((CharSequence)message.getToken())) {
                    ext.put("token", (Object)message.getToken());
                } else {
                    String tenantId = MapUtils.getString((Map)ext, (Object)"routerKey");
                    if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                        String tenantToken = this.iamHelper.getTenantToken(tenantId);
                        ext.put("token", (Object)tenantToken);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("buildExt is error message:{}", (Object)BaseUseUtils.toJsonString((Object)message), (Object)ex);
        }
        return ext;
    }
}

