/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.mongo.domain.WorkitemInfoData;
import com.google.common.base.Joiner;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;

public class UserMessageActionContext {
    private String sentence;
    private String sentenceContext;
    private List<ImMessageLog> userContextMessages;
    @ApiModelProperty(value="\u6709\u6548\u4e14\u672a\u5b8c\u6210\u7684\u6536\u96c6\u4efb\u52a1\u5361")
    private List<WorkitemInfoData> effectiveIncompleteTaskList;
    private Set<String> referenceFriendNames;
    private Set<String> referenceGroupNames;
    private Integer first;
    private JSONObject msgExt;
    private ImMessageLog imMessageLog;
    @ApiModelProperty(value="\u6709\u6548\u672a\u5b8c\u6210\u4efb\u52a1\u540d\u79f0\u548c\u5bf9\u5e94\u7684\u6d88\u606fId")
    private List<BasicNameValuePair> effectiveIncompleteTaskNameToMsgIdList;
    @ApiModelProperty(value="\u5f85\u529e\u6d88\u606fid\u6620\u5c04")
    private Map<String, String> toDoTaskMap;
    @ApiModelProperty(value="\u5f85\u5904\u7406\u4efb\u52a1\u6e05\u5355")
    private List<JSONObject> toDoTasks;

    public String buildElementNames() {
        if (CollectionUtils.isNotEmpty((Collection)this.effectiveIncompleteTaskNameToMsgIdList)) {
            List collect = this.effectiveIncompleteTaskNameToMsgIdList.stream().map(BasicNameValuePair::getName).collect(Collectors.toList());
            if (collect.size() > 1) {
                List elementNames = collect.subList(1, collect.size());
                return "[" + (String)collect.get(0) + "]" + "\u6216" + "[" + Joiner.on((String)"\u3001").join(elementNames) + "]";
            }
            if (collect.size() == 1) {
                return "[" + (String)collect.get(0) + "]";
            }
        }
        return "[]";
    }

    public String buildDoTaskListCHagGptStr() {
        if (CollectionUtils.isNotEmpty((Collection)this.toDoTasks)) {
            ArrayList<String> taskNames = new ArrayList<String>();
            int index = 0;
            for (JSONObject task : this.toDoTasks) {
                taskNames.add(++index + "." + task.toJSONString());
            }
            return Joiner.on((String)"\n").join(taskNames);
        }
        return "";
    }

    public WorkitemInfoData getIncompleteTask(String workCardId) {
        if (StringUtils.isBlank((CharSequence)workCardId) || CollectionUtils.isEmpty((Collection)this.effectiveIncompleteTaskList)) {
            return null;
        }
        Optional<WorkitemInfoData> task = this.effectiveIncompleteTaskList.parallelStream().filter(x -> x.getId().equals(workCardId)).findAny();
        if (task.isPresent()) {
            return task.get();
        }
        return null;
    }

    public static UserMessageActionContextBuilder builder() {
        return new UserMessageActionContextBuilder();
    }

    public UserMessageActionContext() {
    }

    public UserMessageActionContext(String sentence, String sentenceContext, List<ImMessageLog> userContextMessages, List<WorkitemInfoData> effectiveIncompleteTaskList, Set<String> referenceFriendNames, Set<String> referenceGroupNames, Integer first, JSONObject msgExt, ImMessageLog imMessageLog, List<BasicNameValuePair> effectiveIncompleteTaskNameToMsgIdList, Map<String, String> toDoTaskMap, List<JSONObject> toDoTasks) {
        this.sentence = sentence;
        this.sentenceContext = sentenceContext;
        this.userContextMessages = userContextMessages;
        this.effectiveIncompleteTaskList = effectiveIncompleteTaskList;
        this.referenceFriendNames = referenceFriendNames;
        this.referenceGroupNames = referenceGroupNames;
        this.first = first;
        this.msgExt = msgExt;
        this.imMessageLog = imMessageLog;
        this.effectiveIncompleteTaskNameToMsgIdList = effectiveIncompleteTaskNameToMsgIdList;
        this.toDoTaskMap = toDoTaskMap;
        this.toDoTasks = toDoTasks;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getSentenceContext() {
        return this.sentenceContext;
    }

    public List<ImMessageLog> getUserContextMessages() {
        return this.userContextMessages;
    }

    public List<WorkitemInfoData> getEffectiveIncompleteTaskList() {
        return this.effectiveIncompleteTaskList;
    }

    public Set<String> getReferenceFriendNames() {
        return this.referenceFriendNames;
    }

    public Set<String> getReferenceGroupNames() {
        return this.referenceGroupNames;
    }

    public Integer getFirst() {
        return this.first;
    }

    public JSONObject getMsgExt() {
        return this.msgExt;
    }

    public ImMessageLog getImMessageLog() {
        return this.imMessageLog;
    }

    public List<BasicNameValuePair> getEffectiveIncompleteTaskNameToMsgIdList() {
        return this.effectiveIncompleteTaskNameToMsgIdList;
    }

    public Map<String, String> getToDoTaskMap() {
        return this.toDoTaskMap;
    }

    public List<JSONObject> getToDoTasks() {
        return this.toDoTasks;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setSentenceContext(String sentenceContext) {
        this.sentenceContext = sentenceContext;
    }

    public void setUserContextMessages(List<ImMessageLog> userContextMessages) {
        this.userContextMessages = userContextMessages;
    }

    public void setEffectiveIncompleteTaskList(List<WorkitemInfoData> effectiveIncompleteTaskList) {
        this.effectiveIncompleteTaskList = effectiveIncompleteTaskList;
    }

    public void setReferenceFriendNames(Set<String> referenceFriendNames) {
        this.referenceFriendNames = referenceFriendNames;
    }

    public void setReferenceGroupNames(Set<String> referenceGroupNames) {
        this.referenceGroupNames = referenceGroupNames;
    }

    public void setFirst(Integer first) {
        this.first = first;
    }

    public void setMsgExt(JSONObject msgExt) {
        this.msgExt = msgExt;
    }

    public void setImMessageLog(ImMessageLog imMessageLog) {
        this.imMessageLog = imMessageLog;
    }

    public void setEffectiveIncompleteTaskNameToMsgIdList(List<BasicNameValuePair> effectiveIncompleteTaskNameToMsgIdList) {
        this.effectiveIncompleteTaskNameToMsgIdList = effectiveIncompleteTaskNameToMsgIdList;
    }

    public void setToDoTaskMap(Map<String, String> toDoTaskMap) {
        this.toDoTaskMap = toDoTaskMap;
    }

    public void setToDoTasks(List<JSONObject> toDoTasks) {
        this.toDoTasks = toDoTasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserMessageActionContext)) {
            return false;
        }
        UserMessageActionContext other = (UserMessageActionContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sentence = this.getSentence();
        String other$sentence = other.getSentence();
        if (this$sentence == null ? other$sentence != null : !this$sentence.equals(other$sentence)) {
            return false;
        }
        String this$sentenceContext = this.getSentenceContext();
        String other$sentenceContext = other.getSentenceContext();
        if (this$sentenceContext == null ? other$sentenceContext != null : !this$sentenceContext.equals(other$sentenceContext)) {
            return false;
        }
        List this$userContextMessages = this.getUserContextMessages();
        List other$userContextMessages = other.getUserContextMessages();
        if (this$userContextMessages == null ? other$userContextMessages != null : !((Object)this$userContextMessages).equals(other$userContextMessages)) {
            return false;
        }
        List this$effectiveIncompleteTaskList = this.getEffectiveIncompleteTaskList();
        List other$effectiveIncompleteTaskList = other.getEffectiveIncompleteTaskList();
        if (this$effectiveIncompleteTaskList == null ? other$effectiveIncompleteTaskList != null : !((Object)this$effectiveIncompleteTaskList).equals(other$effectiveIncompleteTaskList)) {
            return false;
        }
        Set this$referenceFriendNames = this.getReferenceFriendNames();
        Set other$referenceFriendNames = other.getReferenceFriendNames();
        if (this$referenceFriendNames == null ? other$referenceFriendNames != null : !((Object)this$referenceFriendNames).equals(other$referenceFriendNames)) {
            return false;
        }
        Set this$referenceGroupNames = this.getReferenceGroupNames();
        Set other$referenceGroupNames = other.getReferenceGroupNames();
        if (this$referenceGroupNames == null ? other$referenceGroupNames != null : !((Object)this$referenceGroupNames).equals(other$referenceGroupNames)) {
            return false;
        }
        Integer this$first = this.getFirst();
        Integer other$first = other.getFirst();
        if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
            return false;
        }
        JSONObject this$msgExt = this.getMsgExt();
        JSONObject other$msgExt = other.getMsgExt();
        if (this$msgExt == null ? other$msgExt != null : !this$msgExt.equals(other$msgExt)) {
            return false;
        }
        ImMessageLog this$imMessageLog = this.getImMessageLog();
        ImMessageLog other$imMessageLog = other.getImMessageLog();
        if (this$imMessageLog == null ? other$imMessageLog != null : !this$imMessageLog.equals(other$imMessageLog)) {
            return false;
        }
        List this$effectiveIncompleteTaskNameToMsgIdList = this.getEffectiveIncompleteTaskNameToMsgIdList();
        List other$effectiveIncompleteTaskNameToMsgIdList = other.getEffectiveIncompleteTaskNameToMsgIdList();
        if (this$effectiveIncompleteTaskNameToMsgIdList == null ? other$effectiveIncompleteTaskNameToMsgIdList != null : !((Object)this$effectiveIncompleteTaskNameToMsgIdList).equals(other$effectiveIncompleteTaskNameToMsgIdList)) {
            return false;
        }
        Map this$toDoTaskMap = this.getToDoTaskMap();
        Map other$toDoTaskMap = other.getToDoTaskMap();
        if (this$toDoTaskMap == null ? other$toDoTaskMap != null : !((Object)this$toDoTaskMap).equals(other$toDoTaskMap)) {
            return false;
        }
        List this$toDoTasks = this.getToDoTasks();
        List other$toDoTasks = other.getToDoTasks();
        return !(this$toDoTasks == null ? other$toDoTasks != null : !((Object)this$toDoTasks).equals(other$toDoTasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserMessageActionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sentence = this.getSentence();
        result = result * 59 + ($sentence == null ? 43 : $sentence.hashCode());
        String $sentenceContext = this.getSentenceContext();
        result = result * 59 + ($sentenceContext == null ? 43 : $sentenceContext.hashCode());
        List $userContextMessages = this.getUserContextMessages();
        result = result * 59 + ($userContextMessages == null ? 43 : ((Object)$userContextMessages).hashCode());
        List $effectiveIncompleteTaskList = this.getEffectiveIncompleteTaskList();
        result = result * 59 + ($effectiveIncompleteTaskList == null ? 43 : ((Object)$effectiveIncompleteTaskList).hashCode());
        Set $referenceFriendNames = this.getReferenceFriendNames();
        result = result * 59 + ($referenceFriendNames == null ? 43 : ((Object)$referenceFriendNames).hashCode());
        Set $referenceGroupNames = this.getReferenceGroupNames();
        result = result * 59 + ($referenceGroupNames == null ? 43 : ((Object)$referenceGroupNames).hashCode());
        Integer $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        JSONObject $msgExt = this.getMsgExt();
        result = result * 59 + ($msgExt == null ? 43 : $msgExt.hashCode());
        ImMessageLog $imMessageLog = this.getImMessageLog();
        result = result * 59 + ($imMessageLog == null ? 43 : $imMessageLog.hashCode());
        List $effectiveIncompleteTaskNameToMsgIdList = this.getEffectiveIncompleteTaskNameToMsgIdList();
        result = result * 59 + ($effectiveIncompleteTaskNameToMsgIdList == null ? 43 : ((Object)$effectiveIncompleteTaskNameToMsgIdList).hashCode());
        Map $toDoTaskMap = this.getToDoTaskMap();
        result = result * 59 + ($toDoTaskMap == null ? 43 : ((Object)$toDoTaskMap).hashCode());
        List $toDoTasks = this.getToDoTasks();
        result = result * 59 + ($toDoTasks == null ? 43 : ((Object)$toDoTasks).hashCode());
        return result;
    }

    public String toString() {
        return "UserMessageActionContext(sentence=" + this.getSentence() + ", sentenceContext=" + this.getSentenceContext() + ", userContextMessages=" + this.getUserContextMessages() + ", effectiveIncompleteTaskList=" + this.getEffectiveIncompleteTaskList() + ", referenceFriendNames=" + this.getReferenceFriendNames() + ", referenceGroupNames=" + this.getReferenceGroupNames() + ", first=" + this.getFirst() + ", msgExt=" + this.getMsgExt() + ", imMessageLog=" + this.getImMessageLog() + ", effectiveIncompleteTaskNameToMsgIdList=" + this.getEffectiveIncompleteTaskNameToMsgIdList() + ", toDoTaskMap=" + this.getToDoTaskMap() + ", toDoTasks=" + this.getToDoTasks() + ")";
    }
}

