/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GetPublishedInfoDto {
    private String assistantId;
    private String version;
    private String baseURL;

    public static Map<String, List<GetPublishedInfoDto>> getPublishedInfoDtoList(FusionAssistantPublishDto dto) {
        return dto.getEvent().stream().map(event -> {
            GetPublishedInfoDto gp = new GetPublishedInfoDto();
            gp.setAssistantId(event.getString("assistantId"));
            gp.setVersion(event.getString("version"));
            gp.setBaseURL(event.getString("baseURL"));
            return gp;
        }).collect(Collectors.groupingBy(event -> event.getAssistantId()));
    }

    public static Map getAssistantMap(JSONArray jsonArray) {
        HashMap<String, JSONObject> assistantMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject assistant = jsonArray.getJSONObject(i);
            String assistantId = assistant.getString("assistantId");
            assistantMap.put(assistantId, assistant);
        }
        return assistantMap;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetPublishedInfoDto)) {
            return false;
        }
        GetPublishedInfoDto other = (GetPublishedInfoDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$baseURL = this.getBaseURL();
        String other$baseURL = other.getBaseURL();
        return !(this$baseURL == null ? other$baseURL != null : !this$baseURL.equals(other$baseURL));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetPublishedInfoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $baseURL = this.getBaseURL();
        result = result * 59 + ($baseURL == null ? 43 : $baseURL.hashCode());
        return result;
    }

    public String toString() {
        return "GetPublishedInfoDto(assistantId=" + this.getAssistantId() + ", version=" + this.getVersion() + ", baseURL=" + this.getBaseURL() + ")";
    }
}

