/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.io.agora.chat.media;

import com.digiwin.athena.ania.io.agora.chat.media.AccessToken2;
import com.digiwin.athena.ania.io.agora.chat.media.ByteBuf;
import com.digiwin.athena.ania.util.Utils;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccessToken2 {
    private static final String VERSION = "007";
    public static final short SERVICE_TYPE_RTC = 1;
    public static final short SERVICE_TYPE_RTM = 2;
    public static final short SERVICE_TYPE_FPA = 4;
    public static final short SERVICE_TYPE_CHAT = 5;
    public static final short SERVICE_TYPE_EDUCATION = 7;
    public String appCert = "";
    public String appId = "";
    public int expire;
    public int issueTs;
    public int salt;
    public Map<Short, Service> services = new TreeMap();

    public AccessToken2() {
    }

    public AccessToken2(String appId, String appCert, int expire) {
        this.appCert = appCert;
        this.appId = appId;
        this.expire = expire;
        this.issueTs = Utils.getTimestamp();
        this.salt = Utils.randomInt();
    }

    public void addService(Service service) {
        this.services.put(service.getServiceType(), service);
    }

    public String build() throws Exception {
        if (!Utils.isUUID((String)this.appId) || !Utils.isUUID((String)this.appCert)) {
            return "";
        }
        ByteBuf buf = new ByteBuf().put(this.appId).put(this.issueTs).put(this.expire).put(this.salt).put((short)this.services.size());
        byte[] signing = this.getSign();
        this.services.forEach((k, v) -> v.pack(buf));
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(signing, "HmacSHA256"));
        byte[] signature = mac.doFinal(buf.asBytes());
        ByteBuf bufferContent = new ByteBuf();
        bufferContent.put(signature);
        bufferContent.buffer.put(buf.asBytes());
        return AccessToken2.getVersion() + Utils.base64Encode((byte[])Utils.compress((byte[])bufferContent.asBytes()));
    }

    public Service getService(short serviceType) {
        if (serviceType == 1) {
            return new ServiceRtc();
        }
        if (serviceType == 2) {
            return new ServiceRtm();
        }
        if (serviceType == 4) {
            return new ServiceFpa();
        }
        if (serviceType == 5) {
            return new ServiceChat();
        }
        if (serviceType == 7) {
            return new ServiceEducation();
        }
        throw new IllegalArgumentException(String.format("unknown service type: `%d`", serviceType));
    }

    public byte[] getSign() throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(new ByteBuf().put(this.issueTs).asBytes(), "HmacSHA256"));
        byte[] signing = mac.doFinal(this.appCert.getBytes());
        mac.init(new SecretKeySpec(new ByteBuf().put(this.salt).asBytes(), "HmacSHA256"));
        return mac.doFinal(signing);
    }

    public static String getUidStr(int uid) {
        if (uid == 0) {
            return "";
        }
        return String.valueOf((long)uid & 0xFFFFFFFFL);
    }

    public static String getVersion() {
        return "007";
    }

    public boolean parse(String token) {
        if (!AccessToken2.getVersion().equals(token.substring(0, 3))) {
            return false;
        }
        try {
            byte[] data = Utils.decompress((byte[])Utils.base64Decode((String)token.substring(3)));
            ByteBuf buff = new ByteBuf(data);
            String signature = buff.readString();
            this.appId = buff.readString();
            this.issueTs = buff.readInt();
            this.expire = buff.readInt();
            this.salt = buff.readInt();
            int servicesNum = buff.readShort();
            for (int i = 0; i < servicesNum; ++i) {
                short serviceType = buff.readShort();
                Service service = this.getService(serviceType);
                service.unpack(buff);
                this.services.put(serviceType, service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

