/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.configuration.KnowledgeAccountConfig;
import com.digiwin.athena.ania.dto.AnswerMessageVo;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.util.EventMessageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeAssistantService {
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private KnowledgeAccountConfig knowledgeAccountConfig;

    public List<AnswerMessageVo> getMessagesByIds(Map<String, List<String>> msgIds) {
        List<String> stringList = msgIds.get("msgIds");
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List asaKnowledgeMessages = this.asaKnowledgeMessageDao.findByUserIdAndIdIn(authoredUser.getUserId(), stringList);
        if (CollectionUtils.isNotEmpty((Collection)asaKnowledgeMessages)) {
            return asaKnowledgeMessages.stream().map(asaKnowledgeMessage -> this.coverAnswerMessageVo(asaKnowledgeMessage, this.knowledgeAccountConfig.isReferencedAttachmentSwitch())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public AnswerMessageVo coverAnswerMessageVo(AsaKnowledgeMessage answerMessage, boolean referencedAttachmentSwitch) {
        if (Objects.isNull(answerMessage)) {
            return null;
        }
        AnswerMessageVo message = AnswerMessageVo.builder().id(answerMessage.getId()).msg(answerMessage.getMsg()).msgId(answerMessage.getMsgId()).assistantCode(answerMessage.getAssistantCode()).canceled(answerMessage.getCanceled()).functionList(answerMessage.getFunctionList()).cardList(answerMessage.getCardList()).content(answerMessage.getContent()).headInfo(answerMessage.getHeadInfo()).build();
        if (referencedAttachmentSwitch) {
            message.setReferencedAttachments(answerMessage.getReferencedAttachments());
        }
        if (Objects.isNull(message.getContent())) {
            ArrayList<EventData.EventMessage> answerMessages = new ArrayList<EventData.EventMessage>();
            if (StrUtil.isNotBlank((CharSequence)answerMessage.getMsg())) {
                answerMessages.add(new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerMessage.getMsg()));
            }
            if (CollUtil.isNotEmpty((Collection)answerMessage.getCardList())) {
                answerMessages.addAll(answerMessage.getCardList());
            }
            message.setContent(EventMessageUtils.buildAnswerContent(answerMessages));
        }
        if (Objects.isNull(message.getHeadInfo())) {
            message.setHeadInfo(EventMessageUtils.buildHeadInfoContent((List)answerMessage.getFunctionList()));
        }
        return message;
    }
}

