/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.dto.AniaEventLogBuilder;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.FlowContent;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.LmcClientUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class CommonEventSourceListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(CommonEventSourceListener.class);
    protected SseEventParams sseEventParams;
    protected SseEventDataService sseEventDataService;
    protected Boolean buildEvent;
    @NotBlank
    protected String callId = UUID.randomUUID().toString().replace("-", "");
    protected static final int SEE_ERROR_DATA_ANALYSIS = 1;
    protected static final int SEE_RESPONSE_FAILED = 2;
    protected Map<Integer, SseFlow> flowMap = new HashMap();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void onOpen(EventSource eventSource, Response response) {
        RedisUtils.cacheStrData((String)("ANIA:ASSISTANT:CHAT:" + this.sseEventParams.getQuestionMessage().getConversationId()), (String)this.sseEventParams.getQuestionMessage().getMessageId(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        MdcUtil.setTraceId((String)this.sseEventParams.getTraceId());
        log.info("CommonEventSourceListener.onOpen sseEventParams:{}", (Object)this.sseEventParams);
        String sseEmitterId = this.sseEventParams.getId();
        KnowledgeContext.setKnowledgeEventSource((String)sseEmitterId, (EventSource)eventSource);
        LmcClientUtils.saveEventLog((SaveEventLog)this.onOpenLog(eventSource), (String)this.sseEventParams.getUser().getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        String responseString = this.responseString(response);
        FlowContent.flowEnd((Map)this.flowMap, (SseEventParams)this.sseEventParams, (String)(Objects.nonNull(t) ? t.getMessage() : responseString));
        log.error("CommonEventSourceListener.onFailure:{} response:{},sseEventParams:{}", new Object[]{t, response, this.sseEventParams});
        String sseEmitterId = this.sseEventParams.getId();
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
        String answer = null;
        try {
            if (Objects.isNull(response) || !response.isSuccessful()) {
                answer = this.defaultErrorMsg(Integer.valueOf(2));
            } else {
                ResponseBody responseBody = response.body();
                MediaType contentType = responseBody.contentType();
                if (contentType != null && "text".equals(contentType.type()) && contentType.subtype().equals("event-stream")) {
                    if (!SseEventContext.noSupplyTerminate((String)sseEmitterId)) {
                        answer = this.defaultErrorMsg(Integer.valueOf(1));
                    }
                } else {
                    if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                        return;
                    }
                    answer = this.getErrorMsg(responseString);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)answer) && !BooleanUtils.isTrue((Boolean)this.buildEvent)) {
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent());
                eventData.setData(new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
                this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
                SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
        }
        catch (Exception e) {
            log.error("CommonEventSourceListener.onFailure is error sseEmitterId:{}", (Object)sseEmitterId, (Object)e);
        }
        finally {
            LmcClientUtils.saveEventLog((SaveEventLog)this.onFailureEventLog(eventSource, t, responseString), (String)this.sseEventParams.getUser().getToken());
            if (Objects.nonNull(sseEmitter)) {
                this.chatComplete(sseEmitter);
                this.sendAnswerDone(sseEmitter, false);
            }
        }
    }

    protected SaveEventLog onOpenLog(EventSource eventSource) {
        try {
            JSONObject requestParam = this.getRequestParam(eventSource);
            requestParam.put("assistantCode", (Object)this.sseEventParams.getAssistant().getAssistantCode());
            return AniaEventLogBuilder.anAniaEventLog().withEventId(this.sseEventParams.getId()).withEventName(this.getClass().getName()).withEventSource(this.sseEventParams.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(eventSource.request().url().toString()).withStatus(Integer.valueOf(0)).withTenantId(this.sseEventParams.getUser().getTenantId()).withTenantName(this.sseEventParams.getUser().getTenantName()).withUserId(this.sseEventParams.getUser().getUserId()).withUserName(this.sseEventParams.getUser().getUserName()).withRequestType("POST").withRequestParam(BaseUseUtils.toJsonString((Object)requestParam)).withJsonResult("success").withContent((Map)requestParam).build();
        }
        catch (Exception ex) {
            log.error("onOpenLog is error", (Throwable)ex);
            return null;
        }
    }

    protected SaveEventLog onFailureEventLog(EventSource eventSource, Throwable t, String responseString) {
        try {
            String errorMsg = null;
            if (Objects.nonNull(t)) {
                errorMsg = t.getMessage();
            }
            JSONObject requestParam = this.getRequestParam(eventSource);
            requestParam.put("assistantCode", (Object)this.sseEventParams.getAssistant().getAssistantCode());
            return AniaEventLogBuilder.anAniaEventLog().withEventId(this.sseEventParams.getId()).withEventName(this.getClass().getName()).withEventSource(this.sseEventParams.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(eventSource.request().url().toString()).withErrorMsg(errorMsg).withStatus(Integer.valueOf(1)).withTenantId(this.sseEventParams.getUser().getTenantId()).withTenantName(this.sseEventParams.getUser().getTenantName()).withUserId(this.sseEventParams.getUser().getUserId()).withUserName(this.sseEventParams.getUser().getUserName()).withRequestType("POST").withContent((Map)requestParam).withRequestParam(BaseUseUtils.toJsonString((Object)requestParam)).withJsonResult(responseString).build();
        }
        catch (Exception ex) {
            log.error("onFailureEventLog is error", (Throwable)ex);
            return null;
        }
    }

    protected String responseString(Response response) {
        try {
            ResponseBody body;
            String result = null;
            if (Objects.nonNull(response) && Objects.nonNull(body = response.body())) {
                result = body.string();
            }
            return result;
        }
        catch (Exception ex) {
            log.error("responseString is error", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(EventSource eventSource) {
        log.info("CommonEventSourceListener.onClosed sseEventParams:{}", (Object)this.sseEventParams);
        SseEmitter sseEmitter = null;
        boolean success = true;
        try {
            String sseEmitterId = this.sseEventParams.getId();
            KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
            sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
            if (sseEmitter != null) {
                if (!BooleanUtils.isTrue((Boolean)this.buildEvent) && !SseEventContext.noSupplyTerminate((String)sseEmitterId)) {
                    success = false;
                    String errorMsg = this.defaultErrorMsg(Integer.valueOf(2));
                    EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), errorMsg);
                    this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
                    SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
                    SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                }
            } else {
                KnowledgeContext.removeAnswerStatus((String)sseEmitterId);
            }
            FlowContent.flowEnd((Map)this.flowMap, (SseEventParams)this.sseEventParams, (boolean)success);
        }
        catch (Exception ex) {
            try {
                log.error("CommonEventSourceListener.onClosed is error sseEventParams:{}", (Object)BaseUseUtils.toJsonString((Object)this.sseEventParams), (Object)ex);
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(sseEmitter)) {
                    this.chatComplete(sseEmitter);
                    this.sendAnswerDone(sseEmitter, success);
                }
                MdcUtil.clear();
                throw throwable;
            }
            if (Objects.nonNull(sseEmitter)) {
                this.chatComplete(sseEmitter);
                this.sendAnswerDone(sseEmitter, success);
            }
            MdcUtil.clear();
        }
        if (Objects.nonNull(sseEmitter)) {
            this.chatComplete(sseEmitter);
            this.sendAnswerDone(sseEmitter, success);
        }
        MdcUtil.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAnswerDone(SseEmitter sseEmitter, boolean success) {
        EventData eventData = new EventData(success ? SseEventlEnum.CHAT_DONE.getEvent() : SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
        try {
            SseEmitterUtils.send((String)this.sseEventParams.getId(), (EventData)eventData);
            SseEventContext.setAnswer((String)this.sseEventParams.getId(), (EventData)eventData);
        }
        catch (IOException e) {
            log.error("SceneEventSourceListener.sendAnswerDone is error", (Throwable)e);
        }
        finally {
            sseEmitter.complete();
        }
    }

    protected void chatComplete(SseEmitter sseEmitter) {
        try {
            EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
            this.sseEventDataService.saveEventDataLog(this.sseEventParams, completed);
            SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
            SseEventContext.setAnswer((String)this.sseEventParams.getId(), (EventData)completed);
        }
        catch (IOException e) {
            log.error("KnowledgeEventSourceListener.chatComplete is error sseEventParams:{}", (Object)BaseUseUtils.toJsonString((Object)this.sseEventParams), (Object)e);
        }
    }

    protected String getKnowledgeType(EventSource eventSource) {
        return this.getRequestParam(eventSource).getString("knowledgeType");
    }

    private JSONObject getRequestParam(EventSource eventSource) {
        Request request = eventSource.request();
        return (JSONObject)request.tag(JSONObject.class);
    }

    protected String getLanguage(EventSource eventSource) {
        Request request = eventSource.request();
        String language = request.header("Accept-Language");
        if (StringUtils.isBlank((CharSequence)language)) {
            language = LocalsEnum.CN.getCode();
        }
        return language.replace("-", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorMsg(ResponseBody responseBody) {
        String errorMsg = null;
        try {
            String string = responseBody.string();
            log.info("SceneEventSourceListener.getErrorMsg responseBody:{}", (Object)string);
            JSONObject result = JSON.parseObject((String)string);
            errorMsg = MapUtils.getString((Map)result, (Object)"message");
            return errorMsg;
        }
        catch (Exception e) {
            log.error("SceneEventSourceListener.getErrorMsg is error", (Throwable)e);
        }
        finally {
            if (StringUtils.isBlank(errorMsg)) {
                errorMsg = this.defaultErrorMsg(null);
            }
            return errorMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorMsg(String responseString) {
        String errorMsg = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)responseString)) {
                log.info("SceneEventSourceListener.getErrorMsg responseBody:{}", (Object)responseString);
                JSONObject result = JSON.parseObject((String)responseString);
                errorMsg = MapUtils.getString((Map)result, (Object)"message");
                return errorMsg;
            }
        }
        catch (Exception e) {
            log.error("SceneEventSourceListener.getErrorMsg is error", (Throwable)e);
        }
        finally {
            if (StringUtils.isBlank(errorMsg)) {
                errorMsg = this.defaultErrorMsg(null);
            }
            return errorMsg;
        }
    }

    protected String defaultErrorMsg(Integer type) {
        if (Objects.equals(2, type)) {
            return LocalsEnum.isCn((String)this.sseEventParams.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u6682\u65e0\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u66ab\u7121\u97ff\u61c9\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        if (Objects.equals(1, type)) {
            return LocalsEnum.isCn((String)this.sseEventParams.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8fd4\u56de\u6578\u64da\u89e3\u6790\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        return LocalsEnum.isCn((String)this.sseEventParams.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
    }
}

