/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.configuration.KnowledgeAccountConfig;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class KnowledgeEventSourceListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeEventSourceListener.class);
    @Resource
    private KnowledgeAccountConfig knowledgeAccountConfig;

    public void onOpen(EventSource eventSource, Response response) {
        log.info("\u5efa\u7acbsse\u8fde\u63a5...");
        String sseEmitterId = this.getSseEmitterId(eventSource);
        KnowledgeContext.setKnowledgeEventSource((String)sseEmitterId, (EventSource)eventSource);
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        log.info("KnowledgeEventSourceListener.onEvent id:{},type:{},data:{}", new Object[]{id, type, data});
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            JSONObject answerContent;
            String sseEmitterId = this.getSseEmitterId(eventSource);
            KnowledgeContext.setAnswerStatus((String)sseEmitterId, (String)"answer");
            String knowledgeType = this.getKnowledgeType(eventSource);
            if ("private".equals(knowledgeType)) {
                if ("status".equals(type) && "success".equals(data) || "file".equals(type)) {
                    return;
                }
                answerContent = KnowledgeContext.buildData((String)type, (String)"running", (String)data);
            } else {
                String message;
                JSONObject knowledgeBaseAnswer = JSONObject.parseObject((String)data);
                String status = knowledgeBaseAnswer.getString("status");
                if ("file".equals(type)) {
                    message = knowledgeBaseAnswer.getString("message");
                    if (StringUtils.isEmpty((CharSequence)message)) {
                        return;
                    }
                    answerContent = new JSONObject().fluentPut("msg", (Object)message).fluentPut("status", (Object)status).fluentPut("event", (Object)type);
                } else {
                    message = knowledgeBaseAnswer.getString("message").replace("`", "");
                    if (StringUtils.isEmpty((CharSequence)message)) {
                        return;
                    }
                    answerContent = KnowledgeContext.buildData((String)type, (String)status, (String)message);
                }
            }
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
            if (sseEmitter == null) {
                eventSource.cancel();
                KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
            }
            try {
                sseEmitter.send(SseEmitter.event().data((Object)answerContent));
                String msg = answerContent.getString("msg");
                if ("file".equals(type)) {
                    JSONArray referencedAttachment = KnowledgeContext.getReferencedAttachments((String)sseEmitterId);
                    JSONArray objects = JSONArray.parseArray((String)msg);
                    if (CollectionUtils.isNotEmpty((Collection)referencedAttachment)) {
                        referencedAttachment.add((Object)objects);
                        KnowledgeContext.setReferencedAttachments((String)sseEmitterId, (JSONArray)referencedAttachment);
                    } else {
                        KnowledgeContext.setReferencedAttachments((String)sseEmitterId, (JSONArray)objects);
                    }
                } else {
                    String answer = KnowledgeContext.getAnswer((String)sseEmitterId);
                    if (Objects.nonNull(answer)) {
                        StringBuffer sb = new StringBuffer(answer);
                        sb.append(msg);
                        KnowledgeContext.setAnswer((String)sseEmitterId, (String)sb.toString());
                    } else {
                        KnowledgeContext.setAnswer((String)sseEmitterId, (String)msg);
                    }
                }
            }
            catch (IOException e) {
                log.error("KnowledgeEventSourceListener.onEvent is error id:{},type:{},data:{}", new Object[]{id, type, data, e});
                KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
                eventSource.cancel();
                sseEmitter.complete();
            }
        }
    }

    public void onClosed(EventSource eventSource) {
        String sseEmitterId = this.getSseEmitterId(eventSource);
        KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
        if (sseEmitter != null) {
            sseEmitter.complete();
        } else {
            KnowledgeContext.removeAnswerStatus((String)sseEmitterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        log.error("KnowledgeEventSourceListener.onFailure:{} response:{}", (Object)t, (Object)response);
        String sseEmitterId = this.getSseEmitterId(eventSource);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
        try {
            if (!response.isSuccessful()) {
                String language = this.getLanguage(eventSource);
                String answer = response.code() == 429 ? (LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u5f53\u524d\u7cfb\u7edf\u8bbf\u95ee\u91cf\u8fc7\u9ad8\uff0c\u5efa\u8bae\u60a8\u7a0d\u540e\u518d\u5c1d\u8bd5\uff0c\u611f\u8c22\u60a8\u7684\u7406\u89e3\uff01" : "\u62b1\u6b49\uff0c\u7576\u524d\u7cfb\u7d71\u8a2a\u554f\u91cf\u904e\u9ad8\uff0c\u5efa\u8b70\u60a8\u7a0d\u5f8c\u518d\u5617\u8a66\uff0c\u611f\u8b1d\u60a8\u7684\u7406\u89e3\uff01") : (LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u6682\u65e0\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u66ab\u7121\u97ff\u61c9\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002");
                this.sendAnswer(sseEmitter, answer);
                KnowledgeContext.setAnswer((String)sseEmitterId, (String)answer);
            } else {
                ResponseBody responseBody = response.body();
                MediaType contentType = responseBody.contentType();
                if (contentType != null && "text".equals(contentType.type()) && contentType.subtype().equals("event-stream")) {
                    String answer = KnowledgeContext.getAnswer((String)sseEmitterId);
                    if (StringUtils.isBlank((CharSequence)answer)) {
                        String language = this.getLanguage(eventSource);
                        answer = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8fd4\u56de\u6578\u64da\u89e3\u6790\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                        this.sendAnswer(sseEmitter, answer);
                        KnowledgeContext.setAnswer((String)sseEmitterId, (String)answer);
                    }
                } else {
                    if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                        return;
                    }
                    String language = this.getLanguage(eventSource);
                    String answer = this.getErrorMsg(responseBody, language);
                    if (StringUtils.isBlank((CharSequence)KnowledgeContext.getAnswer((String)sseEmitterId))) {
                        this.sendAnswer(sseEmitter, answer);
                        KnowledgeContext.setAnswer((String)sseEmitterId, (String)answer);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("KnowledgeEventSourceListener.onFailure is error sseEmitterId:{}", (Object)sseEmitterId, (Object)e);
        }
        finally {
            KnowledgeContext.setAnswerStatus((String)sseEmitterId, (String)"fail");
            sseEmitter.complete();
        }
    }

    private void sendAnswer(SseEmitter sseEmitter, String answer) throws IOException {
        sseEmitter.send(SseEmitter.event().data((Object)KnowledgeContext.buildData((String)"answer", (String)"success", (String)answer)));
    }

    private String getSseEmitterId(EventSource eventSource) {
        Request request = eventSource.request();
        JSONObject param = (JSONObject)request.tag(JSONObject.class);
        return param.getString("messageId");
    }

    private String getKnowledgeType(EventSource eventSource) {
        Request request = eventSource.request();
        JSONObject param = (JSONObject)request.tag(JSONObject.class);
        return param.getString("knowledgeType");
    }

    private String getLanguage(EventSource eventSource) {
        Request request = eventSource.request();
        String language = request.header("Accept-Language");
        if (StringUtils.isBlank((CharSequence)language)) {
            language = LocalsEnum.CN.getCode();
        }
        return language.replace("-", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMsg(ResponseBody responseBody, String language) {
        String errorMsg = null;
        try {
            String string = responseBody.string();
            log.info("KnowledgeEventSourceListener.getErrorMsg responseBody:{}", (Object)string);
            JSONObject result = JSON.parseObject((String)string);
            errorMsg = MapUtils.getString((Map)result, (Object)"message");
        }
        catch (Exception e) {
            try {
                log.error("KnowledgeEventSourceListener.getErrorMsg is error", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (StringUtils.isBlank(errorMsg)) {
                    errorMsg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                }
                return errorMsg;
            }
            if (StringUtils.isBlank(errorMsg)) {
                errorMsg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            }
            return errorMsg;
        }
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        return errorMsg;
    }
}

