/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.helper.OkHttpUtil;
import com.digiwin.athena.ania.knowledge.client.sse.SSEListener;
import com.digiwin.athena.ania.knowledge.context.SseContext;
import java.util.Map;
import java.util.function.Function;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEClient {
    private static final Logger log = LoggerFactory.getLogger(SSEClient.class);

    public static void executeSSE(String url, String authToken, SSEListener eventSourceListener, JSONObject requestBody, String language, Map<String, Function> functions) throws Exception {
        log.info("Sse public kbs request body : {}", (Object)requestBody.toJSONString());
        RequestBody formBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestBody.toJSONString());
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.addHeader("token", authToken);
        requestBuilder.addHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        requestBuilder.addHeader("Accept-Language", language);
        Request request = requestBuilder.url(url).post(formBody).build();
        EventSource.Factory factory = EventSources.createFactory((OkHttpClient)OkHttpUtil.getInstance(functions));
        EventSource eventSource = factory.newEventSource(request, (EventSourceListener)eventSourceListener);
        SseContext.setEventSource((String)requestBody.getString("messageId"), (EventSource)eventSource);
        eventSourceListener.getCountDownLatch().await();
    }

    public static void executeSSEPrivateKnowledge(String url, String digiKaiChatApiKey, String authToken, SSEListener eventSourceListener, JSONObject requestBody, String language, Map<String, Function> functions) throws Exception {
        log.info("Sse private kbs request body : {}", (Object)requestBody.toJSONString());
        RequestBody formBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestBody.toJSONString());
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.addHeader("content-type", "application/json");
        requestBuilder.addHeader("token", authToken);
        requestBuilder.addHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        requestBuilder.addHeader("Accept-Language", language.replace("_", "-"));
        requestBuilder.addHeader("digi-kai-api-key", digiKaiChatApiKey);
        Request request = requestBuilder.url(url).post(formBody).build();
        EventSource.Factory factory = EventSources.createFactory((OkHttpClient)OkHttpUtil.getInstance(functions));
        EventSource eventSource = factory.newEventSource(request, (EventSourceListener)eventSourceListener);
        SseContext.setEventSource((String)requestBody.getString("messageId"), (EventSource)eventSource);
        eventSourceListener.getCountDownLatch().await();
    }
}

