/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.intentflow;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.common.enums.SseFlowToolTypeEnum;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class SseFlow {
    private static final Logger log = LoggerFactory.getLogger(SseFlow.class);
    @Autowired
    private SseEventDataService sseEventDataService;
    protected SseEventlEnum messageCompleted = SseEventlEnum.MESSAGE_COMPLETED;
    protected TimedCache<String, IntentFlowEventData.IntentEventMessage> intentEventMap = new TimedCache(900000L, new ConcurrentHashMap());

    public abstract SseFlowToolTypeEnum getFlowType();

    public void flowStart(SseEventParams sseEventParams) {
        try {
            IntentFlowEventData.IntentEventMessage intentEventMessage = new IntentFlowEventData.IntentEventMessage();
            intentEventMessage.setExtraInfo(this.getFlowType());
            intentEventMessage.setMessageName(this.getFlowType().getTitle(sseEventParams));
            intentEventMessage.setMessage_type(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
            intentEventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType());
            intentEventMessage.setStatus("available");
            this.putIntentEventMessage(sseEventParams, intentEventMessage);
            this.specificStart(sseEventParams);
            this.sendFlowDong(sseEventParams);
        }
        catch (Exception e) {
            log.error("SseFlow.flowStart flowEnd sseFlowToolTypeEnum:{},sseEventParams:{}", new Object[]{this.getFlowType().getTitle(sseEventParams), JsonUtil.toJSONString((Object)sseEventParams), e});
        }
    }

    public void flowEnd(SseEventParams sseEventParams) {
        this.flowEnd(sseEventParams, "success");
    }

    public void flowEnd(SseEventParams sseEventParams, Boolean result) {
        this.flowEnd(sseEventParams, result != false ? "success" : "fail");
    }

    public void flowEnd(SseEventParams sseEventParams, String errorMsg) {
        try {
            IntentFlowEventData.IntentEventMessage intentEventMessage = this.getIntentEventMessage(sseEventParams);
            if (Objects.isNull(intentEventMessage) || !Objects.equals(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType(), intentEventMessage.getType())) {
                return;
            }
            if (Objects.equals(errorMsg, "success")) {
                intentEventMessage.setStatus("success");
            } else {
                intentEventMessage.setStatus("fail");
                String message = intentEventMessage.getMessage();
                JSONObject messageJson = JSONObject.parseObject((String)message);
                messageJson.fluentPut("errorMsg", (Object)errorMsg);
                intentEventMessage.setMessage(messageJson.toString());
            }
            intentEventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType());
            this.putIntentEventMessage(sseEventParams, intentEventMessage);
            this.specificEnd(sseEventParams);
            this.sendFlowDong(sseEventParams);
        }
        catch (Exception e) {
            log.error("SseFlow.flowEnd flowEnd sseFlowToolTypeEnum:{},sseEventParams:{}", new Object[]{this.getFlowType().getTitle(sseEventParams), JsonUtil.toJSONString((Object)sseEventParams), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFlowDong(SseEventParams sseEventParams) {
        try {
            IntentFlowEventData.IntentEventMessage intentEventMessage = this.getIntentEventMessage(sseEventParams);
            IntentFlowEventData intentFlow = new IntentFlowEventData(this.messageCompleted, intentEventMessage);
            this.sendEventData(sseEventParams, (EventData)ObjectUtil.clone((Object)intentFlow));
        }
        finally {
            this.intentEventMap.remove((Object)sseEventParams.getId());
        }
    }

    public abstract void specificStart(SseEventParams var1);

    public abstract void specificEnd(SseEventParams var1);

    public IntentFlowEventData.IntentEventMessage getIntentEventMessage(SseEventParams sseEventParams) {
        return (IntentFlowEventData.IntentEventMessage)this.intentEventMap.get((Object)(sseEventParams.getId() + "_" + this.getFlowType()));
    }

    public void putIntentEventMessage(SseEventParams sseEventParams, IntentFlowEventData.IntentEventMessage intentEventMessage) {
        this.intentEventMap.put((Object)(sseEventParams.getId() + "_" + this.getFlowType()), (Object)intentEventMessage);
    }

    public void sendEventData(SseEventParams sseEventParam, EventData data) {
        try {
            this.sseEventDataService.saveEventDataLog(sseEventParam, data);
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
            SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)data);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)data);
            }
        }
        catch (IOException ex) {
            log.error("SseFlow.sendEventData is error EventData:{}", (Object)BaseUseUtils.toJsonString((Object)data), (Object)ex);
        }
    }
}

