/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.intentflow.scene;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.common.enums.SseFlowToolTypeEnum;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.digiwin.athena.ania.mongo.repository.ChatGptRequestLogMgDao;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntentFlow
extends SseFlow {
    @Autowired
    private ChatGptRequestLogMgDao chatGptRequestLogMgDao;

    public SseFlowToolTypeEnum getFlowType() {
        return SseFlowToolTypeEnum.INTENT_UNDERSTANDING;
    }

    public void specificStart(SseEventParams sseEventParams) {
    }

    public void specificEnd(SseEventParams sseEventParams) {
        IntentFlowEventData.IntentEventMessage intentEventMessage = this.getIntentEventMessage(sseEventParams);
        this.findFunc(sseEventParams, intentEventMessage);
    }

    private void findFunc(SseEventParams sseEventParams, IntentFlowEventData.IntentEventMessage intentEventMessage) {
        ChatGptRequestLog chatGptRequest = new ChatGptRequestLog();
        chatGptRequest.setTraceId(sseEventParams.getTraceId());
        chatGptRequest.setPromptName(ChatGptPromptEnum.INTENT_RECOGNITION.name());
        List identifyScenes = sseEventParams.getIdentifyAllScenes();
        String message = intentEventMessage.getMessage();
        JSONObject messageJson = JSONObject.parseObject((String)message);
        if (Objects.nonNull(sseEventParams.getActionScene()) && Objects.nonNull(sseEventParams.getActionScene().getType())) {
            if (sseEventParams.getActionScene().getType() == 88 && CollUtil.isEmpty((Collection)identifyScenes)) {
                intentEventMessage.setStatus("fail");
                messageJson.fluentPut("errorMsg", (Object)"\u6ca1\u6709\u5339\u914d\u5230\u5177\u4f53\u610f\u56fe");
                messageJson.fluentPut("response", (Object)JSONUtil.parse((Object)sseEventParams.getActionScene()));
                intentEventMessage.setMessage(messageJson.toString());
            } else {
                intentEventMessage.setStatus("success");
                if (CollUtil.isNotEmpty((Collection)identifyScenes)) {
                    List chatGptRequestLogs = this.chatGptRequestLogMgDao.findList(chatGptRequest);
                    if (CollUtil.isNotEmpty((Collection)chatGptRequestLogs)) {
                        ChatGptRequestLog chatGptRequestLog = (ChatGptRequestLog)chatGptRequestLogs.get(0);
                        messageJson.fluentPut("arguments", chatGptRequestLog.getRequestParam());
                        messageJson.fluentPut("response", (Object)chatGptRequestLog.getResult());
                        intentEventMessage.setMessage(messageJson.toString());
                    }
                } else {
                    messageJson.fluentPut("response", (Object)JSONUtil.parse((Object)sseEventParams.getActionScene()));
                }
            }
        } else {
            intentEventMessage.setStatus("fail");
            messageJson.fluentPut("errorMsg", (Object)"\u610f\u56fe\u573a\u666f\u4e3a\u7a7a\u6216\u4f1a\u8bdd\u7ec8\u6b62");
            intentEventMessage.setMessage(messageJson.toString());
        }
    }
}

