/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import cn.hutool.core.collection.ListUtil;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.knowledge.server.AssistantStrategy;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AiProject;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AssistantSSeComponent {
    private static final Logger log = LoggerFactory.getLogger(AssistantSSeComponent.class);
    @Resource
    private KmHelper kmHelper;
    @Resource
    private AssistantService assistantService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private SseEventDataService sseEventDataService;
    @Resource
    private CacHelper cacHelper;
    private Map<Integer, AssistantStrategy> assistantTypeStrategyMap = new HashMap();
    private static List<Integer> assistantSubType = ListUtil.toList((Object[])new Integer[]{1, 2, 4, 6, 3});

    @Autowired
    public void setAssistantStrategyMap(Map<String, AssistantStrategy> assistantStrategyMap) {
        assistantStrategyMap.forEach((k, v) -> this.assistantTypeStrategyMap.put(v.getAssistantSubType(), v));
    }

    public void nlp(SseEventParams sseEventParam) {
        EventData eventData = new EventData(SseEventlEnum.CHAT_CREATED.getEvent(), null);
        eventData.setEventId(sseEventParam.getId());
        this.sseEventDataService.sendEventData(sseEventParam, eventData);
        this.checkSseEventParams(sseEventParam);
        Assistant assistant = sseEventParam.getAssistant();
        if (Objects.isNull(assistant)) {
            this.sseEventDataService.sendAnswerDone(sseEventParam, false);
            return;
        }
        ((AssistantStrategy)this.assistantTypeStrategyMap.get(assistant.getAssistantSubType())).execute(sseEventParam);
    }

    private void checkSseEventParams(SseEventParams sseEventParam) {
        try {
            AiProject aiProject;
            String assistantCode = sseEventParam.getQuestion().getAssistantCode();
            String tenantVersion = this.kmHelper.getTenantVersion(sseEventParam.getUser().getTenantId());
            Assistant assistant = this.assistantService.getAssistant(assistantCode, tenantVersion);
            String language = sseEventParam.getLanguage();
            if (Objects.isNull(assistant) || !assistantSubType.contains(assistant.getAssistantSubType())) {
                String msg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u52a9\u7406\u65e0\u6743\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u52a9\u7406\u7121\u6b0a\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8acb\u8aee\u8a62\u79df\u6236\u7ba1\u7406\u54e1\u3002";
                throw BusinessException.create((String)msg);
            }
            if (!Objects.equals(assistant.getAssistantSubType(), AssistantSubTypeEnum.COMPOSITE.getType()) && !this.cacHelper.hasApplicationAuth(sseEventParam.getUser(), assistantCode)) {
                String msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u52a9\u7406\u672a\u6388\u6743\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u6216\u8005\u987e\u95ee\u6388\u6743\u5f00\u901a\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u52a9\u7406\u672a\u6388\u6b0a\uff0c\u8acb\u806f\u7cfb\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u6388\u6b0a\u958b\u901a\u3002";
                throw BusinessException.create((String)msg);
            }
            if ((assistant.getAssistantSubType() == 4 || assistant.getAssistantSubType() == 3 && !BooleanUtils.isTrue((Boolean)assistant.getSourceCustom())) && Objects.isNull(aiProject = assistant.getAiProject())) {
                String msg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u52a9\u7406ai\u8bed\u4e49\u8d44\u6599\u4e0d\u5b8c\u6574\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u52a9\u7406ai\u8a9e\u7fa9\u8cc7\u6599\u4e0d\u5b8c\u6574\uff0c\u8acb\u8aee\u8a62\u79df\u6236\u7ba1\u7406\u54e1\u3002";
                throw BusinessException.create((String)msg);
            }
            sseEventParam.setAssistant(assistant);
        }
        catch (Exception ex) {
            log.error("AssistantSSeComponent.checkSseEventParams is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
            String answer = null;
            if (ex instanceof BusinessException) {
                BusinessException businessException = (BusinessException)((Object)ex);
                answer = businessException.getMessage();
            }
            if (StringUtils.isEmpty(answer)) {
                answer = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u52a9\u7406\u5f02\u5e38\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u6216\u8005\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u52a9\u7406\u7570\u5e38\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            }
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
            this.sseEventDataService.sendEventData(sseEventParam, eventData);
        }
    }
}

