/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.configuration.KnowledgeAccountConfig;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.client.sse.KnowledgeEventSourceListener;
import com.digiwin.athena.ania.knowledge.server.KnowledgeSseEmitterComponent;
import com.digiwin.athena.ania.knowledge.server.dto.HistoryItem;
import com.digiwin.athena.ania.knowledge.server.dto.KnowledgeAssistantRequestDto;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.AssistantDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.util.ImMessageUtils;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Resource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class KnowledgeAssistantComponent {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeAssistantComponent.class);
    @Resource
    private TokenVerifyService tokenVerifyService;
    @Resource
    private AssistantSceneDao assistantSceneDao;
    @Resource
    private KmHelper kmHelper;
    @Resource
    private KnowledgeSseEmitterComponent knowledgeSseEmitterComponent;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private AssistantDao assistantDao;
    @Resource
    private KnowledgeAccountConfig knowledgeAccountConfig;
    @Resource
    private MessageMongoMapper messageMongoMapper;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private IamHelper iamHelper;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;
    public static final String PRIVATE_KNOWLEDGE_TYPE = "private";

    public void dispatchKnowledgeRequest(KnowledgeAssistantRequestDto knowledgeAssistantRequestDto, String uniId) {
        String tenantVersion = this.kmHelper.getTenantVersion(knowledgeAssistantRequestDto.getTenantId());
        String language = LanguageUtils.processSseLanguage();
        Assistant assistant = this.assistantDao.findAllByAssistantCodeAndVersion(knowledgeAssistantRequestDto.getAssistantCode(), tenantVersion);
        if (Objects.isNull(assistant)) {
            String msg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u52a9\u7406\u65e0\u6743\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u52a9\u7406\u7121\u6b0a\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8acb\u8aee\u8a62\u79df\u6236\u7ba1\u7406\u54e1\u3002";
            throw BusinessException.create((String)msg);
        }
        JSONObject param = new JSONObject();
        param.put("question", (Object)knowledgeAssistantRequestDto.getText());
        param.put("messageId", (Object)uniId);
        param.put("knowledgeType", (Object)assistant.getKnowledgeType());
        if (!PRIVATE_KNOWLEDGE_TYPE.equals(assistant.getKnowledgeType())) {
            String requestUrl;
            String kbAssistantCode;
            AssistantScene assistantScene;
            if (this.knowledgeAccountConfig.isReferencedAttachmentSwitch() && this.knowledgeAccountConfig.getReferencedAttachmentAssistants().contains(knowledgeAssistantRequestDto.getAssistantCode())) {
                param.put("assitantCode", (Object)knowledgeAssistantRequestDto.getAssistantCode());
                param.put("showFile", (Object)true);
            }
            if (Objects.isNull(assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(knowledgeAssistantRequestDto.getAssistantCode(), knowledgeAssistantRequestDto.getAssistantSceneCode(), tenantVersion))) {
                String msg = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u77e5\u8bc6\u5e93\u65e0\u6743\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u54a8\u8be2\u79df\u6237\u7ba1\u7406\u5458\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u77e5\u8b58\u5eab\u7121\u6b0a\u9650\u6216\u4e0d\u5b58\u5728\uff0c\u8acb\u8aee\u8a62\u79df\u6236\u7ba1\u7406\u54e1\u3002";
                throw BusinessException.create((String)msg);
            }
            this.addHistoryParam(knowledgeAssistantRequestDto, param, assistantScene);
            String tenantId = assistantScene.getPublicIdentity().getString("tenantId");
            String token = (String)this.redisTemplate.opsForValue().get((Object)tenantId);
            if (StringUtils.isBlank((CharSequence)token)) {
                token = this.tokenVerifyService.queryApiVirtualToken(tenantId);
                this.redisTemplate.opsForValue().set((Object)tenantId, (Object)token, 1L, TimeUnit.DAYS);
            }
            if ("daa4e1b1bdfdab04".equals(kbAssistantCode = assistantScene.getKnowledgeBase().getString("assistantCode"))) {
                requestUrl = this.envProperties.getUtasUri() + "/api/ai/ddbs/" + kbAssistantCode;
            } else {
                requestUrl = this.envProperties.getKnowledgeUri() + kbAssistantCode;
                log.info("knowledge assistant url:{}\uff0c\u8bf7\u6c42\u77e5\u8bc6\u52a9\u7406\u7684\u53c2\u6570:{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)param));
            }
            KnowledgeEventSourceListener sseListener = new KnowledgeEventSourceListener();
            EventStreamClient.executeSSE((String)requestUrl, null, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)language, (Map)this.getExecuteFunctions(null));
        } else {
            param.put("stream", (Object)true);
            param.put("language", (Object)(LocalsEnum.isCn((String)language) ? "\u7b80\u4f53\u4e2d\u6587" : "\u7e41\u9ad4\u4e2d\u6587"));
            param.put("rootDirectory", (Object)3);
            AssistantScene assistantScene = new AssistantScene();
            assistantScene.getKnowledgeBase().getInteger("historyNum");
            JSONObject knowledgeBase = new JSONObject();
            knowledgeBase.fluentPut("historyNum", (Object)3);
            assistantScene.setKnowledgeBase(knowledgeBase);
            this.addHistoryParam(knowledgeAssistantRequestDto, param, assistantScene);
            String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
            String requestUrl = this.envProperties.getQaUri() + "/restful/standard/kcf/isv/api/v2/qa/chatfile";
            log.info("knowledge assistant url:{}\uff0c\u8bf7\u6c42\u77e5\u8bc6\u52a9\u7406\u7684\u53c2\u6570:{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)param));
            KnowledgeEventSourceListener sseListener = new KnowledgeEventSourceListener();
            EventStreamClient.executeSSE((String)requestUrl, (String)this.digiKaiChatApiKey, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)language, (Map)this.getExecuteFunctions(null));
        }
    }

    public SseEmitter processQuestion(KnowledgeAssistantRequestDto requestParam) {
        String uniId = UUID.randomUUID().toString().replace("-", "");
        SseEmitter sseEmitter = null;
        try {
            sseEmitter = this.knowledgeSseEmitterComponent.generateSseEmitter(uniId, requestParam);
            this.dispatchKnowledgeRequest(requestParam, uniId);
        }
        catch (Exception e) {
            log.error("dispatchKnowledgeRequest is error requestParam:{}", (Object)JSON.toJSONString((Object)requestParam), (Object)e);
            this.knowledgeSseEmitterComponent.requestFail(uniId, LanguageUtils.processSseLanguage(), (Throwable)e);
        }
        return sseEmitter;
    }

    private void addHistoryParam(KnowledgeAssistantRequestDto knowledgeAssistantRequestDto, JSONObject param, AssistantScene assistantScene) {
        Integer historyNum = assistantScene.getKnowledgeBase().getInteger("historyNum");
        boolean historyFlag = false;
        ArrayList<HistoryItem> historyList = new ArrayList<HistoryItem>();
        try {
            if (historyNum != null && historyNum > 0) {
                List imMessageLogList = this.messageMongoMapper.getLatestMessages(knowledgeAssistantRequestDto.getFrom(), historyNum, knowledgeAssistantRequestDto.getTo(), null);
                List historyIdList = ImMessageUtils.questionAnswersHistory((List)imMessageLogList);
                List asaKnowledgeMessageList = null;
                if (CollectionUtils.isNotEmpty((Collection)historyIdList)) {
                    asaKnowledgeMessageList = this.asaKnowledgeMessageDao.findByIdIn(historyIdList);
                }
                if (CollectionUtils.isNotEmpty(asaKnowledgeMessageList)) {
                    historyFlag = true;
                    for (AsaKnowledgeMessage asaKnowledgeMessage : asaKnowledgeMessageList) {
                        HistoryItem historyItem = new HistoryItem();
                        historyItem.setQuestion(asaKnowledgeMessage.getQuestion());
                        historyItem.setAnswer(asaKnowledgeMessage.getMsg());
                        historyList.add(historyItem);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("addHistoryParam is error historyNum:{}", (Object)historyNum, (Object)ex);
        }
        param.put("historyFlag", (Object)historyFlag);
        param.put("historyList", historyList);
    }

    private Map<String, Function> getExecuteFunctions(String routerKey) {
        HashMap<String, Function> functionMap = new HashMap<String, Function>();
        Function<String, String> getTenantIdFunction = userToken -> StrUtil.isNotBlank((CharSequence)routerKey) ? routerKey : this.iamHelper.getTenantIdFromToken(userToken);
        functionMap.put("routerKey", getTenantIdFunction);
        return functionMap;
    }
}

