/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.entity.im.ImSendMsgResult;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.knowledge.context.SseContext;
import com.digiwin.athena.ania.knowledge.server.KnowledgeAssistantEvent;
import com.digiwin.athena.ania.knowledge.server.dto.KnowledgeAssistantRequestDto;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.util.DateUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class KnowledgeAssistantListener {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeAssistantListener.class);
    private static Map<String, String> msgCache = new ConcurrentHashMap();
    private static Map<String, KnowledgeAssistantRequestDto> questionCache = new ConcurrentHashMap();
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;

    public void addSseEmitters(String id, SseEmitter sseEmitter, KnowledgeAssistantRequestDto knowledgeAssistantRequestDtoOld) {
        questionCache.put(id, knowledgeAssistantRequestDtoOld);
        SseContext.setSseEmitter((String)id, (SseEmitter)sseEmitter);
        sseEmitter.onTimeout(() -> {
            log.error("SseEmitter time out");
            KnowledgeAssistantRequestDto knowledgeAssistantRequestDto = (KnowledgeAssistantRequestDto)questionCache.get(id);
            knowledgeAssistantRequestDto.setIsError(Boolean.valueOf(true));
            questionCache.put(id, knowledgeAssistantRequestDto);
        });
        sseEmitter.onError(throwable -> {
            log.error("SseEmitter error interrupt", throwable);
            KnowledgeAssistantRequestDto knowledgeAssistantRequestDto = (KnowledgeAssistantRequestDto)questionCache.get(id);
            knowledgeAssistantRequestDto.setIsError(Boolean.valueOf(true));
            questionCache.put(id, knowledgeAssistantRequestDto);
        });
        sseEmitter.onCompletion(() -> {
            try {
                String msg = (String)msgCache.get(id);
                log.info("\u6d88\u606f\u5728\u7f13\u5b58\u7684id\uff1a{}", (Object)id);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    KnowledgeAssistantRequestDto knowledgeAssistantRequestDto = (KnowledgeAssistantRequestDto)questionCache.get(id);
                    log.info("\u95ee\u9898\u5728\u7f13\u5b58\u7684id:{}", (Object)id);
                    MDC.put((String)"serverAccid", (String)knowledgeAssistantRequestDto.getFrom());
                    log.info("\u5f00\u59cb\u5c06\u77e5\u8bc6\u52a9\u7406\u7684\u95ee\u9898\u63a8\u5f80\u4e91\u4fe1");
                    ResultBean msgId = this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), knowledgeAssistantRequestDto.getTo(), (Object)knowledgeAssistantRequestDto.getText(), knowledgeAssistantRequestDto.getAssistantCode(), (JSONObject)JSONObject.parseObject((String)knowledgeAssistantRequestDto.getExt(), JSONObject.class), null);
                    log.info("\u63a8\u9001\u95ee\u9898\u4e91\u4fe1\u8fd4\u56demsgId:{}", (Object)((ImSendMsgResult)msgId.getResponse()).getMsgId());
                    MDC.put((String)"serverAccid", (String)knowledgeAssistantRequestDto.getTo());
                    AsaKnowledgeMessage asaKnowledgeMessage = new AsaKnowledgeMessage();
                    asaKnowledgeMessage.setAssistantCode(knowledgeAssistantRequestDto.getAssistantCode());
                    asaKnowledgeMessage.setAssistantSceneCode(knowledgeAssistantRequestDto.getAssistantSceneCode());
                    asaKnowledgeMessage.setCreateTime(DateUtils.getNowTime(null));
                    asaKnowledgeMessage.setFrom(knowledgeAssistantRequestDto.getTo());
                    asaKnowledgeMessage.setMsg(msg);
                    asaKnowledgeMessage.setQuestion(knowledgeAssistantRequestDto.getText());
                    asaKnowledgeMessage.setTo(knowledgeAssistantRequestDto.getFrom());
                    asaKnowledgeMessage.setMsgId(knowledgeAssistantRequestDto.getMsgId());
                    asaKnowledgeMessage.setUserId(knowledgeAssistantRequestDto.getUserId());
                    asaKnowledgeMessage.setTenantId(knowledgeAssistantRequestDto.getTenantId());
                    asaKnowledgeMessage.setFinish(Boolean.valueOf(!BooleanUtils.isTrue((Boolean)knowledgeAssistantRequestDto.getIsError())));
                    asaKnowledgeMessage = (AsaKnowledgeMessage)this.asaKnowledgeMessageDao.save((Object)asaKnowledgeMessage);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.fluentPut("contentId", (Object)asaKnowledgeMessage.getId());
                    jsonObject.fluentPut("showType", (Object)1);
                    jsonObject.fluentPut("knowledgeAssistantCode", (Object)knowledgeAssistantRequestDto.getAssistantCode());
                    jsonObject.fluentPut("replyId", (Object)((ImSendMsgResult)msgId.getResponse()).getMsgId());
                    log.info("\u5f00\u59cb\u5c06\u77e5\u8bc6\u52a9\u7406\u7684\u7b54\u6848\u63a8\u5f80\u4e91\u4fe1");
                    this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), knowledgeAssistantRequestDto.getFrom(), (Object)jsonObject, knowledgeAssistantRequestDto.getAssistantCode(), (JSONObject)JSONObject.parseObject((String)knowledgeAssistantRequestDto.getExt(), JSONObject.class), null);
                    log.info("\u5f00\u59cb\u5c06\u77e5\u8bc6\u52a9\u7406\u7684\u7b54\u6848\u63a8\u5f80\u4e91\u4fe1\u6210\u529f");
                }
            }
            finally {
                msgCache.remove(id);
                questionCache.remove(id);
                SseContext.removeSseEmitter((String)id);
                EventSource eventSource = SseContext.getEventSource((String)id);
                if (eventSource != null) {
                    eventSource.cancel();
                }
            }
        });
    }

    @EventListener
    public void msgEventHandler(KnowledgeAssistantEvent knowledgeAssistantEvent) {
        String id = knowledgeAssistantEvent.getId();
        SseEmitter sseEmitter = SseContext.getSseEmitter((String)id);
        String msg = (String)msgCache.get(id);
        try {
            String replaceWord = Objects.nonNull(JSONObject.parseObject((String)JSONObject.toJSONString((Object)knowledgeAssistantEvent.getMsg()), JSONObject.class)) && StringUtils.isNotBlank((CharSequence)((JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)knowledgeAssistantEvent.getMsg()), JSONObject.class)).getString("msg")) ? ((JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)knowledgeAssistantEvent.getMsg()), JSONObject.class)).getString("msg").replace("`", "") : ((JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)knowledgeAssistantEvent.getMsg()), JSONObject.class)).getString("msg");
            JSONObject replaceJson = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)knowledgeAssistantEvent.getMsg()), JSONObject.class);
            replaceJson.fluentPut("msg", (Object)replaceWord);
            knowledgeAssistantEvent.setMsg((Object)replaceJson);
            sseEmitter.send(SseEmitter.event().data(knowledgeAssistantEvent.getMsg()));
            if (Objects.nonNull(msg)) {
                StringBuffer sb = new StringBuffer(msg);
                sb.append(replaceWord);
                msgCache.put(id, sb.toString());
            } else {
                msgCache.put(id, replaceWord);
            }
            if (knowledgeAssistantEvent.isComplete()) {
                sseEmitter.complete();
            }
        }
        catch (IOException e) {
            sseEmitter.complete();
            log.error("Send emit message error.", (Throwable)e);
        }
    }
}

