/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import com.digiwin.athena.ania.agent.context.AgentContext;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.EventAnswerDataLog;
import com.digiwin.athena.ania.mongo.repository.EventAnswerDataLogMgDao;
import com.digiwin.athena.ania.sse.SseEmitterContext;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.EventMessageUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class SseEventDataServiceImpl
implements SseEventDataService {
    private static final Logger log = LoggerFactory.getLogger(SseEventDataServiceImpl.class);
    @Resource
    private ThreadPoolTaskExecutor streamMessage;
    @Resource
    private EventAnswerDataLogMgDao eventAnswerDataLogMgDao;

    public void saveEventDataLog(SseEventParams sseEventParam, EventData eventData) {
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        if (Objects.nonNull(questionMessage)) {
            EventMessageUtils.buildMessage((SseEventParams)sseEventParam, (EventData)eventData);
        }
        this.streamMessage.execute(() -> {
            try {
                MdcUtil.setTraceId((String)sseEventParam.getTraceId());
                EventAnswerDataLog eventAnswerDataLog = EventAnswerDataLog.builder().eventId(eventData.getEventId()).event(eventData.getEvent()).sessionId(sseEventParam.getId()).requestId(sseEventParam.getQuestionMessage().getLocalMessageId()).traceId(sseEventParam.getTraceId()).eventTime(eventData.getEventTime()).createTime(eventData.getEventTime()).build();
                if (Objects.nonNull(eventData.getData())) {
                    eventAnswerDataLog.setType(eventData.getData().getType());
                    Map map = PropertyUtils.describe((Object)eventData.getData());
                    map.remove("class");
                    eventAnswerDataLog.setData(map);
                }
                this.eventAnswerDataLogMgDao.save((Object)eventAnswerDataLog);
            }
            catch (Exception ex) {
                log.error("SseEventDataService saveEventDataLog is error eventData:{}", (Object)BaseUseUtils.toJsonString((Object)eventData), (Object)ex);
            }
            finally {
                MdcUtil.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAnswerDone(SseEventParams sseEventParams, boolean success) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.saveEventDataLog(sseEventParams, completed);
        EventData doneData = new EventData(success ? SseEventlEnum.CHAT_DONE.getEvent() : SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.saveEventDataLog(sseEventParams, doneData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParams.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParams.getId(), (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
                SseEventContext.setAnswer((String)sseEventParams.getId(), (EventData)doneData);
            }
            catch (IOException e) {
                log.error("SceneEventSourceListener.sendAnswerDone is error", (Throwable)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    public boolean sendEventData(SseEventParams sseEventParam, EventData data) {
        try {
            this.saveEventDataLog(sseEventParam, data);
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)data);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)data);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            log.error("SseEventDataService.sendEventData is error EventData:{}", (Object)BaseUseUtils.toJsonString((Object)data), (Object)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAgentAnswerDone(SseEventParams sseEventParams, boolean success) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.saveEventDataLog(sseEventParams, completed);
        EventData doneData = new EventData(success ? SseEventlEnum.CHAT_DONE.getEvent() : SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.saveEventDataLog(sseEventParams, doneData);
        SseEmitter sseEmitter = SseEmitterContext.getSseEmitter((String)sseEventParams.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParams.getId(), (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
                SseEventContext.setAnswer((String)sseEventParams.getId(), (EventData)doneData);
            }
            catch (IOException e) {
                log.error("SceneEventSourceListener.sendAgentAnswerDone is error", (Throwable)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    public boolean sendAgentEventData(SseEventParams sseEventParam, EventData data) {
        try {
            this.saveEventDataLog(sseEventParam, data);
            SseEmitter sseEmitter = AgentContext.getSseEmitter((String)sseEventParam.getId());
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)data);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)data);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            log.error("SseEventDataService.sendAgentEventData is error EventData:{}", (Object)BaseUseUtils.toJsonString((Object)data), (Object)ex);
            return false;
        }
    }
}

