/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server.assistant;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.common.enums.RhModelEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.common.enums.SseFlowToolTypeEnum;
import com.digiwin.athena.ania.dto.AniaEventLogBuilder;
import com.digiwin.athena.ania.dto.CustomMapMsg;
import com.digiwin.athena.ania.dto.CustomMsg;
import com.digiwin.athena.ania.dto.chatgpt.ChatGptRequest;
import com.digiwin.athena.ania.eventbus.agile.event.MultipleIntentionsEvent;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.ChatGptHelper;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.helper.MessageHelper;
import com.digiwin.athena.ania.helper.RhHelper;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.AssistantStrategy;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AiProject;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneMgDao;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.LmcClientUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class DialogAssistantComponent
extends AssistantStrategy {
    private static final Logger log = LoggerFactory.getLogger(DialogAssistantComponent.class);
    public static final String QUESTION_MULTIPLE_INTENT_KEY = "ANIA_QUESTION_MULTIPLE_";
    @Value(value="${multiDialogueFlag:false}")
    private Boolean multiDialogueFlag;
    @Resource
    private AssistantSceneMgDao assistantSceneMgDao;
    @Resource
    private RhHelper rhHelper;
    @Resource
    private KmHelper kmHelper;
    @Autowired
    private ChatGptHelper chatGptHelper;
    @Resource
    protected RedisTemplate<String, String> redisTemplate;
    @Resource
    private IamHelper iamHelper;
    @Resource
    private MessageHelper messageHelper;
    @Resource
    private CacHelper cacHelper;
    @Autowired
    private MessageUtils messageUtils;

    public void beforeSceneExtend(SseEventParams sseEventParam) {
        this.interpretCommand(sseEventParam);
    }

    public void interpretCommand(SseEventParams sseEventParam) {
        try {
            ((SseFlow)this.flowMap.get(SseFlowToolTypeEnum.INTENT_UNDERSTANDING.getFlowEventType())).flowStart(sseEventParam);
            if (Objects.isNull(sseEventParam.getActionScene())) {
                if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                    return;
                }
                this.replySceneHandle(sseEventParam);
                if (Objects.isNull(sseEventParam.getActionScene())) {
                    this.multiDialogue(sseEventParam);
                    if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                        return;
                    }
                    this.intentRecognition(sseEventParam);
                }
            }
        }
        finally {
            ((SseFlow)this.flowMap.get(SseFlowToolTypeEnum.INTENT_UNDERSTANDING.getFlowEventType())).flowEnd(sseEventParam);
        }
    }

    public void multipleIntentions(MultipleIntentionsEvent event) {
        String[] sceneCodeList;
        Map source = (Map)event.getSource();
        String knowledgeId = event.getKnowledgeId();
        Optional knowledgeMessage = this.asaKnowledgeMessageDao.findById((Object)knowledgeId);
        if (!knowledgeMessage.isPresent()) {
            return;
        }
        AsaKnowledgeMessage asaKnowledgeMessage = (AsaKnowledgeMessage)knowledgeMessage.get();
        String tenantVersion = this.kmHelper.getTenantVersion(asaKnowledgeMessage.getTenantId());
        String selectScenes = event.getSelectScenes();
        ArrayList<AssistantScene> sceneList = new ArrayList<AssistantScene>();
        for (String string : sceneCodeList = selectScenes.split("_")) {
            AssistantScene assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(asaKnowledgeMessage.getAssistantCode(), string, tenantVersion);
            if (!Objects.nonNull(assistantScene)) continue;
            sceneList.add(assistantScene);
        }
        if (CollectionUtils.isNotEmpty(sceneList)) {
            HashMap<String, ArrayList<AssistantScene>> dataSceneMap = new HashMap<String, ArrayList<AssistantScene>>(sceneCodeList.length);
            ArrayList<JSONObject> selectSceneData = new ArrayList<JSONObject>();
            String athenaUserLanguage = this.iamHelper.getAthenaUserLanguage(this.iamHelper.getTenantToken(asaKnowledgeMessage.getTenantId()), asaKnowledgeMessage.getUserId());
            for (AssistantScene scene : sceneList) {
                if (Objects.equals(1, scene.getType())) {
                    JSONObject dataMetric = scene.getDataMetric();
                    String application = dataMetric.getString("application");
                    ArrayList<AssistantScene> assistantScenes = (ArrayList<AssistantScene>)dataSceneMap.get(application);
                    if (Objects.isNull(assistantScenes)) {
                        assistantScenes = new ArrayList<AssistantScene>();
                    }
                    assistantScenes.add(scene);
                    dataSceneMap.put(application, assistantScenes);
                    continue;
                }
                Map lang = scene.getLang();
                String name = MapUtils.getString((Map)((Map)lang.get("name")), (Object)athenaUserLanguage, (String)scene.getName());
                JSONObject data = new JSONObject().fluentPut("key", (Object)scene.getCode()).fluentPut("name", (Object)name).fluentPut("type", (Object)scene.getType());
                selectSceneData.add(data);
            }
            if (MapUtils.isNotEmpty(dataSceneMap)) {
                for (Map.Entry entry : dataSceneMap.entrySet()) {
                    ArrayList<String> keys = new ArrayList<String>();
                    List value = (List)entry.getValue();
                    ArrayList<JSONObject> child = new ArrayList<JSONObject>();
                    StringBuilder nameString = new StringBuilder();
                    for (AssistantScene scene : value) {
                        keys.add(scene.getCode());
                        Map lang = scene.getLang();
                        String name = MapUtils.getString((Map)((Map)lang.get("name")), (Object)athenaUserLanguage, (String)scene.getName());
                        child.add(new JSONObject().fluentPut("key", (Object)scene.getCode()).fluentPut("name", (Object)name));
                        if (nameString.length() > 0) {
                            nameString.append("_");
                        }
                        nameString.append(name);
                    }
                    String application = (String)entry.getKey();
                    JSONObject data = new JSONObject().fluentPut("key", (Object)application).fluentPut("name", (Object)nameString.toString()).fluentPut("type", (Object)1).fluentPut("child", child);
                    selectSceneData.add(data);
                }
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("executeContext", (Object)new JSONObject().fluentPut("contentId", (Object)knowledgeId).fluentPut("rtMsgServerId", (Object)MapUtils.getString((Map)source, (Object)"replyId")).fluentPut("combinationMsg", (Object)asaKnowledgeMessage.getCombinationMsg()).fluentPut("text", (Object)asaKnowledgeMessage.getQuestion()));
            jSONObject.put("value", (Object)new JSONObject().fluentPut("data", selectSceneData));
            jSONObject.put("messageType", (Object)MessageTypeEnum.MULTIPLE_INTENTIONS.getType());
            jSONObject.put("messageBusinessCode", (Object)"ania_multiple_intentions");
            jSONObject.put("title", (Object)this.messageUtils.getMessageByLangName("600.0272", athenaUserLanguage));
            CustomMapMsg customMsg = new CustomMapMsg((Map)jSONObject, asaKnowledgeMessage.getAssistantCode());
            customMsg.setExt((Map)asaKnowledgeMessage.getExt());
            customMsg.putExt("msgId", (Object)event.getExt().getString("msgId"));
            customMsg.putExt("routerKey", (Object)asaKnowledgeMessage.getTenantId());
            customMsg.setAccount(asaKnowledgeMessage.getFrom(), asaKnowledgeMessage.getTo());
            this.messageHelper.pushCustomMessage((CustomMsg)customMsg);
        }
    }

    private boolean sendEventData(SseEventParams sseEventParam, EventData data) {
        try {
            this.sseEventDataService.saveEventDataLog(sseEventParam, data);
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)data);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)data);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intentRecognition(SseEventParams sseEventParam) {
        log.info("AssistantDialogComponent.intentRecognition.PtxId:{}", (Object)MdcUtil.get((String)"PtxId"));
        ArrayList<String> matchIntents = new ArrayList<String>();
        try {
            EventData eventData = new EventData(SseEventlEnum.CHAT_IN_PROGRESS.getEvent(), null);
            this.sendEventData(sseEventParam, eventData);
            Assistant assistant = sseEventParam.getAssistant();
            AiProject aiProject = assistant.getAiProject();
            String modelTag = StringUtils.isBlank((CharSequence)aiProject.getModelTag()) ? "test" : aiProject.getModelTag();
            boolean esEnable = aiProject.getModelTypes() == null ? false : aiProject.getModelTypes().contains(3);
            String combinationMsg = sseEventParam.getCombinationMsg();
            String text = sseEventParam.getQuestion().getMessage().getText();
            text = StrUtil.isNotBlank((CharSequence)combinationMsg) ? combinationMsg : text;
            JSONObject requestData = new JSONObject().fluentPut("project_name", (Object)aiProject.getProjectCode()).fluentPut("assistant_id", (Object)assistant.getAssistantCode()).fluentPut("tenant_id", (Object)sseEventParam.getUser().getTenantId()).fluentPut("text", (Object)text).fluentPut("threshold", (Object)"0.8").fluentPut("deploy_mode", (Object)modelTag).fluentPut("es_mode", (Object)esEnable).fluentPut("llm_foundation_model", (Object)"ChatGPT");
            JSONObject intentResult = this.rhHelper.syncRequest(sseEventParam.getUser().getToken(), (Map)requestData, RhModelEnum.INFERENCE_V1);
            Integer code = intentResult.getInteger("code");
            if (Objects.equals(0, code)) {
                JSONObject data = intentResult.getJSONObject("data");
                JSONObject candidateIntent = data.getJSONObject("candidate_intent");
                JSONObject scores = candidateIntent.getJSONObject("scores");
                Set scoreIntents = scores.keySet();
                for (String scoreIntent : scoreIntents) {
                    if ("None".equals(scoreIntent) || Float.compare(scores.getFloatValue(scoreIntent), 0.8f) < 0) continue;
                    matchIntents.add(scoreIntent);
                }
                if (CollectionUtils.isEmpty(matchIntents)) {
                    matchIntents.add(candidateIntent.getString("top_intent"));
                }
            } else if (Objects.equals(1, code)) {
                sseEventParam.setAiMsg(intentResult.getJSONObject("candidate_intent").getString("msg"));
            }
            sseEventParam.setIntentResult(intentResult);
            SseEventlEnum.SseEventDataTypeEnum intentRecognition = SseEventlEnum.SseEventDataTypeEnum.INTENT_RECOGNITION;
            String msg = CollectionUtils.isNotEmpty(matchIntents) ? intentRecognition.getDefaultValue() + "(" + Joiner.on((String)"_").join(matchIntents) + ")" : intentRecognition.getDefaultValue();
            EventData intentEventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), intentRecognition.getType(), null, msg);
            this.sendEventData(sseEventParam, intentEventData);
            this.buildScene(sseEventParam, matchIntents);
        }
        catch (Exception e) {
            log.error("intentRecognition is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
        }
        finally {
            this.buildDefaultScene(sseEventParam);
            this.saveIntentEventLog(sseEventParam, matchIntents);
        }
    }

    private void buildScene(SseEventParams sseEventParam, List<String> matchIntents) {
        if (CollectionUtils.isNotEmpty(matchIntents)) {
            AssistantScene scene;
            int index = matchIntents.size();
            if (index > 10) {
                index = 10;
            }
            List assistantSceneList = this.assistantSceneDao.findAllByAssistantCodeAndVersion(sseEventParam.getAssistant().getAssistantCode(), sseEventParam.getAssistant().getVersion());
            Map assistantSceneMap = assistantSceneList.stream().collect(Collectors.toMap(AssistantScene::getName, Function.identity(), (key1, key2) -> key2));
            HashMap<String, AssistantScene> assistantSceneLangMap = new HashMap<String, AssistantScene>();
            for (AssistantScene assistantScene : assistantSceneList) {
                Map sceneNameLang;
                Map lang = assistantScene.getLang();
                if (!MapUtils.isNotEmpty((Map)lang) || !MapUtils.isNotEmpty((Map)(sceneNameLang = (Map)lang.get("name")))) continue;
                for (Object sceneName : sceneNameLang.values()) {
                    assistantSceneLangMap.put(sceneName.toString(), assistantScene);
                }
            }
            ArrayList<AssistantScene> identifyAllScenes = new ArrayList<AssistantScene>();
            List<Object> identifyScenes = new ArrayList<AssistantScene>();
            ArrayList<String> nameNotMatchIntents = new ArrayList<String>();
            for (int i = 0; i < index; ++i) {
                String sceneName = matchIntents.get(i);
                scene = (AssistantScene)assistantSceneMap.get(sceneName);
                if (Objects.nonNull(scene)) {
                    identifyScenes.add(scene);
                    identifyAllScenes.add(scene);
                    continue;
                }
                nameNotMatchIntents.add(sceneName);
            }
            for (String notMatchIntent : nameNotMatchIntents) {
                scene = (AssistantScene)assistantSceneLangMap.get(notMatchIntent);
                if (!Objects.nonNull(scene)) continue;
                identifyScenes.add(scene);
                identifyAllScenes.add(scene);
            }
            if (CollectionUtils.isNotEmpty(identifyScenes)) {
                List appCodes = this.cacHelper.getCurrentAppCodes(sseEventParam.getUser().getToken());
                identifyScenes = CollectionUtils.isNotEmpty((Collection)appCodes) ? identifyScenes.stream().filter(item -> {
                    if (Objects.equals(2, item.getType())) {
                        String type = MapUtils.getString((Map)item.getKnowledgeBase(), (Object)"type");
                        return "private".equals(type) ? appCodes.contains("KCF") : appCodes.contains(item.getCode());
                    }
                    if (Objects.equals(1, item.getType())) {
                        return appCodes.contains(item.getDataMetric().getString("application"));
                    }
                    if (Objects.equals(3, item.getType())) {
                        return appCodes.contains(item.getAssistantCode());
                    }
                    return true;
                }).collect(Collectors.toList()) : new ArrayList();
            }
            sseEventParam.setIdentifyScenes(identifyScenes);
            sseEventParam.setIdentifyAllScenes(identifyAllScenes);
            if (CollectionUtils.isNotEmpty(identifyScenes)) {
                if (identifyScenes.size() == 1) {
                    SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                    actionScene.setType(((AssistantScene)identifyScenes.get(0)).getType());
                    actionScene.setActionScenes(identifyScenes);
                    sseEventParam.setActionScene(actionScene);
                    return;
                }
                HashMap<String, ArrayList<AssistantScene>> dataSceneMap = new HashMap<String, ArrayList<AssistantScene>>(identifyScenes.size());
                ArrayList<SseEventParams.ActionScene> actionScenes = new ArrayList<SseEventParams.ActionScene>();
                for (AssistantScene assistantScene : identifyScenes) {
                    if (Objects.equals(1, assistantScene.getType())) {
                        JSONObject dataMetric = assistantScene.getDataMetric();
                        String application = dataMetric.getString("application");
                        ArrayList<AssistantScene> assistantScenes = (ArrayList<AssistantScene>)dataSceneMap.get(application);
                        if (Objects.isNull(assistantScenes)) {
                            assistantScenes = new ArrayList<AssistantScene>();
                        }
                        assistantScenes.add(assistantScene);
                        dataSceneMap.put(application, assistantScenes);
                        continue;
                    }
                    SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                    actionScene.setType(((AssistantScene)identifyScenes.get(0)).getType());
                    actionScene.setActionScenes((List)Lists.newArrayList((Object[])new AssistantScene[]{assistantScene}));
                    actionScenes.add(actionScene);
                }
                if (MapUtils.isNotEmpty(dataSceneMap)) {
                    for (Map.Entry entry : dataSceneMap.entrySet()) {
                        List value = (List)entry.getValue();
                        SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                        actionScene.setType(((AssistantScene)identifyScenes.get(0)).getType());
                        actionScene.setActionScenes(value);
                        actionScenes.add(actionScene);
                    }
                }
                if (actionScenes.size() == 1) {
                    sseEventParam.setActionScene((SseEventParams.ActionScene)actionScenes.get(0));
                }
            }
            log.info("buildScene end sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
        }
    }

    private void saveIntentEventLog(SseEventParams sseEventParam, List<String> matchIntents) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("assistantCode", sseEventParam.getQuestion().getAssistantCode());
        content.put("question", (String)sseEventParam.getQuestion());
        SaveEventLog eventLog = AniaEventLogBuilder.anAniaEventLog().withEventId(sseEventParam.getId()).withEventName("intentRecognition").withEventSource(sseEventParam.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(null).withStatus(Integer.valueOf(0)).withTenantId(sseEventParam.getUser().getTenantId()).withTenantName(sseEventParam.getUser().getTenantName()).withUserId(sseEventParam.getUser().getUserId()).withUserName(sseEventParam.getUser().getUserName()).withRequestParam(sseEventParam.getQuestion().getMessage().getText()).withContent(content).build();
        if (CollectionUtils.isEmpty(matchIntents)) {
            eventLog.setErrorMsg("none intent");
            eventLog.setStatus(Integer.valueOf(1));
        } else {
            eventLog.setJsonResult(Joiner.on((String)",").join(matchIntents));
        }
        LmcClientUtils.saveEventLog((SaveEventLog)eventLog, (String)sseEventParam.getUser().getToken());
    }

    private void buildDefaultScene(SseEventParams sseEventParam) {
        try {
            SseEventParams.ActionScene actionScene = sseEventParam.getActionScene();
            if (Objects.nonNull(actionScene)) {
                return;
            }
            actionScene = new SseEventParams.ActionScene();
            List identifyScenes = sseEventParam.getIdentifyScenes();
            if (CollectionUtils.isEmpty((Collection)identifyScenes)) {
                Assistant assistant = sseEventParam.getAssistant();
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistant.getAssistantCode()).and("version").is((Object)assistant.getVersion()).and("knowledgeBase.defaultKBS").is((Object)true));
                AssistantScene defaultAssistantScene = (AssistantScene)this.assistantSceneMgDao.findOne(query);
                if (Objects.nonNull(defaultAssistantScene)) {
                    List appCodes = this.cacHelper.getCurrentAppCodes(sseEventParam.getUser().getToken());
                    actionScene.setType(defaultAssistantScene.getType());
                    actionScene.setActionScenes((List)ListUtil.toList((Object[])new AssistantScene[]{defaultAssistantScene}));
                    if (Objects.equals(3, defaultAssistantScene.getType())) {
                        if (CollectionUtils.isNotEmpty((Collection)appCodes) && appCodes.contains(assistant.getAssistantCode())) {
                            sseEventParam.setActionScene(actionScene);
                        }
                    } else if (Objects.equals(2, defaultAssistantScene.getType())) {
                        String type = defaultAssistantScene.getKnowledgeBase().getString("type");
                        if (type.equals("public")) {
                            if (CollectionUtils.isNotEmpty((Collection)appCodes) && appCodes.contains(defaultAssistantScene.getCode())) {
                                sseEventParam.setActionScene(actionScene);
                            }
                        } else if (type.equals("private") && CollectionUtils.isNotEmpty((Collection)appCodes) && appCodes.contains("KCF")) {
                            sseEventParam.setActionScene(actionScene);
                        }
                    } else if (Objects.equals(1, defaultAssistantScene.getType()) && CollectionUtils.isNotEmpty((Collection)appCodes) && appCodes.contains(defaultAssistantScene.getDataMetric().getString("application"))) {
                        sseEventParam.setActionScene(actionScene);
                    }
                }
            } else {
                actionScene.setType(Integer.valueOf(99));
                sseEventParam.setActionScene(actionScene);
            }
            if (Objects.isNull(sseEventParam.getActionScene()) && SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                actionScene.setType(Integer.valueOf(88));
                sseEventParam.setActionScene(actionScene);
            }
            log.info("buildDefaultScene end sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
        }
        catch (Exception e) {
            log.error("buildDefaultScene is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
        }
    }

    private void multiDialogue(SseEventParams sseEventParams) {
        try {
            if (!this.multiDialogueFlag.booleanValue()) {
                return;
            }
            AuthoredUser user = sseEventParams.getUser();
            String token = user.getToken();
            ConversationMessage questionMessage = sseEventParams.getQuestionMessage();
            List conversationMessages = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
            ArrayList<ConversationMessage> questMessages = new ArrayList<ConversationMessage>();
            for (int i = 0; i < conversationMessages.size() && conversationMessages.size() < 3; ++i) {
                ConversationMessage imMessageLog = (ConversationMessage)conversationMessages.get(i);
                Map msgExt = imMessageLog.getExt();
                if (MessageTypeEnum.NEW_CONVERSATION.getType().equals(MapUtils.getInteger((Map)msgExt, (Object)"messageType"))) break;
                String showType = MapUtils.getString((Map)msgExt, (Object)"showType");
                if (!StrUtil.isNotBlank((CharSequence)showType) || !"2".equals(showType) || !"TEXT".equals(imMessageLog.getMsgType())) continue;
                questMessages.add(imMessageLog);
            }
            List text = questMessages.stream().map(quest -> quest.getMsgBody().getString("text")).collect(Collectors.toList());
            text.add(sseEventParams.getQuestion().getMessage().getText());
            log.info("\u4e0a\u4e0b\u6587\u7528\u6237\u63d0\u95ee\u6d88\u606f\u7f16\u53f7:{}\uff0c\u7528\u6237\u63d0\u95ee:{}", (Object)sseEventParams.getQuestion().getMessage().getMsgId(), (Object)JsonUtil.toJSONString(text));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("-\u7528\u6237\u6700\u8fd1\u51e0\u8f6e\u4ea4\u4e92\u4fe1\u606f:");
            if (CollUtil.isNotEmpty(questMessages)) {
                for (int i = questMessages.size() - 1; i >= 0; --i) {
                    List textMap;
                    ConversationMessage message = (ConversationMessage)questMessages.get(i);
                    stringBuilder.append("\n");
                    stringBuilder.append("n" + (i + 1));
                    stringBuilder.append(".");
                    stringBuilder.append(message.getMsgBody().getString("text"));
                    if (!CollectionUtils.isNotEmpty((Collection)message.getContent()) || !CollectionUtils.isNotEmpty(textMap = message.getContent().stream().filter(item -> "text".equalsIgnoreCase(MapUtils.getString((Map)item, (Object)"type"))).collect(Collectors.toList()))) continue;
                    String text1 = MapUtils.getString((Map)((Map)textMap.get(0)), (Object)"text");
                    stringBuilder.append(":");
                    stringBuilder.append(text1);
                }
            }
            stringBuilder.append("\n");
            stringBuilder.append("\u7528\u6237\u8bed\u53e5=");
            stringBuilder.append(sseEventParams.getQuestion().getMessage().getText());
            ChatGptRequest chatGptRequest = new ChatGptRequest();
            ChatGptPromptEnum promptEnum = ChatGptPromptEnum.MULTI_DIALOGUE;
            if (LocalsEnum.isTw((String)sseEventParams.getLanguage())) {
                promptEnum = ChatGptPromptEnum.MULTI_DIALOGUE_TW;
            }
            chatGptRequest.setPrompt(promptEnum);
            ArrayList<BasicNameValuePair> userParam = new ArrayList<BasicNameValuePair>();
            userParam.add(new BasicNameValuePair("#{userPrompt}", stringBuilder.toString()));
            chatGptRequest.setUserParam(userParam);
            ArrayList<BasicNameValuePair> systemParam = new ArrayList<BasicNameValuePair>();
            systemParam.add(new BasicNameValuePair("${currentDate}", DateUtil.now()));
            chatGptRequest.setSystemParam(systemParam);
            chatGptRequest.setUserParam(userParam);
            String result = this.chatGptHelper.commonRequestGpt(chatGptRequest, token);
            JSONObject gptResult = JSON.parseObject((String)result);
            String semanticRewriting = gptResult.getString("semantic_rewriting");
            sseEventParams.setCombinationMsg(semanticRewriting);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4e0b\u6587\u6c47\u603b\u5f02\u5e38sseEventParams:{}", (Object)JSONUtil.toJsonStr((Object)sseEventParams), (Object)e);
        }
    }

    public Integer getAssistantSubType() {
        return AssistantSubTypeEnum.COMPOSITE.getType();
    }
}

