/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server.assistant;

import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.server.AssistantStrategy;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KnowledgeAssistantDialogComponent
extends AssistantStrategy {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeAssistantDialogComponent.class);

    public Integer getAssistantSubType() {
        return AssistantSubTypeEnum.KNOWLEAGE.getType();
    }

    public void beforeSceneExtend(SseEventParams sseEventParam) {
        Assistant assistant = sseEventParam.getAssistant();
        SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
        actionScene.setType(Integer.valueOf(2));
        if (!"private".equals(assistant.getKnowledgeType())) {
            String assistantSceneCode = MapUtils.getString((Map)sseEventParam.getQuestion().getExtInfo(), (Object)"assistantSceneCode");
            AssistantScene assistantScene = null;
            if (StringUtils.isBlank((CharSequence)assistantSceneCode)) {
                List assistantScenes = this.assistantSceneDao.findAllByAssistantCodeAndVersion(assistant.getAssistantCode(), assistant.getVersion());
                if (CollectionUtils.isNotEmpty((Collection)assistantScenes)) {
                    assistantScene = (AssistantScene)assistantScenes.get(0);
                }
            } else {
                assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(assistant.getAssistantCode(), assistantSceneCode, assistant.getVersion());
            }
            if (Objects.isNull(assistantScene)) {
                String answer = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u7684\u77e5\u8bc6\u5e93\u4e0d\u5b58\u5728\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u7684\u77e5\u8b58\u5eab\u4e0d\u5b58\u5728\u3002";
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
                this.sseEventDataService.sendEventData(sseEventParam, eventData);
                this.sseEventDataService.sendAnswerDone(sseEventParam, false);
                return;
            }
            actionScene.setActionScenes((List)Lists.newArrayList((Object[])new AssistantScene[]{assistantScene}));
        }
        sseEventParam.setActionScene(actionScene);
    }
}

