/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.dto.ConversationReceiveDto;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.MessageDto;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="conversation_message")
public class ConversationMessage {
    @Id
    private String id;
    @Indexed(unique=true)
    @ApiModelProperty(value="\u6d88\u606fID")
    private String messageId;
    @ApiModelProperty(value="\u672c\u5730\u6d88\u606fID")
    private String localMessageId;
    @ApiModelProperty(value="\u667a\u80fd\u4f53ID")
    private String agentId;
    @ApiModelProperty(value="\u5bf9\u8bddID")
    private String conversationId;
    @ApiModelProperty(value="\u7ae0\u8282ID")
    private String sectionId;
    @ApiModelProperty(value="\u56de\u590dID")
    private String replyId;
    @ApiModelProperty(value="\u6d88\u606f\u89d2\u6807")
    private Integer index;
    @ApiModelProperty(value="\u6d88\u606f\u7c7b\u578b TEXT CUSTOM")
    private String msgType;
    @ApiModelProperty(value="\u6d88\u606f\u5185\u5bb9 {'text':''}")
    private JSONObject msgBody;
    @ApiModelProperty(value="\u6d88\u606f\u5934\u5185\u5bb9")
    private List<Map> headerInfos;
    @Transient
    @ApiModelProperty(value="\u6d88\u606f\u4f53\u5185\u5bb9")
    private List<Map> content;
    @ApiModelProperty(value="\u6d88\u606f\u63a8\u8350\u5185\u5bb9")
    private List<Map> followUp;
    @ApiModelProperty(value="\u6d88\u606f\u5934\u5185\u5bb9")
    private String metaInfo;
    @ApiModelProperty(value="\u6d88\u606f\u4f53\u5185\u5bb9")
    private String contents;
    @ApiModelProperty(value="\u6d88\u606f\u63a8\u8350\u5185\u5bb9")
    private String sp;
    @ApiModelProperty(value="\u6d88\u606f\u62d3\u5c55\u5185\u5bb9")
    private Map ext;
    @ApiModelProperty(value="\u6d88\u606f\u62d3\u5c55\u5185\u5bb9\uff08\u6587\u672c\uff09")
    private String msgExt;
    @ApiModelProperty(value="\u7528\u6237ID")
    private String userId;
    @ApiModelProperty(value="\u79df\u6237ID")
    private String tenantId;
    @ApiModelProperty(value="\u7528\u6237\u7c7b\u578b 1-\u7528\u6237 2-AI")
    private int userType;
    @ApiModelProperty(value="0-\u6ca1\u6709 1-\u70b9\u8d5e 2-\u70b9\u5f69")
    private Integer feedback;
    @ApiModelProperty(value="1-\u5386\u53f2IM\u6570\u636e")
    private Integer source;
    @ApiModelProperty(value="\u6d88\u606f\u72b6\u6001 1=\u6b63\u5e38\uff0c2=\u5220\u9664\uff0c3=\u7ec8\u6b62\u56de\u7b54")
    private Integer status = 1;
    @ApiModelProperty(value="\u6d88\u606f\u521b\u5efa\u65f6\u95f4")
    private Long createTime;
    @ApiModelProperty(value="\u6d88\u606f\u66f4\u65b0\u65f6\u95f4")
    private Long updateTime;

    public ConversationMessage(String messageId, String sectionId, HisAssistantChatDto question, AuthoredUser authoredUser) {
        this.conversationId = question.getConversationId();
        this.agentId = question.getAssistantCode();
        this.userType = 1;
        this.userId = authoredUser.getUserId();
        this.tenantId = authoredUser.getTenantId();
        this.messageId = messageId;
        this.sectionId = sectionId;
        this.localMessageId = question.getLocalMessageId();
        MessageDto message = question.getMessage();
        String text = message.getText();
        JSONObject ext = JSONObject.parseObject((String)message.getExt());
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.msgType = ImConstants.ImMsgTypeEnum.TEXT.getTypeChar();
            this.msgBody = new JSONObject().fluentPut("text", (Object)text);
            HashMap<String, String> textContent = new HashMap<String, String>(2);
            textContent.put("type", "text");
            textContent.put("text", text);
            this.content = ListUtil.toList((Object[])new Map[]{textContent});
        }
        if (ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().equalsIgnoreCase(message.getType())) {
            JSONObject newMessage = new JSONObject();
            newMessage.fluentPut("purePicture", (Object)true);
            ext.put("streamFile", (Object)message.getContent());
        }
        this.ext = ext;
        this.msgExt = message.getExt();
        this.updateTime = this.createTime = Long.valueOf(System.currentTimeMillis());
    }

    public static ConversationMessage conversationReceive(ConversationReceiveDto dto, Conversation conversation) {
        ConversationMessage conversationMessage = new ConversationMessage();
        conversationMessage.setConversationId(conversation.getConversationId());
        conversationMessage.setMessageId(IdSnowflake.snowflakeIdStr());
        conversationMessage.setReplyId(dto.getReplyId());
        conversationMessage.setStatus(Integer.valueOf(1));
        conversationMessage.setHeaderInfos(dto.getHeaderInfos());
        conversationMessage.setExt(dto.getMsgExt());
        conversationMessage.setMsgExt(JSONUtil.toJsonStr((Object)dto.getMsgExt()));
        conversationMessage.setAgentId(conversation.getAgentId());
        conversationMessage.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        conversationMessage.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        conversationMessage.setUserType(2);
        conversationMessage.setUserId(conversation.getUserId());
        conversationMessage.setTenantId(dto.getTenantId());
        conversationMessage.setContent(dto.getContent());
        return conversationMessage;
    }

    public void initData() {
        this.contents = Objects.nonNull(this.content) ? JSON.toJSONString((Object)this.content) : null;
        this.metaInfo = Objects.nonNull(this.headerInfos) ? JSON.toJSONString((Object)this.headerInfos) : null;
        this.sp = Objects.nonNull(this.followUp) ? JSON.toJSONString((Object)this.followUp) : null;
        this.msgExt = Objects.nonNull(this.ext) ? JSON.toJSONString((Object)this.ext) : null;
    }

    public ConversationMessage initContent() {
        if (StrUtil.isNotBlank((CharSequence)this.contents)) {
            this.content = JSONUtil.toList((String)this.contents, Map.class);
        }
        return this;
    }

    public static ConversationMessageBuilder builder() {
        return new ConversationMessageBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getLocalMessageId() {
        return this.localMessageId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getReplyId() {
        return this.replyId;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public JSONObject getMsgBody() {
        return this.msgBody;
    }

    public List<Map> getHeaderInfos() {
        return this.headerInfos;
    }

    public List<Map> getContent() {
        return this.content;
    }

    public List<Map> getFollowUp() {
        return this.followUp;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    public String getContents() {
        return this.contents;
    }

    public String getSp() {
        return this.sp;
    }

    public Map getExt() {
        return this.ext;
    }

    public String getMsgExt() {
        return this.msgExt;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public int getUserType() {
        return this.userType;
    }

    public Integer getFeedback() {
        return this.feedback;
    }

    public Integer getSource() {
        return this.source;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setLocalMessageId(String localMessageId) {
        this.localMessageId = localMessageId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setReplyId(String replyId) {
        this.replyId = replyId;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMsgBody(JSONObject msgBody) {
        this.msgBody = msgBody;
    }

    public void setHeaderInfos(List<Map> headerInfos) {
        this.headerInfos = headerInfos;
    }

    public void setContent(List<Map> content) {
        this.content = content;
    }

    public void setFollowUp(List<Map> followUp) {
        this.followUp = followUp;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public void setSp(String sp) {
        this.sp = sp;
    }

    public void setExt(Map ext) {
        this.ext = ext;
    }

    public void setMsgExt(String msgExt) {
        this.msgExt = msgExt;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public void setFeedback(Integer feedback) {
        this.feedback = feedback;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationMessage)) {
            return false;
        }
        ConversationMessage other = (ConversationMessage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$localMessageId = this.getLocalMessageId();
        String other$localMessageId = other.getLocalMessageId();
        if (this$localMessageId == null ? other$localMessageId != null : !this$localMessageId.equals(other$localMessageId)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$sectionId = this.getSectionId();
        String other$sectionId = other.getSectionId();
        if (this$sectionId == null ? other$sectionId != null : !this$sectionId.equals(other$sectionId)) {
            return false;
        }
        String this$replyId = this.getReplyId();
        String other$replyId = other.getReplyId();
        if (this$replyId == null ? other$replyId != null : !this$replyId.equals(other$replyId)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        JSONObject this$msgBody = this.getMsgBody();
        JSONObject other$msgBody = other.getMsgBody();
        if (this$msgBody == null ? other$msgBody != null : !this$msgBody.equals(other$msgBody)) {
            return false;
        }
        List this$headerInfos = this.getHeaderInfos();
        List other$headerInfos = other.getHeaderInfos();
        if (this$headerInfos == null ? other$headerInfos != null : !((Object)this$headerInfos).equals(other$headerInfos)) {
            return false;
        }
        List this$content = this.getContent();
        List other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        List this$followUp = this.getFollowUp();
        List other$followUp = other.getFollowUp();
        if (this$followUp == null ? other$followUp != null : !((Object)this$followUp).equals(other$followUp)) {
            return false;
        }
        String this$metaInfo = this.getMetaInfo();
        String other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !this$metaInfo.equals(other$metaInfo)) {
            return false;
        }
        String this$contents = this.getContents();
        String other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !this$contents.equals(other$contents)) {
            return false;
        }
        String this$sp = this.getSp();
        String other$sp = other.getSp();
        if (this$sp == null ? other$sp != null : !this$sp.equals(other$sp)) {
            return false;
        }
        Map this$ext = this.getExt();
        Map other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        String this$msgExt = this.getMsgExt();
        String other$msgExt = other.getMsgExt();
        if (this$msgExt == null ? other$msgExt != null : !this$msgExt.equals(other$msgExt)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        if (this.getUserType() != other.getUserType()) {
            return false;
        }
        Integer this$feedback = this.getFeedback();
        Integer other$feedback = other.getFeedback();
        if (this$feedback == null ? other$feedback != null : !((Object)this$feedback).equals(other$feedback)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $localMessageId = this.getLocalMessageId();
        result = result * 59 + ($localMessageId == null ? 43 : $localMessageId.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $sectionId = this.getSectionId();
        result = result * 59 + ($sectionId == null ? 43 : $sectionId.hashCode());
        String $replyId = this.getReplyId();
        result = result * 59 + ($replyId == null ? 43 : $replyId.hashCode());
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        JSONObject $msgBody = this.getMsgBody();
        result = result * 59 + ($msgBody == null ? 43 : $msgBody.hashCode());
        List $headerInfos = this.getHeaderInfos();
        result = result * 59 + ($headerInfos == null ? 43 : ((Object)$headerInfos).hashCode());
        List $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        List $followUp = this.getFollowUp();
        result = result * 59 + ($followUp == null ? 43 : ((Object)$followUp).hashCode());
        String $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : $metaInfo.hashCode());
        String $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
        String $sp = this.getSp();
        result = result * 59 + ($sp == null ? 43 : $sp.hashCode());
        Map $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        String $msgExt = this.getMsgExt();
        result = result * 59 + ($msgExt == null ? 43 : $msgExt.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        result = result * 59 + this.getUserType();
        Integer $feedback = this.getFeedback();
        result = result * 59 + ($feedback == null ? 43 : ((Object)$feedback).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "ConversationMessage(id=" + this.getId() + ", messageId=" + this.getMessageId() + ", localMessageId=" + this.getLocalMessageId() + ", agentId=" + this.getAgentId() + ", conversationId=" + this.getConversationId() + ", sectionId=" + this.getSectionId() + ", replyId=" + this.getReplyId() + ", index=" + this.getIndex() + ", msgType=" + this.getMsgType() + ", msgBody=" + this.getMsgBody() + ", headerInfos=" + this.getHeaderInfos() + ", content=" + this.getContent() + ", followUp=" + this.getFollowUp() + ", metaInfo=" + this.getMetaInfo() + ", contents=" + this.getContents() + ", sp=" + this.getSp() + ", ext=" + this.getExt() + ", msgExt=" + this.getMsgExt() + ", userId=" + this.getUserId() + ", tenantId=" + this.getTenantId() + ", userType=" + this.getUserType() + ", feedback=" + this.getFeedback() + ", source=" + this.getSource() + ", status=" + this.getStatus() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public ConversationMessage() {
    }

    public ConversationMessage(String id, String messageId, String localMessageId, String agentId, String conversationId, String sectionId, String replyId, Integer index, String msgType, JSONObject msgBody, List<Map> headerInfos, List<Map> content, List<Map> followUp, String metaInfo, String contents, String sp, Map ext, String msgExt, String userId, String tenantId, int userType, Integer feedback, Integer source, Integer status, Long createTime, Long updateTime) {
        this.id = id;
        this.messageId = messageId;
        this.localMessageId = localMessageId;
        this.agentId = agentId;
        this.conversationId = conversationId;
        this.sectionId = sectionId;
        this.replyId = replyId;
        this.index = index;
        this.msgType = msgType;
        this.msgBody = msgBody;
        this.headerInfos = headerInfos;
        this.content = content;
        this.followUp = followUp;
        this.metaInfo = metaInfo;
        this.contents = contents;
        this.sp = sp;
        this.ext = ext;
        this.msgExt = msgExt;
        this.userId = userId;
        this.tenantId = tenantId;
        this.userType = userType;
        this.feedback = feedback;
        this.source = source;
        this.status = status;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }
}

