/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import com.digiwin.athena.ania.eventbus.agile.event.AgileDataLogEvent;
import com.digiwin.athena.ania.mongo.domain.AgileDataResultLog;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import java.time.LocalDateTime;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class AgileDataResultLogMgDao
extends CommonAsaMgDao<AgileDataResultLog> {
    public AgileDataResultLogMgDao(MongoTemplate template) {
        super(template);
        this.entityClass = AgileDataResultLog.class;
    }

    public void update(Query query, AgileDataLogEvent agileDataLogEvent, AgileDataResultLog agileDataResultLog) {
        this.update(query, this.getUpdateInfo(agileDataLogEvent, agileDataResultLog));
    }

    public Update getUpdateInfo(AgileDataLogEvent agileDataLogEvent, AgileDataResultLog agileDataResultLog) {
        Update update = new Update();
        switch (agileDataLogEvent.getType()) {
            case 0: {
                update.set("data", (Object)agileDataLogEvent.getData());
                break;
            }
            case 1: {
                update.set("errorAnswer", (Object)agileDataLogEvent.getErrorAnswer());
                update.set("params", (Object)agileDataLogEvent.getParams());
                update.set("success", (Object)agileDataLogEvent.getSuccess());
                break;
            }
            case 2: {
                update.set("feedbackType", (Object)agileDataLogEvent.getFeedbackType());
                update.set("extendInfo", (Object)agileDataLogEvent.getExtendInfo());
                if (agileDataResultLog.getCreateBackTime() != null) break;
                update.set("createBackTime", (Object)LocalDateTime.now());
                break;
            }
            case 3: {
                update.set("answerOpinion", (Object)agileDataLogEvent.getAnswerOpinion());
                update.set("backContent", (Object)agileDataLogEvent.getBackContent());
                update.set("checkOpinions", (Object)agileDataLogEvent.getCheckOpinions());
                if (agileDataResultLog.getExtendInfo() == null) {
                    update.set("extendInfo", (Object)agileDataLogEvent.getExtendInfo());
                }
                if (agileDataResultLog.getCreateBackTime() != null) break;
                update.set("createBackTime", (Object)LocalDateTime.now());
                break;
            }
            case 4: {
                update.set("feedbackType", (Object)agileDataLogEvent.getFeedbackType());
                break;
            }
        }
        update.set("modifyTime", (Object)LocalDateTime.now());
        return update;
    }
}

