/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.dto.AssistantMongoDto;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class AssistantMgDao
extends CommonAsaMgDao<Assistant> {
    public AssistantMgDao(@Qualifier(value="asaMongoTemplate") MongoTemplate template) {
        super(template);
        this.entityClass = Assistant.class;
    }

    public List<Assistant> find(AssistantMongoDto dto) {
        Query query = new Query();
        if (StrUtil.isNotEmpty((CharSequence)dto.getVersion())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)dto.getVersion()));
        }
        if (CollUtil.isNotEmpty((Collection)dto.getClientTypes())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"clientType").in((Collection)dto.getClientTypes()));
        }
        if (CollUtil.isNotEmpty((Collection)dto.getAssistantTypes())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantType").in((Collection)dto.getAssistantTypes()));
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getTenantId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)dto.getTenantId()));
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getAssistantCode())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)dto.getAssistantCode()));
        }
        if (null != dto.getOrSourceCustom()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceCustom").is((Object)dto.getOrSourceCustom()));
        }
        if (null != dto.getStatus()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)dto.getStatus()));
        }
        return this.template.find(query, this.entityClass);
    }

    public List<Assistant> findDefault(AssistantMongoDto dto) {
        Query query = new Query();
        if (null != dto.getOrSourceCustom()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceCustom").is((Object)dto.getOrSourceCustom()));
        }
        if (CollUtil.isNotEmpty((Collection)dto.getAssistantTypes())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantType").in((Collection)dto.getAssistantTypes()));
        }
        return this.template.find(query, this.entityClass);
    }

    public Long count(String assistantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistantId));
        return this.template.count(query, this.entityClass);
    }
}

