/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.ania.dto.conversation.ChatMessageQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgQueryDto;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class ConversationMessageDao
extends CommonAsaMgDao<ConversationMessage> {
    public static final String CONVERSATION_ID_KEY = "conversationId";
    public static final String SORT_KEY = "index";

    public ConversationMessageDao(MongoTemplate template) {
        super(template);
        this.entityClass = ConversationMessage.class;
    }

    public ConversationMessage getLastMessageByConversationId(String conversationId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId));
        query.with(this.buildSort(true, SORT_KEY));
        query.limit(1);
        ConversationMessage message = (ConversationMessage)super.findOne(query);
        return Objects.nonNull(message) ? message.initContent() : null;
    }

    public long countMessageByConversationId(String conversationId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId));
        return super.count(query);
    }

    public void updateFeedback(String conversationId, String messageId, Integer feedback) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageId));
        Update update = new Update();
        update.set("feedback", (Object)feedback);
        super.update(query, update);
    }

    public ConversationMessage findByMessageId(String conversationId, String messageId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId).and("messageId").is((Object)messageId));
        ConversationMessage message = (ConversationMessage)super.findOne(query);
        return Objects.nonNull(message) ? message.initContent() : null;
    }

    public List<ConversationMessage> findLatelyConversationMessage(ConversationMsgQueryDto conversationMsgQuery, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)this.baseCriteria(authoredUser.getTenantId(), authoredUser.getUserId()).and(CONVERSATION_ID_KEY).is((Object)conversationMsgQuery.getConversationId()));
        if (Objects.nonNull(conversationMsgQuery.getStartIndex())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)SORT_KEY).gt((Object)conversationMsgQuery.getStartIndex()));
        }
        if (Objects.nonNull(conversationMsgQuery.getEndIndex())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)SORT_KEY).gt((Object)conversationMsgQuery.getEndIndex()));
        }
        query.with(this.buildSort("desc".equals(conversationMsgQuery.getOrder()), SORT_KEY));
        query.limit(conversationMsgQuery.getLimit() + 1);
        List conversationMessages = this.template.find(query, this.entityClass);
        CollUtil.emptyIfNull((List)conversationMessages).forEach(message -> message.initContent());
        return conversationMessages;
    }

    public List<ConversationMessage> queryMessage(String userId, String tenantId, String conversationId, String sectionId, Integer index, int limit) {
        Criteria criteria = this.baseCriteria(tenantId, userId).and(CONVERSATION_ID_KEY).is((Object)conversationId);
        if (Objects.nonNull(index)) {
            criteria.and(SORT_KEY).lt((Object)index);
        }
        if (StringUtils.isNotBlank((CharSequence)sectionId)) {
            criteria.and("sectionId").is((Object)sectionId);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(this.buildSort(true, SORT_KEY));
        query.limit(limit);
        List conversationMessages = this.findList(query);
        CollUtil.emptyIfNull((List)conversationMessages).forEach(message -> message.initContent());
        return conversationMessages;
    }

    public List<ConversationMessage> queryMessage(ChatMessageQueryDto dto, AuthoredUser authoredUser, Integer limit) {
        Query query = new Query((CriteriaDefinition)this.baseCriteria(authoredUser.getTenantId(), authoredUser.getUserId()).and(CONVERSATION_ID_KEY).is((Object)dto.getConversationId()));
        Sort.Direction direction = Sort.Direction.DESC;
        if ("asc".equalsIgnoreCase(dto.getOrder())) {
            direction = Sort.Direction.ASC;
        }
        if (dto.getCursor() != null) {
            Criteria indexCriteria;
            if (dto.getIncludeSelf().booleanValue()) {
                indexCriteria = direction == Sort.Direction.ASC ? Criteria.where((String)SORT_KEY).gte((Object)dto.getCursor()) : Criteria.where((String)SORT_KEY).lte((Object)dto.getCursor());
                query.addCriteria((CriteriaDefinition)indexCriteria);
            } else {
                indexCriteria = direction == Sort.Direction.ASC ? Criteria.where((String)SORT_KEY).gt((Object)dto.getCursor()) : Criteria.where((String)SORT_KEY).lt((Object)dto.getCursor());
                query.addCriteria((CriteriaDefinition)indexCriteria);
            }
        }
        query.with(Sort.by((Sort.Direction)direction, (String[])new String[]{SORT_KEY}));
        query.limit(limit.intValue());
        List conversationMessages = this.findList(query);
        CollUtil.emptyIfNull((List)conversationMessages).forEach(message -> message.initContent());
        return conversationMessages;
    }

    public List<ConversationMessage> queryMessage(List<String> messageIdList, String userId, String tenantId) {
        Query query = new Query((CriteriaDefinition)this.baseCriteria(Criteria.where((String)"messageId").in(messageIdList), tenantId, userId));
        List conversationMessages = this.findList(query);
        CollUtil.emptyIfNull((List)conversationMessages).forEach(message -> message.initContent());
        return conversationMessages;
    }

    public ConversationMessage getMessageByConversationIdAndIndex(String conversationId, int index) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId).and(SORT_KEY).is((Object)index));
        ConversationMessage message = (ConversationMessage)super.findOne(query);
        return Objects.nonNull(message) ? message.initContent() : null;
    }

    public List<Map> findByMsgId(String msgId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"ext.msgId").is((Object)msgId));
        return this.template.find(query, Map.class, this.template.getCollectionName(this.entityClass));
    }
}

