/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mq;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.SupplierTypeEnum;
import com.digiwin.athena.ania.dto.AtzMessageDto;
import com.digiwin.athena.ania.dto.CustomMsg;
import com.digiwin.athena.ania.dto.ImConversationMsgDto;
import com.digiwin.athena.ania.dto.TextMsg;
import com.digiwin.athena.ania.dto.agora.ReceiveMessageDTO;
import com.digiwin.athena.ania.entity.agora.ReceiveMessage;
import com.digiwin.athena.ania.entity.im.ImSendMsgResult;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.eventbus.agile.event.MultipleIntentionsEvent;
import com.digiwin.athena.ania.helper.MessageHelper;
import com.digiwin.athena.ania.interfaces.assembler.MessageAssembler;
import com.digiwin.athena.ania.knowledge.server.dto.SendMqYunxinMsg;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.service.ImService;
import com.digiwin.athena.ania.service.NewConversationService;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.util.LimitUtil;
import com.digiwin.athena.ania.util.RedisRateLimiter;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
public class MqReceiver {
    private static final Logger log = LoggerFactory.getLogger(MqReceiver.class);
    private static final String MESSAGE_CACHE_KEY = "ania_message_cache_key_";
    private static final String MESSAGE_ATZ_CACHE_KEY = "ania_atz_message_cache_key_";
    private static final String MESSAGE_CACHE_FAIL_KEY = "ania_message_cache_fail_key_";
    private static final String MESSAGE_ATZ_CACHE_FAIL_KEY = "ania_atz_message_cache_fail_key_";
    @Autowired
    private ImService imService;
    @Resource
    private RedisTemplate<String, Integer> redisTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RedisRateLimiter redisRateLimiter;
    @Resource
    private AssistantService assistantService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Value(value="${yunxin.knowledgeQueueName}")
    private String knowledgeQueueName;
    @Resource
    private MessageHelper messageHelper;
    @Value(value="${yunxin.sendLimit}")
    private Integer sendLimit;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    @Resource
    private NewConversationService newConversationService;

    @RabbitListener(queues={"${yunxin.atzMsgQueueName}"}, ackMode="MANUAL")
    public void receiveAtzMsg(String messageStr, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="token") String token, @Header(value="routerKey") String routerKey) throws IOException {
        log.info("MqReceiver.receiveAtzMsg tag:{} routerKey:{} msg:{}", new Object[]{tag, routerKey, messageStr});
        AtzMessageDto atzMessageDto = (AtzMessageDto)JSON.parseObject((String)messageStr, AtzMessageDto.class);
        log.info("\u6a21\u62df\u4eba\u6d88\u606f\u683c\u5f0f\u5316\uff1a{}", (Object)JSONObject.toJSONString((Object)atzMessageDto));
        boolean isAllowed = this.redisRateLimiter.isAllowed("ip", 100, 1);
        if (!isAllowed) {
            log.warn("\u6d41\u91cf\u8d85\u8fc7\u4e86\u6700\u5927\u6d41\u91cf\uff0c\u88ab\u9650\u6d41");
            if (this.repeatMessageForAtz(atzMessageDto, tag) || this.messageFailRetryMaxForAtz(atzMessageDto, tag)) {
                channel.basicNack(tag, false, false);
            } else {
                channel.basicNack(tag, false, true);
            }
            return;
        }
        try {
            if (!this.repeatMessageForAtz(atzMessageDto, tag)) {
                this.imService.handlerAtzMessage(atzMessageDto, token, routerKey);
            } else {
                log.error("\u6d88\u606f\u91cd\u590d,\u4e22\u5f03\u8be5\u6d88\u606f");
            }
            this.cacheMessageForAtz(atzMessageDto, tag);
            channel.basicAck(tag, false);
        }
        catch (Exception e) {
            log.error("MqReceiver.receiveAtzMsg is error tag:{} routerKey:{} msg:{}", new Object[]{tag, routerKey, messageStr, e});
            if (this.repeatMessageForAtz(atzMessageDto, tag) || this.messageFailRetryMaxForAtz(atzMessageDto, tag)) {
                channel.basicNack(tag, false, false);
            }
            channel.basicNack(tag, false, true);
        }
    }

    private void cacheMessageForAtz(AtzMessageDto mapParam, long tag) {
        try {
            this.redisTemplate.opsForValue().set((Object)(MESSAGE_ATZ_CACHE_KEY + this.cacheMessageKeyForAtz(mapParam, tag)), (Object)1, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("MqReceiver.cacheMessage is error tag:{}", (Object)tag, (Object)e);
        }
    }

    private ImConversationMsgDto covertReceiveMessageToImConversationMsgDto(ReceiveMessage receiveMessage) {
        ImConversationMsgDto imConversationMsgDto = new ImConversationMsgDto();
        imConversationMsgDto.setAttach(receiveMessage.getAttach());
        imConversationMsgDto.setBody(receiveMessage.getBody());
        imConversationMsgDto.setConvType(receiveMessage.getConvType());
        imConversationMsgDto.setCustomApnsText(receiveMessage.getCustomApnsText());
        imConversationMsgDto.setAntispam(receiveMessage.getAntispam());
        imConversationMsgDto.setCustomSafeFlag(receiveMessage.getCustomSafeFlag());
        imConversationMsgDto.setEventType(receiveMessage.getEventType());
        imConversationMsgDto.setExt(receiveMessage.getExt());
        imConversationMsgDto.setFromAccount(receiveMessage.getFromAccount());
        imConversationMsgDto.setFromClientType(receiveMessage.getFromClientType());
        imConversationMsgDto.setFromDeviceId(receiveMessage.getFromDeviceId());
        imConversationMsgDto.setFromNick(receiveMessage.getFromNick());
        imConversationMsgDto.setIp(receiveMessage.getIp());
        imConversationMsgDto.setBlacklist(receiveMessage.getBlacklist());
        imConversationMsgDto.setMsgidClient(receiveMessage.getMsgidClient());
        imConversationMsgDto.setMsgidServer(receiveMessage.getMsgidServer());
        imConversationMsgDto.setMsgTimestamp(receiveMessage.getMsgTimestamp());
        imConversationMsgDto.setMsgType(receiveMessage.getMsgType());
        imConversationMsgDto.setPort(receiveMessage.getPort());
        imConversationMsgDto.setResendFlag(receiveMessage.getResendFlag());
        imConversationMsgDto.setSupplierType(receiveMessage.getSupplierType());
        imConversationMsgDto.setYidunRes(receiveMessage.getYidunRes());
        imConversationMsgDto.setTo(receiveMessage.getTo());
        imConversationMsgDto.setTMembers(receiveMessage.getTMembers());
        imConversationMsgDto.setAttach(receiveMessage.getAttach());
        return imConversationMsgDto;
    }

    private void cacheMessage(ImConversationMsgDto message, long tag) {
        try {
            this.redisTemplate.opsForValue().set((Object)(MESSAGE_CACHE_KEY + this.cacheMessageKey(message, tag)), (Object)1, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("MqReceiver.cacheMessage is error tag:{}", (Object)tag, (Object)e);
        }
    }

    private void cacheFailMessage(ImConversationMsgDto message, long tag) {
        try {
            String key = MESSAGE_CACHE_FAIL_KEY + this.cacheMessageKey(message, tag);
            this.redisTemplate.opsForValue().set((Object)key, (Object)(this.messageConsumeCount(key) + 1), 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("MqReceiver.cacheFailMessage is error tag:{}", (Object)tag, (Object)e);
        }
    }

    private void cacheFailMessageForAtz(AtzMessageDto message, long tag) {
        try {
            String key = MESSAGE_ATZ_CACHE_FAIL_KEY + this.cacheMessageKeyForAtz(message, tag);
            this.redisTemplate.opsForValue().set((Object)key, (Object)(this.messageConsumeCount(key) + 1), 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("MqReceiver.cacheFailMessage is error tag:{}", (Object)tag, (Object)e);
        }
    }

    private boolean repeatMessage(ImConversationMsgDto message, long tag) {
        try {
            return this.messageConsumeCount(MESSAGE_CACHE_KEY + this.cacheMessageKey(message, tag)) > 0;
        }
        catch (Exception e) {
            log.error("MqReceiver.repeatMessage is error tag:{}", (Object)tag, (Object)e);
            return false;
        }
    }

    private boolean repeatMessageForAtz(AtzMessageDto mapParam, long tag) {
        try {
            return this.messageConsumeCount(MESSAGE_ATZ_CACHE_KEY + this.cacheMessageKeyForAtz(mapParam, tag)) > 0;
        }
        catch (Exception e) {
            log.error("MqReceiver.repeatMessage is error tag:{}", (Object)tag, (Object)e);
            return false;
        }
    }

    private boolean messageFailRetryMax(ImConversationMsgDto message, long tag) {
        try {
            return this.messageConsumeCount(MESSAGE_CACHE_FAIL_KEY + this.cacheMessageKey(message, tag)) >= 2;
        }
        catch (Exception e) {
            log.error("MqReceiver.messageFailRetryMax is error tag:{}", (Object)tag, (Object)e);
            return false;
        }
    }

    private boolean messageFailRetryMaxForAtz(AtzMessageDto message, long tag) {
        try {
            return this.messageConsumeCount(MESSAGE_ATZ_CACHE_FAIL_KEY + this.cacheMessageKeyForAtz(message, tag)) >= 2;
        }
        catch (Exception e) {
            log.error("MqReceiver.messageFailRetryMax is error tag:{}", (Object)tag, (Object)e);
            return false;
        }
    }

    private int messageConsumeCount(String cacheId) {
        Integer consumeCount = (Integer)this.redisTemplate.opsForValue().get((Object)cacheId);
        return Objects.isNull(consumeCount) ? 0 : consumeCount;
    }

    private String cacheMessageKey(ImConversationMsgDto message, long tag) {
        if (Objects.nonNull(message) && StringUtils.isBlank((CharSequence)message.getMsgidServer())) {
            return Long.toString(tag);
        }
        if (Objects.nonNull(message) && StringUtils.isNotBlank((CharSequence)message.getMsgidServer())) {
            return message.getMsgidServer();
        }
        return null;
    }

    private String cacheMessageKeyForAtz(AtzMessageDto message, long tag) {
        if (Objects.nonNull(message) && StringUtils.isBlank((CharSequence)message.getId())) {
            return Long.toString(tag);
        }
        if (Objects.nonNull(message) && StringUtils.isNotBlank((CharSequence)message.getId())) {
            return message.getId();
        }
        return null;
    }

    @RabbitListener(queues={"${yunxin.msgQueueName}"}, ackMode="MANUAL")
    public void receiveCCMsg(String message, Channel channel, @Header(value="amqp_deliveryTag") long tag) throws IOException {
        block20: {
            log.info("MqReceiver.receiveCCMsg tag:{} msg:{}", (Object)tag, (Object)message);
            Map paramMap = (Map)JSONObject.parseObject((String)message, Map.class);
            log.info("MqReceiver.receiveCCMsg paramMap :{}", (Object)JSONObject.toJSONString((Object)paramMap));
            Map messageMap = (Map)JSONObject.parseObject((String)String.valueOf(paramMap.get("message")), Map.class);
            log.info("MqReceiver.receiveCCMsg messageMap :{}", (Object)JSONObject.toJSONString((Object)messageMap));
            AppAuthContext appAuthContext = (AppAuthContext)JSON.parseObject((String)((String)messageMap.get("context")), AppAuthContext.class);
            if (Objects.nonNull(appAuthContext)) {
                AppAuthContextHolder.getContext().setAuthoredUser(appAuthContext.getAuthoredUser());
            }
            String messageStr = (String)messageMap.get("messageStr");
            ImConversationMsgDto imConversationMsgDto = new ImConversationMsgDto();
            if (this.envProperties.getSupplierType().equals(SupplierTypeEnum.AGORA.getValue())) {
                try {
                    ReceiveMessageDTO message1 = (ReceiveMessageDTO)JSONObject.parseObject((String)messageStr, ReceiveMessageDTO.class);
                    ReceiveMessage receiveMessage = MessageAssembler.messageToDO((ReceiveMessageDTO)message1);
                    imConversationMsgDto = this.covertReceiveMessageToImConversationMsgDto(receiveMessage);
                    Assistant assistant = this.assistantService.getAssistant(((JSONObject)JSONObject.parseObject((String)imConversationMsgDto.getExt(), JSONObject.class)).getString("skillType"));
                    imConversationMsgDto.setCustomerAccId(assistant.getAccid());
                    MDC.put((String)"serverAccid", (String)assistant.getAccid());
                    imConversationMsgDto.setAssistantSubType(assistant.getAssistantSubType());
                    imConversationMsgDto.setAssistant(assistant);
                    log.info("\u6536\u5230agora\u6d88\u606f\uff1a{}", (Object)messageStr);
                    if (!this.repeatMessage(imConversationMsgDto, tag)) {
                        this.imService.singleChatReceive(imConversationMsgDto);
                    }
                    this.cacheMessage(imConversationMsgDto, tag);
                    channel.basicAck(tag, false);
                }
                catch (Exception e) {
                    log.error("MqReceiver.receiveCCMsg is error tag:{} msg:{}", new Object[]{tag, messageStr, e});
                    if (this.repeatMessage(imConversationMsgDto, tag) || this.messageFailRetryMax(imConversationMsgDto, tag)) {
                        channel.basicNack(tag, false, false);
                        break block20;
                    }
                    this.cacheFailMessage(imConversationMsgDto, tag);
                    channel.basicNack(tag, false, true);
                }
            } else if (this.envProperties.getSupplierType().equals(SupplierTypeEnum.YUNXIN.getValue())) {
                try {
                    log.info("MqReceiver.receiveCCMsg tag:{} msg:{}", (Object)tag, (Object)messageStr);
                    imConversationMsgDto = (ImConversationMsgDto)JSON.parseObject((String)messageStr, ImConversationMsgDto.class);
                    Assistant assistant = this.assistantService.getAssistant(((JSONObject)JSONObject.parseObject((String)imConversationMsgDto.getExt(), JSONObject.class)).getString("skillType"));
                    log.info("\u52a9\u7406\u4e3aassistant:{}", (Object)JSONObject.toJSONString((Object)assistant));
                    imConversationMsgDto.setCustomerAccId(assistant.getAccid());
                    MDC.put((String)"serverAccid", (String)assistant.getAccid());
                    imConversationMsgDto.setAssistantSubType(assistant.getAssistantSubType());
                    imConversationMsgDto.setAssistant(assistant);
                    log.info("MqReceiver.receiveCCMsg convert msg:{}", (Object)imConversationMsgDto);
                    if (!this.repeatMessage(imConversationMsgDto, tag)) {
                        this.imService.singleChatReceive(imConversationMsgDto);
                    }
                    this.cacheMessage(imConversationMsgDto, tag);
                    channel.basicAck(tag, false);
                }
                catch (Exception e) {
                    log.error("MqReceiver.receiveCCMsg is error tag:{} msg:{}", new Object[]{tag, messageStr, e});
                    if (this.repeatMessage(imConversationMsgDto, tag) || this.messageFailRetryMax(imConversationMsgDto, tag)) {
                        channel.basicNack(tag, false, false);
                        break block20;
                    }
                    this.cacheFailMessage(imConversationMsgDto, tag);
                    channel.basicNack(tag, false, true);
                }
            } else if (this.envProperties.getSupplierType().equals(SupplierTypeEnum.OPENFIRE.getValue())) {
                try {
                    Object body;
                    log.info("MqReceiver.receiveCCMsg tag:{} msg:{}", (Object)tag, (Object)messageStr);
                    JSONObject jsonObject = (JSONObject)JSON.parseObject((String)messageStr, JSONObject.class);
                    JSONObject extMap = new JSONObject();
                    extMap = jsonObject.getString("msgExt").startsWith("\"") ? JSONObject.parseObject((String)jsonObject.getString("msgExt").substring(1, jsonObject.getString("msgExt").length() - 1).replace("\\", "")) : JSONObject.parseObject((String)jsonObject.getString("msgExt"));
                    imConversationMsgDto.setExt(extMap.toJSONString());
                    imConversationMsgDto.setTo(jsonObject.getString("to").split("@")[0]);
                    imConversationMsgDto.setFromAccount(jsonObject.getString("from").split("@")[0]);
                    imConversationMsgDto.setBody(jsonObject.getString("body"));
                    imConversationMsgDto.setMsgType(jsonObject.getString("msgType"));
                    imConversationMsgDto.setMsgidServer(jsonObject.getString("msgId"));
                    imConversationMsgDto.setMsgidClient(jsonObject.getString("msgId"));
                    imConversationMsgDto.setFromClientType(jsonObject.getString("fromClientType"));
                    if (imConversationMsgDto.getMsgType().equals(ImConstants.ImMsgTypeEnum.TEXT.getTypeChar())) {
                        body = null;
                        body = jsonObject.getString("body").startsWith("\"") ? jsonObject.getString("body").substring(1, jsonObject.getString("body").length() - 1).replace("\\", "") : jsonObject.getString("body");
                        imConversationMsgDto.setBody((String)body);
                    } else {
                        body = new JSONObject();
                        body = jsonObject.getString("body").startsWith("\"") ? JSONObject.parseObject((String)jsonObject.getString("body").substring(1, jsonObject.getString("body").length() - 1).replace("\\", "")) : JSONObject.parseObject((String)jsonObject.getString("body"));
                        imConversationMsgDto.setAttach(body.toJSONString());
                    }
                    imConversationMsgDto.setMsgTimestamp(Long.valueOf(System.currentTimeMillis()));
                    Assistant assistant = this.assistantService.getAssistant(((JSONObject)JSONObject.parseObject((String)imConversationMsgDto.getExt(), JSONObject.class)).getString("skillType"));
                    log.info("\u52a9\u7406\u4e3aassistant:{}", (Object)JSONObject.toJSONString((Object)assistant));
                    imConversationMsgDto.setCustomerAccId(assistant.getAccid());
                    MDC.put((String)"serverAccid", (String)assistant.getAccid());
                    imConversationMsgDto.setAssistantSubType(assistant.getAssistantSubType());
                    imConversationMsgDto.setAssistant(assistant);
                    log.info("MqReceiver.receiveCCMsg convert msg:{}", (Object)imConversationMsgDto);
                    if (!this.repeatMessage(imConversationMsgDto, tag)) {
                        this.imService.singleChatReceive(imConversationMsgDto);
                    }
                    this.cacheMessage(imConversationMsgDto, tag);
                    channel.basicAck(tag, false);
                }
                catch (Exception e) {
                    log.error("MqReceiver.receiveCCMsg is error tag:{} msg:{}", new Object[]{tag, messageStr, e});
                    if (this.repeatMessage(imConversationMsgDto, tag) || this.messageFailRetryMax(imConversationMsgDto, tag)) {
                        channel.basicNack(tag, false, false);
                    }
                    this.cacheFailMessage(imConversationMsgDto, tag);
                    channel.basicNack(tag, false, true);
                }
            }
        }
    }

    @RabbitListener(queues={"${yunxin.knowledgeQueueName}"}, ackMode="MANUAL")
    public void receiveKnowledgeMessage(String message, Channel channel, @Header(value="amqp_deliveryTag") long tag) throws IOException {
        log.info("MqReceiver.receiveKnowledgeMessage message :{}", (Object)message);
        try {
            SendMqYunxinMsg messageContent = (SendMqYunxinMsg)JSONObject.parseObject((String)message, SendMqYunxinMsg.class);
            if (MapUtils.isEmpty((Map)messageContent.getCustomMsg()) && StringUtils.isBlank((CharSequence)messageContent.getText())) {
                channel.basicAck(tag, false);
                return;
            }
            log.info("MqReceiver.receiveKnowledgeMessage messageContent :{}", (Object)messageContent);
            Long msgId = this.sendQuestMessage(messageContent);
            if (msgId != null) {
                channel.basicAck(tag, false);
                this.extAction(messageContent, msgId.longValue());
            } else if (this.messageFailRetryMax(null, tag)) {
                channel.basicNack(tag, false, false);
            } else {
                this.cacheFailMessage(null, tag);
                channel.basicNack(tag, false, true);
            }
        }
        catch (Exception e) {
            log.error("MqReceiver.receiveKnowledgeMessage is error tag:{} msg:{}", new Object[]{tag, message, e});
            if (this.messageFailRetryMax(null, tag)) {
                channel.basicNack(tag, false, false);
            }
            this.cacheFailMessage(null, tag);
            channel.basicNack(tag, false, true);
        }
    }

    public Long sendQuestMessage(SendMqYunxinMsg messageContent) {
        Long msgId;
        Map extParam = messageContent.getExtParam();
        String assistantSubType = extParam.getOrDefault("assistantSubType", "").toString();
        if (StrUtil.isNotBlank((CharSequence)assistantSubType) && assistantSubType.equals(AssistantSubTypeEnum.KNOWLEAGE.getType().toString())) {
            SendMqYunxinMsg sendMqYunxinMsgClone = (SendMqYunxinMsg)ObjectUtil.clone((Object)messageContent);
            JSONObject msgExt = sendMqYunxinMsgClone.getMsgExt();
            msgExt.remove((Object)"contentId");
            msgId = this.sendMessage(sendMqYunxinMsgClone, 3);
        } else {
            msgId = this.sendMessage(messageContent, 3);
        }
        return msgId;
    }

    private Long sendMessage(SendMqYunxinMsg messageContent, int retryNum) {
        CustomMsg customMsg = null;
        TextMsg textMsg = null;
        if (MapUtils.isNotEmpty((Map)messageContent.getCustomMsg())) {
            customMsg = messageContent.buildCustomMsg();
        } else {
            textMsg = messageContent.buildTextMsg();
        }
        while (retryNum > 0) {
            ResultBean resultBean;
            --retryNum;
            boolean knowledge = LimitUtil.isAllowed((String)"knowledge", (int)this.sendLimit);
            if (!knowledge || (resultBean = Objects.nonNull(customMsg) ? this.messageHelper.pushCustomMessage(customMsg) : this.messageHelper.pushTextMessage(textMsg)).getStatus() != 200 || !Objects.nonNull(((ImSendMsgResult)resultBean.getResponse()).getMsgId())) continue;
            return ((ImSendMsgResult)resultBean.getResponse()).getMsgId();
        }
        return null;
    }

    private void extAction(SendMqYunxinMsg message, long messageId) {
        try {
            if ("knowledgeProblem".equals(message.getSource())) {
                Long answerMsgId;
                JSONObject msgExt = message.getMsgExt();
                msgExt.remove((Object)"hidden");
                String selectScenes = MapUtils.getString((Map)msgExt, (Object)"selectScenes");
                Boolean msgIsEmpty = msgExt.getBoolean("msgIsEmpty");
                Map extParam = message.getExtParam();
                String contentId = MapUtils.getString((Map)extParam, (Object)"contentId");
                JSONObject newMessage = new JSONObject();
                newMessage.fluentPut("contentId", (Object)contentId);
                newMessage.fluentPut("showType", (Object)1);
                newMessage.fluentPut("knowledgeAssistantCode", (Object)message.getAssistantCode());
                newMessage.fluentPut("replyId", (Object)messageId);
                SendMqYunxinMsg answer = new SendMqYunxinMsg();
                answer.setAssistantCode(message.getAssistantCode());
                answer.setFrom(message.getTo());
                answer.setTo(message.getFrom());
                answer.setCustomMsg((Map)newMessage);
                answer.setMsgExt(msgExt);
                if (StringUtils.isBlank((CharSequence)selectScenes) && null == msgIsEmpty && (answerMsgId = this.sendMessage(answer, 3)) == null) {
                    this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
                    this.rabbitTemplate.convertAndSend(this.knowledgeQueueName, (Object)answer);
                }
                if (StringUtils.isNotBlank((CharSequence)selectScenes)) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new MultipleIntentionsEvent((Object)newMessage).setKnowledgeId(contentId).setSelectScenes(selectScenes).setExt(msgExt));
                }
                this.newConversationService.newConversationMg(message);
            }
        }
        catch (Exception e) {
            log.error("MqReceiver.extAction is error message:{}", (Object)JSON.toJSONString((Object)message), (Object)e);
        }
    }
}

