/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.service.assistant.SkillService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(CorpusDataService.class);
    @Resource
    private SkillService skillService;

    public List<LanguageTemplateBO> getLanguageTemplate(String assistantCode, Integer inspirationPhraseNum, String langCode, String tenantVersion, List<String> curentAppList) {
        if (StringUtils.isNotBlank((CharSequence)assistantCode)) {
            return this.getAssistantLanguageTemplate(assistantCode, inspirationPhraseNum, langCode, tenantVersion, curentAppList);
        }
        return Collections.emptyList();
    }

    private List<LanguageTemplateBO> getAssistantLanguageTemplate(String assistantCode, Integer inspirationPhraseNum, String langCode, String tenantVersion, List<String> curentAppList) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List assistantScenes = this.skillService.querySkillsByAssistantCode(assistantCode, langCode, authoredUser.getTenantId(), tenantVersion);
        List authorizedSceneList = this.skillService.filterNoAuthScene(assistantCode, assistantScenes, tenantVersion, curentAppList);
        return CollUtil.emptyIfNull((List)authorizedSceneList).stream().map(assistantScene -> {
            LanguageTemplateBO languageTemplateBO = new LanguageTemplateBO();
            languageTemplateBO.setAssistantCode(assistantCode);
            languageTemplateBO.setIntent(assistantScene.getSkillCode());
            languageTemplateBO.setIntentName(assistantScene.getSkillName());
            languageTemplateBO.setTop(Boolean.valueOf(null == assistantScene.getTop() ? false : assistantScene.getTop()));
            Map lang = assistantScene.getLang();
            Object inspirationPhrase = lang.getOrDefault("inspirationPhrase", null);
            if (Objects.nonNull(inspirationPhrase)) {
                List inspirationPhraseTexts;
                Map inspirationPhraseMap = inspirationPhrase;
                List returnTexts = inspirationPhraseTexts = (List)inspirationPhraseMap.getOrDefault(langCode, new ArrayList());
                if (inspirationPhraseNum != null && inspirationPhraseNum != 0 && inspirationPhraseTexts.size() > inspirationPhraseNum) {
                    languageTemplateBO.setHasMore(true);
                    Collections.shuffle(inspirationPhraseTexts);
                    returnTexts = inspirationPhraseTexts.subList(0, inspirationPhraseNum);
                }
                languageTemplateBO.setTexts(returnTexts);
            }
            return languageTemplateBO;
        }).collect(Collectors.toList());
    }
}

