/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service;

import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SSEEventService {
    private static final Logger log = LoggerFactory.getLogger(SSEEventService.class);
    @Resource
    protected SseEventDataService sseEventDataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void errorStop(SseEventParams sseEventParam, String msg) {
        try {
            if (msg == null) {
                msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            }
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), msg);
            this.sendEventData(sseEventParam, eventData);
        }
        catch (Exception ex) {
            log.error("AssistantSceneStrategy.errorStop is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
        finally {
            this.stop(sseEventParam, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(SseEventParams sseEventParam, boolean success) {
        EventData eventData = success ? new EventData(SseEventlEnum.CHAT_DONE.getEvent(), null) : new EventData(SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, eventData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)eventData);
            }
            catch (Exception e) {
                log.error("AssistantSceneStrategy.stop is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    protected void sendEventData(SseEventParams sseEventParam, EventData actionData) throws IOException {
        this.sseEventDataService.saveEventDataLog(sseEventParam, actionData);
        SseEmitterUtils.send((String)sseEventParam.getId(), (EventData)actionData);
        SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)actionData);
    }
}

