/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.agile.impl;

import com.digiwin.athena.ania.dto.agile.AgileDataFeedBackDto;
import com.digiwin.athena.ania.dto.agile.AgileDataFeedBackQueryDto;
import com.digiwin.athena.ania.eventbus.agile.event.AgileDataLogEvent;
import com.digiwin.athena.ania.mongo.domain.AgileDataResultLog;
import com.digiwin.athena.ania.mongo.repository.AgileDataResultLogMgDao;
import com.digiwin.athena.ania.service.agile.AgileReportFeedBackService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class AgileReportFeedBackServiceImpl
implements AgileReportFeedBackService {
    @Autowired
    private AsyncEventBus asyncEventBus;
    @Autowired
    private AgileDataResultLogMgDao agileDataResultLogMgDao;

    public Boolean saveFeedback(AgileDataFeedBackDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AgileDataLogEvent event = AgileDataLogEvent.builder().feedbackType(dto.getFeedbackType()).authoredUser(authoredUser).extendInfo(dto.getExtendInfo()).msgidServer(dto.getMsgidServer()).terminal("client-agent").snapshotId(dto.getSnapshotId()).answer(dto.getAnswer()).type(Integer.valueOf(2)).assistantCode(dto.getAssistantCode()).build();
        this.asyncEventBus.post((Object)event);
        return true;
    }

    public Boolean deleteFeedback(AgileDataFeedBackDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AgileDataLogEvent event = AgileDataLogEvent.builder().feedbackType(Integer.valueOf(4)).authoredUser(authoredUser).msgidServer(dto.getMsgidServer()).type(Integer.valueOf(4)).build();
        this.asyncEventBus.post((Object)event);
        return true;
    }

    public Boolean answerBack(AgileDataFeedBackDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AgileDataLogEvent event = AgileDataLogEvent.builder().answerOpinion(dto.getAnswerOpinion()).backContent(dto.getBackContent()).checkOpinions(dto.getCheckOpinions()).authoredUser(authoredUser).answer(dto.getAnswer()).msgidServer(dto.getMsgidServer()).assistantCode(dto.getAssistantCode()).type(Integer.valueOf(3)).build();
        this.asyncEventBus.post((Object)event);
        return true;
    }

    public List<AgileDataResultLog> getFeedback(AgileDataFeedBackQueryDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"msgidServer").in((Collection)dto.getMsgidServers()).and("userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()));
        return this.agileDataResultLogMgDao.findList(query);
    }
}

