/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.service.assistant.AssistantSceneService;
import com.digiwin.athena.ania.service.impl.bnaProcessor.BnaProcessor;
import com.digiwin.athena.ania.util.LanguageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssistantSceneServiceImpl
implements AssistantSceneService {
    private static final Logger log = LoggerFactory.getLogger(AssistantSceneServiceImpl.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private AssistantSceneDao assistantSceneDao;
    private Map<Integer, BnaProcessor> assistantTypeStrategyMap = new HashMap();

    @Autowired
    public void setAssistantTypeStrategyMap(Map<String, BnaProcessor> bnaProcessorMap) {
        bnaProcessorMap.forEach((k, v) -> this.assistantTypeStrategyMap.put(v.getAssistantSubType(), v));
    }

    public List<LanguageTemplateBO> querySkillsByAssistantCode(List<String> assistantCodes, Set<String> appIdList, String tenantVersion) {
        ArrayList<LanguageTemplateBO> assistantScenesList = new ArrayList<LanguageTemplateBO>();
        List assistantScenes = this.assistantSceneDao.findAllByAssistantCodeInAndVersion(assistantCodes, tenantVersion);
        if (CollUtil.isNotEmpty((Collection)assistantScenes)) {
            for (int i = 0; i < assistantScenes.size(); ++i) {
                Map nameMap;
                AssistantScene assistantScene = (AssistantScene)assistantScenes.get(i);
                LanguageTemplateBO languageTemplateBO = new LanguageTemplateBO();
                languageTemplateBO.setAssistantCode(assistantScene.getAssistantCode());
                languageTemplateBO.setIntent(assistantScene.getCode());
                languageTemplateBO.setTop(Boolean.valueOf(null == assistantScene.getTop() ? false : assistantScene.getTop()));
                languageTemplateBO.setKnowledgeBase(assistantScene.getKnowledgeBase());
                languageTemplateBO.setType(assistantScene.getType());
                languageTemplateBO.setDataMetric(assistantScene.getDataMetric());
                languageTemplateBO.setSort(assistantScene.getSort());
                Map lang = assistantScene.getLang();
                Object inspirationPhrase = lang.getOrDefault("inspirationPhrase", null);
                if (Objects.nonNull(inspirationPhrase)) {
                    Map inspirationPhraseMap = inspirationPhrase;
                    List inspirationPhraseTexts = inspirationPhraseMap.getOrDefault(LanguageUtils.processLanguage(), new ArrayList());
                    languageTemplateBO.setTexts(inspirationPhraseTexts);
                }
                if (null != (nameMap = (Map)lang.getOrDefault("name", null)) && !nameMap.isEmpty()) {
                    languageTemplateBO.setIntentName(LocalsEnum.isTw((String)LanguageUtils.processLanguage()) ? nameMap.getOrDefault(LocalsEnum.TW.getCode(), "").toString() : nameMap.getOrDefault(LocalsEnum.CN.getCode(), "").toString());
                }
                assistantScenesList.add(languageTemplateBO);
            }
        }
        return assistantScenesList;
    }

    public List<LanguageTemplateBO> filterAuthScene(AssistantConfig assistantConfig, List<LanguageTemplateBO> assistantScenes, Map<String, Map> authAppIdMapList, Set<String> authAppIds) {
        try {
            ArrayList<LanguageTemplateBO> filterAssistantScenes = new ArrayList<LanguageTemplateBO>();
            if (CollUtil.isEmpty(assistantScenes)) {
                return filterAssistantScenes;
            }
            if (null == assistantConfig.getAssistantSubType()) {
                filterAssistantScenes.addAll(assistantScenes);
                return filterAssistantScenes;
            }
            BnaProcessor bnaProcessor = (BnaProcessor)this.assistantTypeStrategyMap.get(assistantConfig.getAssistantSubType());
            if (Objects.nonNull(bnaProcessor)) {
                bnaProcessor.filterAuthScene(filterAssistantScenes, assistantConfig, assistantScenes, authAppIdMapList, authAppIds);
            } else {
                filterAssistantScenes.addAll(assistantScenes);
            }
            List sortedScene = this.sortScene(filterAssistantScenes);
            return sortedScene;
        }
        catch (Exception e) {
            log.error("AssistantSceneServiceImpl.filterAuthScene error assistantConfig:{}", (Object)JSONUtil.toJsonStr((Object)assistantConfig), (Object)e);
            return new ArrayList<LanguageTemplateBO>();
        }
    }

    private List<LanguageTemplateBO> sortScene(List<LanguageTemplateBO> assistantScenes) {
        if (assistantScenes == null || assistantScenes.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Boolean, List<LanguageTemplateBO>> partitioned = assistantScenes.stream().collect(Collectors.partitioningBy(item -> Objects.nonNull(item.getSort())));
        List sortedWithSort = partitioned.getOrDefault(true, Collections.emptyList()).stream().sorted(Comparator.comparingInt(LanguageTemplateBO::getSort)).collect(Collectors.toList());
        List noSort = partitioned.getOrDefault(false, Collections.emptyList());
        ArrayList<LanguageTemplateBO> result = new ArrayList<LanguageTemplateBO>(sortedWithSort);
        result.addAll(noSort);
        return result;
    }
}

