/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantPlugin;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantPluginMgDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantPluginService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class FusionAssistantPluginServiceImpl
implements FusionAssistantPluginService {
    @Autowired
    private FusionAssistantPluginMgDao fusionAssistantPluginMgDao;

    public void insertAll(List<FusionAssistantPlugin> fusionAssistantPlugins) {
        if (CollUtil.isNotEmpty(fusionAssistantPlugins)) {
            fusionAssistantPlugins.forEach(assistant -> this.fusionAssistantPluginMgDao.remove(assistant.getAssistantId(), assistant.getVersion()));
            this.fusionAssistantPluginMgDao.insertAll(fusionAssistantPlugins);
        }
    }

    public List<Map> findPlugins(String assistantId, String version) {
        List fusionAssistantPlugins = this.fusionAssistantPluginMgDao.find(assistantId, version);
        if (CollUtil.isNotEmpty((Collection)fusionAssistantPlugins)) {
            return fusionAssistantPlugins.stream().map(plugin -> plugin.getPluginCustom()).collect(Collectors.toList());
        }
        return new ArrayList<Map>();
    }

    public Map<String, List<Map>> findPlugins(List<String> assistantIds, String version) {
        List assistantPlugins = this.fusionAssistantPluginMgDao.findList(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").in(assistantIds).and("version").is((Object)version)));
        if (CollectionUtils.isNotEmpty((Collection)assistantPlugins)) {
            return assistantPlugins.stream().collect(Collectors.groupingBy(FusionAssistantPlugin::getAssistantId, Collectors.mapping(FusionAssistantPlugin::getPluginCustom, Collectors.toList())));
        }
        return new HashMap<String, List<Map>>();
    }
}

