/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.repository.AppAssistantRelationDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.assistant.strategy.AssistantCollectService;
import com.digiwin.athena.ania.service.assistant.strategy.PublishAssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class FusionAssistantServiceImpl
implements FusionAssistantService {
    private static final Logger log = LoggerFactory.getLogger(FusionAssistantServiceImpl.class);
    @Autowired
    private CacHelper cacHelper;
    @Autowired
    private PublishAssistantService publishAssistantService;
    @Autowired
    private ConversationService conversationService;
    private Map<Integer, AssistantCollectService> assistantTypeMap = new HashMap();
    @Resource
    private ExecutorService assistantListExecutor;
    @Resource
    private AppAssistantRelationDao appAssistantRelationDao;

    @Autowired
    public void setAssistantTypeMap(Map<String, AssistantCollectService> assistantCollectServiceMap) {
        assistantCollectServiceMap.forEach((k, v) -> this.assistantTypeMap.put(v.getAssistantType(), v));
    }

    public void publish(FusionAssistantPublishDto dto) {
        this.publishAssistantService.publish(dto);
    }

    public void unPublish(FusionAssistantPublishDto dto) {
        this.publishAssistantService.unPublish(dto);
    }

    public List<FusionAssistantVo> assistantList(String clientType, Boolean simple) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List assistantVos = this.queryUserAuthedFusionAssistants(authoredUser, clientType, simple);
        List assistantIds = assistantVos.stream().filter(item -> !Objects.equals(AssistantType.EMBEDDED_ASSISTANT.getType(), item.getAssistantType())).map(FusionAssistantVo::getAssistantId).collect(Collectors.toList());
        List conversations = this.conversationService.queryRecentAgents(assistantIds, assistantVos.size());
        List fusionAssistantVos = FusionAssistantVo.sort((List)assistantVos, (List)conversations);
        return fusionAssistantVos;
    }

    public FusionAssistantVo assistantInfo(FusionAssistantInfoDto dto) {
        return this.assistantDetailsInfo(dto, AppAuthContextHolder.getContext().getAuthoredUser());
    }

    public FusionAssistantVo assistantBaseInfo(FusionAssistantInfoDto param) {
        return this.assistantBaseInfo(param, AppAuthContextHolder.getContext().getAuthoredUser());
    }

    private List<FusionAssistantVo> queryUserAuthedFusionAssistants(AuthoredUser authoredUser, String clientType, Boolean simple) {
        ArrayList<FusionAssistantVo> fusionAssistantVos = new ArrayList<FusionAssistantVo>();
        ArrayList futures = new ArrayList();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        List currentAppCodes = this.cacHelper.getCurrentAppCodes(authoredUser.getToken());
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        String traceId = MdcUtil.getTraceId();
        this.assistantTypeMap.values().forEach(v -> {
            Future<List> future = this.assistantListExecutor.submit(() -> {
                try {
                    MdcUtil.setTraceId((String)traceId);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    LocaleContextHolder.setLocale((Locale)Locale.forLanguageTag(langName));
                    List list = v.assistantList(authoredUser, currentAppCodes, clientType, Boolean.valueOf(Objects.nonNull(simple) ? simple : false));
                    return list;
                }
                finally {
                    MdcUtil.clear();
                    LocaleContextHolder.resetLocaleContext();
                    RequestContextHolder.resetRequestAttributes();
                }
            });
            futures.add(future);
        });
        for (Future future : futures) {
            try {
                fusionAssistantVos.addAll((Collection)future.get());
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u52a9\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        return fusionAssistantVos;
    }

    public FusionAssistantVo assistantBaseInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        if (Objects.nonNull(param.getAssistantType())) {
            return ((AssistantCollectService)this.assistantTypeMap.get(param.getAssistantType())).assistantBaseInfo(param, authoredUser);
        }
        ApplicationAssistantRelation assistantRelation = this.appAssistantRelationDao.queryAssistantRelation(param.getAssistantId());
        if (Objects.isNull(assistantRelation)) {
            return ((AssistantCollectService)this.assistantTypeMap.get(AssistantType.EMBEDDED_ASSISTANT.getType())).assistantBaseInfo(param, authoredUser);
        }
        return ((AssistantCollectService)this.assistantTypeMap.get(assistantRelation.getAssistantType())).assistantBaseInfo(param, authoredUser);
    }

    public FusionAssistantVo assistantDetailsInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        if (Objects.nonNull(param.getAssistantType())) {
            return ((AssistantCollectService)this.assistantTypeMap.get(param.getAssistantType())).assistantDetailsInfo(param, authoredUser);
        }
        ApplicationAssistantRelation assistantRelation = this.appAssistantRelationDao.queryAssistantRelation(param.getAssistantId());
        if (Objects.isNull(assistantRelation)) {
            return ((AssistantCollectService)this.assistantTypeMap.get(AssistantType.EMBEDDED_ASSISTANT.getType())).assistantDetailsInfo(param, authoredUser);
        }
        return ((AssistantCollectService)this.assistantTypeMap.get(assistantRelation.getAssistantType())).assistantDetailsInfo(param, authoredUser);
    }
}

