/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.PublishAssistantChannel;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.common.exception.FusionException;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.dto.nna.CreateCommandDto;
import com.digiwin.athena.ania.dto.nna.DeleteCommandDto;
import com.digiwin.athena.ania.dto.nna.ListCommandDto;
import com.digiwin.athena.ania.dto.nna.UseCommandDto;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.SkcHelper;
import com.digiwin.athena.ania.helper.dto.skc.SkcSessionAddDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSessionUpdateDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSkillPublishDto;
import com.digiwin.athena.ania.helper.dto.skc.command.CreateCommandSetsBrushDto;
import com.digiwin.athena.ania.helper.dto.skc.command.CreateCommandSetsDto;
import com.digiwin.athena.ania.helper.dto.skc.command.DeleteCommandSetsDto;
import com.digiwin.athena.ania.helper.dto.skc.command.ListCommandSetDto;
import com.digiwin.athena.ania.helper.dto.skc.command.UseCommandSetsDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantEventRecord;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantMgDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantRecordService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.assistant.SkcService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SkcServiceImpl
implements SkcService {
    private static final Logger log = LoggerFactory.getLogger(SkcServiceImpl.class);
    @Value(value="${ania.skc.channel-enable:false}")
    private boolean skcChannelEnable;
    @Value(value="${ania.skc.tag-id}")
    private String tagId;
    @Value(value="${ania.skc.web-url}")
    private String webUrl;
    @Value(value="${ania.skc.app-default-icon}")
    private String appIcon;
    @Value(value="${ania.skc.publish-source-type}")
    private String publishSourceType;
    @Autowired
    private SkcHelper skcHelper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private FusionAssistantMgDao fusionAssistantMgDao;
    @Autowired
    private FusionAssistantRecordService fusionAssistantRecordService;
    @Lazy
    @Autowired
    private FusionAssistantService fusionAssistantService;
    @Autowired
    private CacHelper cacHelper;

    public void skcPublish(List<String> skcAssistantIds, List<FusionAssistantSub> fusionAssistantSubs, FusionAssistantPublishDto dto) {
        block6: {
            block5: {
                if (!this.skcChannelEnable && !dto.getPublishNna().booleanValue()) break block5;
                String language = this.skcHelper.getLanguage();
                String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
                Map assistantIdAndUserIdMap = FusionAssistantPublishDto.getAssistantIdAndUserIdMap((List)dto.getEvent());
                for (int i = 0; i < fusionAssistantSubs.size(); ++i) {
                    FusionAssistantSub assistant = fusionAssistantSubs.get(i);
                    String assistantId = assistant.getAssistantId();
                    try {
                        String ownerUserId = this.fusionAssistantRecordService.getSkcAppOwnerUserId(assistantId, (String)assistantIdAndUserIdMap.get(assistantId));
                        SkcSkillPublishDto skcPublishDto = SkcSkillPublishDto.publish((FusionAssistantSub)assistant, (String)ownerUserId, (String)language, (String)this.appIcon, (String)this.tagId, (String)this.webUrl);
                        skcPublishDto.setSourceType(this.publishSourceType);
                        Boolean result = this.skcHelper.skillPublish(skcPublishDto, token);
                        if (result.booleanValue()) {
                            this.updateAccessChannel(assistantId, PublishAssistantChannel.SKC.getCode());
                        }
                        skcPublishDto.setAssistantVersion(assistant.getVersion());
                        FusionAssistantEventRecord fusionAssistantEventRecord = FusionAssistantEventRecord.skcPublish((SkcSkillPublishDto)skcPublishDto, (Boolean)result);
                        this.fusionAssistantRecordService.save(fusionAssistantEventRecord);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("PublishAssistantService.skcPublish.error,assistantId={}", (Object)assistantId, (Object)e);
                    }
                }
                break block6;
            }
            if (!CollUtil.isNotEmpty(skcAssistantIds)) break block6;
            for (int k = 0; k < skcAssistantIds.size(); ++k) {
                String assistantId = skcAssistantIds.get(k);
                this.updateAccessChannel(assistantId, null);
            }
        }
    }

    public void updateAccessChannel(String assistantId, String accessChannel) {
        this.fusionAssistantMgDao.updateAssistantAccessChannel(assistantId, accessChannel);
        this.refreshAssistantCache(assistantId, accessChannel);
    }

    private void refreshAssistantCache(String assistantId, String accessChannel) {
        String key = "ANIA:PUBLISH:ASSISTANT:" + assistantId;
        Object fusionAssistantStr = this.redisTemplate.opsForValue().get((Object)key);
        if (Objects.nonNull(fusionAssistantStr)) {
            FusionAssistant fusionAssistant = (FusionAssistant)JSONUtil.toBean((String)fusionAssistantStr.toString(), FusionAssistant.class);
            fusionAssistant.setAccessChannel(accessChannel);
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)fusionAssistant));
        }
    }

    @Async
    public void createSkcConversation(SseEventParams sseEventParam, Conversation conversation) {
        String accessChannel = sseEventParam.getFusionAssistant().getAccessChannel();
        if (PublishAssistantChannel.SKC.getCode().equals(accessChannel) && this.skcChannelEnable) {
            AuthoredUser user = sseEventParam.getUser();
            SkcSessionAddDto dto = new SkcSessionAddDto();
            dto.setSkillId(conversation.getAgentId());
            dto.setSessionTitle(conversation.getSessionTitle());
            dto.setSessionId(conversation.getConversationId());
            this.skcHelper.sessionAdd(dto, sseEventParam.getAppAuthContext());
        }
    }

    public void sessionUpdate(SseEventParams sseEventParams, ConversationMessage message) {
        try {
            String accessChannel = sseEventParams.getFusionAssistant().getAccessChannel();
            if (PublishAssistantChannel.SKC.getCode().equals(accessChannel) && this.skcChannelEnable && message.getUserType() == 2) {
                SkcSessionUpdateDto sessionUpdateDto = new SkcSessionUpdateDto();
                sessionUpdateDto.setSessionId(message.getConversationId());
                sessionUpdateDto.setSkillId(message.getAgentId());
                List content = message.getContent();
                List types = content.stream().map(item -> item.get("type").toString()).collect(Collectors.toList());
                String sessionContent = types.contains(SseEventlEnum.EventDataMessageEnum.CARD.getMessageType()) ? SseEventlEnum.EventDataMessageEnum.CARD.getDesc() : (types.contains(SseEventlEnum.EventDataMessageEnum.FILE.getMessageType()) ? SseEventlEnum.EventDataMessageEnum.FILE.getDesc() : (types.contains(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType()) ? content.stream().filter(item -> SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType().equals(item.get("type").toString())).map(item -> item.get("text").toString()).collect(Collectors.joining()) : "\u5185\u5bb9\u89e3\u6790\u5f02\u5e38"));
                sessionUpdateDto.setSessionContent(sessionContent);
                this.skcHelper.sessionUpdate(sessionUpdateDto, sseEventParams.getAppAuthContext());
            }
        }
        catch (Exception e) {
            log.error("SkcService.sessionUpdate.error,message={}", (Object)JSONUtil.toJsonStr((Object)message), (Object)e);
        }
    }

    public void createCommand(CreateCommandDto dto) {
        FusionAssistantVo fusionAssistantVo = this.getfusionAssistantVo(dto.getAssistantId());
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        CreateCommandSetsDto createCommandSetsDto = CreateCommandSetsDto.build((CreateCommandDto)dto, (FusionAssistantVo)fusionAssistantVo);
        this.skcHelper.createCommandSet(createCommandSetsDto, token);
    }

    public void createCommandBrush(CreateCommandSetsBrushDto dto) {
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        this.skcHelper.createCommandSetBrush(dto, token);
    }

    public void deleteCommand(DeleteCommandDto dto) {
        JSONArray records;
        ListCommandDto listCommandMap = new ListCommandDto();
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("use_time");
        listCommandMap.setOrders((List)ListUtil.toList((Object[])new OrderItem[]{orderItem}));
        listCommandMap.setAssistantId(dto.getAssistantId());
        listCommandMap.setCategories((List)ListUtil.toList((Object[])new String[]{"common_instruction", "instruction_temp"}));
        JSONObject listCommand = this.listCommand(listCommandMap);
        if (null != listCommand && !listCommand.isEmpty() && CollUtil.isNotEmpty((Collection)(records = listCommand.getJSONArray("records")))) {
            for (int i = 0; i < records.size(); ++i) {
                JSONObject record = records.getJSONObject(i);
                String id = record.getString("id");
                if (!dto.getId().equals(id) || !"enterprise".equals(record.getString("type"))) continue;
                boolean isTw = LocalsEnum.isTw((String)LanguageUtils.processLanguage());
                throw new FusionException(isTw ? "\u5168\u5c40\u5e38\u7528\u8a9e\u8acb\u524d\u5f80\u5e38\u7528\u8a9e\u7ba1\u7406\u5f8c\u81fa\u522a\u9664\uff01" : "\u5168\u5c40\u5e38\u7528\u8bed\u8bf7\u524d\u5f80\u5e38\u7528\u8bed\u7ba1\u7406\u540e\u53f0\u5220\u9664\uff01");
            }
        }
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        DeleteCommandSetsDto deleteCommandSetsDto = DeleteCommandSetsDto.build((DeleteCommandDto)dto);
        this.skcHelper.deleteCommandSet(deleteCommandSetsDto, token);
    }

    public JSONObject listCommand(ListCommandDto dto) {
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        ListCommandSetDto listCommandSetDto = ListCommandSetDto.build((ListCommandDto)dto);
        return this.skcHelper.listCommandSet(listCommandSetDto, token);
    }

    public void use(UseCommandDto dto) {
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        UseCommandSetsDto useCommandSetsDto = new UseCommandSetsDto(dto.getId());
        this.skcHelper.useCommandSet(useCommandSetsDto, token);
    }

    private FusionAssistantVo getfusionAssistantVo(String assistantId) {
        if (StrUtil.isEmpty((CharSequence)assistantId)) {
            return null;
        }
        boolean isTw = LocalsEnum.isTw((String)LanguageUtils.processLanguage());
        FusionAssistantInfoDto dto = new FusionAssistantInfoDto();
        dto.setAssistantType(AssistantType.PUBLISH_ASSISTANT.getType());
        dto.setAssistantId(assistantId);
        FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(dto);
        return fusionAssistantVo;
    }

    public Boolean getNnaAuth() {
        return true;
    }

    private void checkNNaAuth() {
        boolean nna = this.getNnaAuth();
        boolean isTw = LocalsEnum.isTw((String)LanguageUtils.processLanguage());
        Assert.isTrue((boolean)nna, () -> new FusionException(isTw ? "\u672a\u6388\u6b0aNNA\u6b0a\u9650\uff0c\u7121\u6cd5\u4f7f\u7528\u5e38\u7528\u8a9e\u529f\u80fd\uff01" : "\u672a\u6388\u6743NNA\uff0c\u65e0\u6cd5\u4f7f\u7528\u5e38\u7528\u8bed\u529f\u80fd\uff01"));
    }
}

